/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager;

import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.security.manager.DeploymentPermissionsResourceDefinition;
import org.wildfly.extension.security.manager.Namespace;
import org.wildfly.extension.security.manager.SecurityManagerRootDefinition;
import org.wildfly.extension.security.manager.SecurityManagerSubsystemParser_1_0;
import org.wildfly.extension.security.manager.SecurityManagerSubsystemParser_3_0;
import org.wildfly.extension.security.manager.logging.SecurityManagerLogger;

public class SecurityManagerExtension
implements Extension {
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"security-manager");
    protected static final String RESOURCE_NAME = SecurityManagerExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 3;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)3, (int)0, (int)0);
    private static final ModelVersion EAP_7_0_0_MODEL_VERSION = ModelVersion.create((int)2, (int)0, (int)0);

    public static StandardResourceDescriptionResolver getResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder("security-manager");
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, SecurityManagerExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem("security-manager", CURRENT_MODEL_VERSION);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)SecurityManagerRootDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)SecurityManagerSubsystemParser_3_0.INSTANCE);
        this.registerTransformers_EAP_7_0_0(subsystem);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping("security-manager", Namespace.SECURITY_MANAGER_1_0.getUriString(), (XMLElementReader)SecurityManagerSubsystemParser_1_0.INSTANCE);
        context.setSubsystemXmlMapping("security-manager", Namespace.SECURITY_MANAGER_3_0.getUriString(), (XMLElementReader)SecurityManagerSubsystemParser_3_0.INSTANCE);
    }

    private void registerTransformers_EAP_7_0_0(SubsystemRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.addChildResource(DeploymentPermissionsResourceDefinition.DEPLOYMENT_PERMISSIONS_PATH).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode value, TransformationContext context) {
                return value.isDefined() && value.asList().isEmpty();
            }

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return SecurityManagerLogger.ROOT_LOGGER.rejectedEmptyMaximumSet();
            }
        }, new AttributeDefinition[]{DeploymentPermissionsResourceDefinition.MAXIMUM_PERMISSIONS});
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystemRegistration, (ModelVersionRange)EAP_7_0_0_MODEL_VERSION);
    }
}

