/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.requestcontroller.RequestController;

class MaxRequestsWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    private final AttributeDefinition attributeDefinition;
    private final RequestController requestController;

    MaxRequestsWriteHandler(AttributeDefinition attributeDefinition, RequestController requestController) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
        this.requestController = requestController;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.apply(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.apply(context, restored);
    }

    private void apply(OperationContext context, ModelNode model) throws OperationFailedException {
        if (this.requestController == null) {
            return;
        }
        ModelNode modelNode = this.attributeDefinition.resolveModelAttribute(context, model);
        if (!modelNode.isDefined()) {
            this.requestController.setMaxRequestCount(-1);
        } else {
            this.requestController.setMaxRequestCount(modelNode.asInt());
        }
    }
}

