/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.requestcontroller.RequestControllerDeploymentUnitProcessor;
import org.wildfly.extension.requestcontroller.RequestControllerRootDefinition;

class RequestControllerSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private final RequestController requestController;

    RequestControllerSubsystemAdd(RequestController requestController) {
        this.requestController = requestController;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : RequestControllerRootDefinition.ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("request-controller", Phase.STRUCTURE, 8192, (DeploymentUnitProcessor)new RequestControllerDeploymentUnitProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        super.performRuntime(context, operation, model, verificationHandler, newControllers);
        int maxRequests = RequestControllerRootDefinition.MAX_REQUESTS.resolveModelAttribute(context, model).asInt();
        this.requestController.setMaxRequestCount(maxRequests);
        context.getServiceTarget().addService(RequestController.SERVICE_NAME, (Service)this.requestController).addDependency(SuspendController.SERVICE_NAME, SuspendController.class, this.requestController.getShutdownControllerInjectedValue()).install();
    }
}

