/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.wildfly.common.context.Contextual;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public class EndpointService
implements Service<Endpoint> {
    protected final String endpointName;
    protected volatile Endpoint endpoint;
    protected final OptionMap optionMap;
    private final InjectedValue<XnioWorker> worker = new InjectedValue();

    public EndpointService(String nodeName, EndpointType type, OptionMap optionMap) {
        if (nodeName == null) {
            nodeName = "remote";
        }
        this.endpointName = type == EndpointType.SUBSYSTEM ? nodeName : nodeName + ":" + (Object)((Object)type);
        this.optionMap = optionMap;
    }

    InjectedValue<XnioWorker> getWorker() {
        return this.worker;
    }

    public void start(StartContext context) throws StartException {
        Endpoint endpoint;
        EndpointBuilder builder = Endpoint.builder();
        builder.setEndpointName(this.endpointName);
        builder.setXnioWorker((XnioWorker)this.worker.getValue());
        try {
            endpoint = builder.build();
        }
        catch (IOException e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotStart(e);
        }
        Endpoint.ENDPOINT_CONTEXT_MANAGER.setGlobalDefault((Contextual)endpoint);
        this.endpoint = endpoint;
    }

    public void stop(StopContext context) {
        context.asynchronous();
        Endpoint endpoint = this.endpoint;
        this.endpoint = null;
        try {
            endpoint.closeAsync();
        }
        finally {
            endpoint.addCloseHandler((closed, exception) -> {
                context.complete();
                Endpoint.ENDPOINT_CONTEXT_MANAGER.setGlobalDefault(null);
            });
        }
    }

    public Endpoint getValue() throws IllegalStateException {
        Endpoint endpoint = this.endpoint;
        if (endpoint == null) {
            throw RemotingLogger.ROOT_LOGGER.endpointEmpty();
        }
        return endpoint;
    }

    public static enum EndpointType {
        MANAGEMENT,
        SUBSYSTEM;

    }
}

