/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.RemotingSubsystemAdd;
import org.jboss.as.remoting.WorkerThreadPoolVsEndpointHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.Endpoint;

public class RemotingSubsystemRootResource
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition WORKER_READ_THREADS = RemotingSubsystemRootResource.createIntAttribute("worker-read-threads", Attribute.WORKER_READ_THREADS, 1);
    static final SimpleAttributeDefinition WORKER_TASK_CORE_THREADS = RemotingSubsystemRootResource.createIntAttribute("worker-task-core-threads", Attribute.WORKER_TASK_CORE_THREADS, 4);
    static final SimpleAttributeDefinition WORKER_TASK_KEEPALIVE = RemotingSubsystemRootResource.createIntAttribute("worker-task-keepalive", Attribute.WORKER_TASK_KEEPALIVE, 60);
    static final SimpleAttributeDefinition WORKER_TASK_LIMIT = RemotingSubsystemRootResource.createIntAttribute("worker-task-limit", Attribute.WORKER_TASK_LIMIT, 16384);
    static final SimpleAttributeDefinition WORKER_TASK_MAX_THREADS = RemotingSubsystemRootResource.createIntAttribute("worker-task-max-threads", Attribute.WORKER_TASK_MAX_THREADS, 16);
    static final SimpleAttributeDefinition WORKER_WRITE_THREADS = RemotingSubsystemRootResource.createIntAttribute("worker-write-threads", Attribute.WORKER_WRITE_THREADS, 1);
    static final PathElement PATH = PathElement.pathElement((String)"subsystem", (String)"remoting");
    static AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{WORKER_READ_THREADS, WORKER_TASK_CORE_THREADS, WORKER_TASK_KEEPALIVE, WORKER_TASK_LIMIT, WORKER_TASK_MAX_THREADS, WORKER_WRITE_THREADS};
    static final String IO_WORKER_CAPABILITY = "org.wildfly.io.worker";
    static final RuntimeCapability<Void> REMOTING_ENDPOINT_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.remoting.endpoint", Endpoint.class).build();

    public RemotingSubsystemRootResource() {
        super(new SimpleResourceDefinition.Parameters(PATH, RemotingExtension.getResourceDescriptionResolver("remoting")).setAddHandler((OperationStepHandler)RemotingSubsystemAdd.INSTANCE).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler()).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : ATTRIBUTES) {
            this.registerReadWriteIntAttribute(resourceRegistration, attribute);
        }
    }

    private void registerReadWriteIntAttribute(ManagementResourceRegistration resourceRegistration, AttributeDefinition attr) {
        resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new ThreadWriteAttributeHandler(attr));
    }

    private static SimpleAttributeDefinition createIntAttribute(String name, Attribute attribute, int defaultValue) {
        return ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)name, (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode().set(defaultValue))).setXmlName(attribute.getLocalName())).setValidator((ParameterValidator)new IntRangeValidator(1, true))).setAllowExpression(true)).setDeprecated(ModelVersion.create((int)2, (int)0))).build();
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(REMOTING_ENDPOINT_CAPABILITY);
    }

    private static class ThreadWriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        ThreadWriteAttributeHandler(AttributeDefinition definition) {
            super("subsystem", new AttributeDefinition[]{definition});
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            RemotingSubsystemAdd.INSTANCE.launchServices(context);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return RemotingServices.SUBSYSTEM_ENDPOINT;
        }

        protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
            context.addStep(WorkerThreadPoolVsEndpointHandler.INSTANCE, OperationContext.Stage.MODEL);
        }
    }
}

