/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.OptionMap;

public class RemoteOutboundConnectionService
extends AbstractOutboundConnectionService
implements Service<RemoteOutboundConnectionService> {
    public static final ServiceName REMOTE_OUTBOUND_CONNECTION_BASE_SERVICE_NAME = RemotingServices.SUBSYSTEM_ENDPOINT.append(new String[]{"remote-outbound-connection"});
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final InjectedValue<OutboundSocketBinding> destinationOutboundSocketBindingInjectedValue = new InjectedValue();
    private final InjectedValue<SecurityRealm> securityRealmInjectedValue = new InjectedValue();
    private final InjectedValue<AuthenticationContext> authenticationContext = new InjectedValue();
    private final OptionMap connectionCreationOptions;
    private final String username;
    private final String protocol;
    private AuthenticationConfiguration configuration;
    private URI destination;

    public RemoteOutboundConnectionService(OptionMap connectionCreationOptions, String username, String protocol) {
        this.connectionCreationOptions = connectionCreationOptions;
        this.username = username;
        this.protocol = protocol;
    }

    Injector<OutboundSocketBinding> getDestinationOutboundSocketBindingInjector() {
        return this.destinationOutboundSocketBindingInjectedValue;
    }

    Injector<SecurityRealm> getSecurityRealmInjector() {
        return this.securityRealmInjectedValue;
    }

    Injector<AuthenticationContext> getAuthenticationContextInjector() {
        return this.authenticationContext;
    }

    @Override
    public void start(StartContext context) throws StartException {
        AuthenticationConfiguration configuration;
        URI uri;
        OutboundSocketBinding binding = (OutboundSocketBinding)this.destinationOutboundSocketBindingInjectedValue.getValue();
        String hostName = NetworkUtils.formatPossibleIpv6Address((String)binding.getUnresolvedDestinationAddress());
        int port = binding.getDestinationPort();
        String username = this.username;
        try {
            uri = new URI(this.protocol, username, hostName, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new StartException((Throwable)e);
        }
        AuthenticationContext injectedContext = (AuthenticationContext)this.authenticationContext.getOptionalValue();
        if (injectedContext != null) {
            configuration = AUTH_CONFIGURATION_CLIENT.getAuthenticationConfiguration(uri, injectedContext, -1, null, null, "connect");
        } else {
            SecurityRealm securityRealm = (SecurityRealm)this.securityRealmInjectedValue.getOptionalValue();
            if (securityRealm != null) {
                configuration = AuthenticationConfiguration.EMPTY.useName(username).forbidSaslMechanisms(new String[]{JBOSS_LOCAL_USER});
                CallbackHandlerFactory callbackHandlerFactory = securityRealm.getSecretCallbackHandlerFactory();
                if (callbackHandlerFactory != null) {
                    configuration = configuration.useCallbackHandler(callbackHandlerFactory.getCallbackHandler(username));
                }
            } else {
                configuration = AuthenticationConfiguration.EMPTY.useName(username);
            }
        }
        OptionMap optionMap = this.connectionCreationOptions;
        if (optionMap != null) {
            configuration = RemotingOptions.mergeOptionsIntoAuthenticationConfiguration((OptionMap)optionMap, (AuthenticationConfiguration)configuration);
        }
        this.configuration = configuration;
        this.destination = uri;
    }

    @Override
    public void stop(StopContext context) {
        this.configuration = null;
    }

    @Override
    public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.configuration;
    }

    @Override
    public URI getDestinationUri() {
        return this.destination;
    }

    public RemoteOutboundConnectionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

