/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.GenericOutboundConnectionAdd;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingSubsystem10Parser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.common.Assert;

class RemotingSubsystem11Parser
extends RemotingSubsystem10Parser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    static final RemotingSubsystem11Parser INSTANCE = new RemotingSubsystem11Parser();

    RemotingSubsystem11Parser() {
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((String)"subsystem", (String)"remoting");
        ModelNode subsystem = Util.createAddOperation((PathAddress)address);
        list.add(subsystem);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WORKER_THREAD_POOL: {
                    this.parseWorkerThreadPool(reader, subsystem);
                    continue block5;
                }
                case CONNECTOR: {
                    this.parseConnector(reader, address.toModelNode(), list);
                    continue block5;
                }
                case OUTBOUND_CONNECTIONS: {
                    this.parseOutboundConnections(reader, address.toModelNode(), list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    @Override
    void parseConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String securityRealm = null;
        String socketBinding = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.SOCKET_BINDING);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block10;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block10;
                }
                case SOCKET_BINDING: {
                    socketBinding = value;
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        assert (socketBinding != null);
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add");
        connector.get("address").set(address).add("connector", name);
        connector.get("socket-binding").set(socketBinding);
        if (securityRealm != null) {
            connector.get("security-realm").set(securityRealm);
        }
        list.add(connector);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case SASL: {
                    this.parseSaslElement(reader, connector.get("address"), list);
                    continue block11;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, connector.get("address"), list);
                    continue block11;
                }
                case AUTHENTICATION_PROVIDER: {
                    connector.get("authentication-provider").set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseOutboundConnections(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_OUTBOUND_CONNECTION: {
                    this.parseRemoteOutboundConnection(reader, address, operations);
                    continue block5;
                }
                case LOCAL_OUTBOUND_CONNECTION: {
                    this.parseLocalOutboundConnection(reader, address, operations);
                    continue block5;
                }
                case OUTBOUND_CONNECTION: {
                    this.parseOutboundConnection(reader, address, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseRemoteOutboundConnection(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> operations) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.OUTBOUND_SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        String name = null;
        String outboundSocketBindingRef = null;
        ModelNode username = null;
        String securityRealm = null;
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                case OUTBOUND_SOCKET_BINDING_REF: {
                    outboundSocketBindingRef = value;
                    continue block9;
                }
                case USERNAME: {
                    username = RemoteOutboundConnectionResourceDefinition.USERNAME.parse(value, (XMLStreamReader)reader);
                    continue block9;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)parentAddress), (PathElement[])new PathElement[]{PathElement.pathElement((String)"remote-outbound-connection", name)});
        ModelNode connectionAddOperation = RemotingSubsystem11Parser.getConnectionAddOperation(name, outboundSocketBindingRef, username, securityRealm, address);
        operations.add(connectionAddOperation);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case PROPERTIES: {
                    this.parseProperties(reader, address.toModelNode(), operations);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseLocalOutboundConnection(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> operations) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.OUTBOUND_SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        String name = null;
        String outboundSocketBindingRef = null;
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case OUTBOUND_SOCKET_BINDING_REF: {
                    outboundSocketBindingRef = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)parentAddress), (PathElement[])new PathElement[]{PathElement.pathElement((String)"local-outbound-connection", name)});
        operations.add(RemotingSubsystem11Parser.getConnectionAddOperation(name, outboundSocketBindingRef, address));
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case PROPERTIES: {
                    this.parseProperties(reader, address.toModelNode(), operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseOutboundConnection(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> operations) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URI);
        int count = reader.getAttributeCount();
        String name = null;
        String uri = null;
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case URI: {
                    uri = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)parentAddress), (PathElement[])new PathElement[]{PathElement.pathElement((String)"outbound-connection", name)});
        operations.add(GenericOutboundConnectionAdd.getAddOperation(name, uri, address));
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case PROPERTIES: {
                    this.parseProperties(reader, address.toModelNode(), operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode getConnectionAddOperation(String connectionName, String outboundSocketBindingRef, PathAddress address) {
        return RemotingSubsystem11Parser.getConnectionAddOperation(connectionName, outboundSocketBindingRef, null, null, address);
    }

    static ModelNode getConnectionAddOperation(String connectionName, String outboundSocketBindingRef, ModelNode userName, String securityRealm, PathAddress address) {
        Assert.checkNotNullParam((String)"connectionName", (Object)connectionName);
        Assert.checkNotEmptyParam((String)"connectionName", (String)connectionName);
        Assert.checkNotNullParam((String)"outboundSocketBindingRef", (Object)outboundSocketBindingRef);
        Assert.checkNotEmptyParam((String)"outboundSocketBindingRef", (String)outboundSocketBindingRef);
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        addOperation.get("address").set(address.toModelNode());
        addOperation.get("outbound-socket-binding-ref").set(outboundSocketBindingRef);
        if (userName != null) {
            addOperation.get("username").set(userName);
        }
        if (securityRealm != null) {
            addOperation.get("security-realm").set(securityRealm);
        }
        return addOperation;
    }
}

