/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import javax.net.ssl.SSLContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.AbstractStreamServerService;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.InjectedNetworkBindingStreamServerService;
import org.jboss.as.remoting.InjectedSocketBindingStreamServerService;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public class RemotingServices {
    public static final ServiceName REMOTING_BASE = ServiceName.JBOSS.append(new String[]{"remoting"});
    public static final ServiceName SUBSYSTEM_ENDPOINT = RemotingSubsystemRootResource.REMOTING_ENDPOINT_CAPABILITY.getCapabilityServiceName(Endpoint.class);
    private static final ServiceName CONNECTOR_BASE = REMOTING_BASE.append(new String[]{"connector"});
    private static final ServiceName SERVER_BASE = REMOTING_BASE.append(new String[]{"server"});

    public static ServiceName connectorServiceName(String connectorName) {
        return CONNECTOR_BASE.append(new String[]{connectorName});
    }

    public static ServiceName serverServiceName(String connectorName) {
        return SERVER_BASE.append(new String[]{connectorName});
    }

    public static ServiceName channelServiceName(ServiceName endpointName, String channelName) {
        return endpointName.append(new String[]{"channel"}).append(new String[]{channelName});
    }

    public static void installRemotingManagementEndpoint(ServiceTarget serviceTarget, ServiceName endpointName, String hostName, EndpointService.EndpointType type) {
        RemotingServices.installRemotingManagementEndpoint(serviceTarget, endpointName, hostName, type, OptionMap.EMPTY);
    }

    public static void installRemotingManagementEndpoint(ServiceTarget serviceTarget, ServiceName endpointName, String hostName, EndpointService.EndpointType type, OptionMap options) {
        EndpointService service = new EndpointService(hostName, type, options);
        serviceTarget.addService(endpointName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ServiceName.JBOSS.append(new String[]{"serverManagement", "controller", "management", "worker"}), XnioWorker.class, service.getWorker()).install();
    }

    @Deprecated
    public static void installConnectorServicesForNetworkInterfaceBinding(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName networkInterfaceBindingName, int port, OptionMap connectorPropertiesOptionMap, ServiceName securityRealm, ServiceName saslAuthenticationFactory, ServiceName sslContext) {
        RemotingServices.installConnectorServices(serviceTarget, endpointName, connectorName, networkInterfaceBindingName, port, true, connectorPropertiesOptionMap, securityRealm, saslAuthenticationFactory, sslContext);
    }

    public static void installConnectorServicesForSocketBinding(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName socketBindingName, OptionMap connectorPropertiesOptionMap, ServiceName securityRealm, ServiceName saslAuthenticationFactory, ServiceName sslContext) {
        RemotingServices.installConnectorServices(serviceTarget, endpointName, connectorName, socketBindingName, 0, false, connectorPropertiesOptionMap, securityRealm, saslAuthenticationFactory, sslContext);
    }

    private static void installConnectorServices(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName bindingName, int port, boolean isNetworkInterfaceBinding, OptionMap connectorPropertiesOptionMap, ServiceName securityRealm, ServiceName saslAuthenticationFactory, ServiceName sslContext) {
        ServiceBuilder serviceBuilder;
        AbstractStreamServerService service;
        if (isNetworkInterfaceBinding) {
            service = new InjectedNetworkBindingStreamServerService(connectorPropertiesOptionMap, port);
            InjectedNetworkBindingStreamServerService streamServerService = service;
            serviceBuilder = serviceTarget.addService(RemotingServices.serverServiceName(connectorName), (Service)streamServerService).addDependency(bindingName, NetworkInterfaceBinding.class, streamServerService.getInterfaceBindingInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, streamServerService.getSocketBindingManagerInjector());
        } else {
            service = new InjectedSocketBindingStreamServerService(connectorPropertiesOptionMap);
            InjectedSocketBindingStreamServerService streamServerService = service;
            serviceBuilder = serviceTarget.addService(RemotingServices.serverServiceName(connectorName), (Service)streamServerService).addDependency(bindingName, SocketBinding.class, streamServerService.getSocketBindingInjector()).addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, streamServerService.getSocketBindingManagerInjector());
        }
        serviceBuilder.addDependency(endpointName, Endpoint.class, service.getEndpointInjector());
        if (securityRealm != null) {
            serviceBuilder.addDependency(securityRealm, SecurityRealm.class, service.getSecurityRealmInjector());
        }
        if (saslAuthenticationFactory != null) {
            serviceBuilder.addDependency(saslAuthenticationFactory, SaslAuthenticationFactory.class, service.getSaslAuthenticationFactoryInjector());
        }
        if (sslContext != null) {
            serviceBuilder.addDependency(sslContext, SSLContext.class, service.getSSLContextInjector());
        }
        serviceBuilder.install();
    }

    public static void removeConnectorServices(OperationContext context, String connectorName) {
        context.removeService(RemotingServices.serverServiceName(connectorName));
    }
}

