/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorCommon;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingSubsystem30Parser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class RemotingSubsystem40Parser
extends RemotingSubsystem30Parser {
    static final RemotingSubsystem40Parser INSTANCE = new RemotingSubsystem40Parser();

    private RemotingSubsystem40Parser() {
    }

    @Override
    void parseConnector(boolean http, XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add");
        String name = null;
        String securityRealm = null;
        String socketBinding = null;
        String connectorRef = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, http ? Attribute.CONNECTOR_REF : Attribute.SOCKET_BINDING);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                case SASL_AUTHENTICATION_FACTORY: {
                    ConnectorCommon.SASL_AUTHENTICATION_FACTORY.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block15;
                }
                case SASL_PROTOCOL: {
                    ConnectorCommon.SASL_PROTOCOL.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block15;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block15;
                }
                case SERVER_NAME: {
                    ConnectorCommon.SERVER_NAME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block15;
                }
                case SOCKET_BINDING: {
                    if (http) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    socketBinding = value;
                    continue block15;
                }
                case SSL_CONTEXT: {
                    if (http) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ConnectorResource.SSL_CONTEXT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block15;
                }
                case CONNECTOR_REF: {
                    if (!http) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    connectorRef = value;
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        if (http ? !$assertionsDisabled && connectorRef == null : !$assertionsDisabled && socketBinding == null) {
            throw new AssertionError();
        }
        connector.get("address").set(address).add(http ? "http-connector" : "connector", name);
        if (http) {
            connector.get("connector-ref").set(connectorRef);
        } else {
            connector.get("socket-binding").set(socketBinding);
        }
        if (securityRealm != null) {
            connector.get("security-realm").set(securityRealm);
        }
        list.add(connector);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case SASL: {
                    this.parseSaslElement(reader, connector.get("address"), list);
                    continue block16;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, connector.get("address"), list);
                    continue block16;
                }
                case AUTHENTICATION_PROVIDER: {
                    connector.get("authentication-provider").set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    continue block16;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    @Override
    void parseRemoteOutboundConnection(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> operations) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.OUTBOUND_SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        String name = null;
        ModelNode addOperation = Util.createAddOperation();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                case OUTBOUND_SOCKET_BINDING_REF: {
                    RemoteOutboundConnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block11;
                }
                case USERNAME: {
                    RemoteOutboundConnectionResourceDefinition.USERNAME.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block11;
                }
                case SECURITY_REALM: {
                    RemoteOutboundConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block11;
                }
                case PROTOCOL: {
                    RemoteOutboundConnectionResourceDefinition.PROTOCOL.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block11;
                }
                case AUTHENTICATION_CONTEXT: {
                    RemoteOutboundConnectionResourceDefinition.AUTHENTICATION_CONTEXT.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)parentAddress), (PathElement[])new PathElement[]{PathElement.pathElement((String)"remote-outbound-connection", name)});
        addOperation.get("address").set(address.toModelNode());
        operations.add(addOperation);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case PROPERTIES: {
                    this.parseProperties(reader, address.toModelNode(), operations);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

