/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.remoting.ConnectorAdd;
import org.jboss.as.remoting.ConnectorUtils;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.manager.WildFlySecurityManager;

abstract class ConnectorChildResource
extends SimpleResourceDefinition {
    public ConnectorChildResource(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        this(new SimpleResourceDefinition.Parameters(pathElement, descriptionResolver).setAddHandler(addHandler).setRemoveHandler(removeHandler));
    }

    public ConnectorChildResource(SimpleResourceDefinition.Parameters parameters) {
        super(parameters);
    }

    static void recreateParentService(OperationContext context, ModelNode parentModel) throws OperationFailedException {
        ConnectorAdd.launchServices(context, parentModel);
    }

    static ServiceName getParentServiceName(PathAddress parentAddress) {
        return RemotingServices.serverServiceName(parentAddress.getLastElement().getValue());
    }

    static class RestartConnectorWriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        RestartConnectorWriteAttributeHandler(String parent, Collection<AttributeDefinition> attributes) {
            super(parent, attributes);
        }

        protected void recreateParentService(OperationContext context, ModelNode parentModel) throws OperationFailedException {
            ConnectorChildResource.recreateParentService(context, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ConnectorChildResource.getParentServiceName(parentAddress);
        }
    }

    static class RemoveResourceConnectorRestartHandler
    extends RestartParentResourceRemoveHandler {
        RemoveResourceConnectorRestartHandler(String parent) {
            super(parent);
        }

        protected void recreateParentService(OperationContext context, ModelNode parentModel) throws OperationFailedException {
            ConnectorChildResource.recreateParentService(context, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ConnectorChildResource.getParentServiceName(parentAddress);
        }
    }

    static class AddResourceConnectorRestartHandler
    extends RestartParentResourceAddHandler {
        AddResourceConnectorRestartHandler(String parent, Collection<AttributeDefinition> attributes) {
            super(parent, attributes);
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition ad : this.attributes) {
                this.validateProperty(operation);
                ad.validateAndSet(operation, model);
            }
        }

        private void validateProperty(ModelNode operation) throws OperationFailedException {
            ModelNode addressModelNode = operation.get("address");
            ClassLoader loader = WildFlySecurityManager.getClassLoaderPrivileged(ConnectorChildResource.class);
            if (addressModelNode.isDefined()) {
                List propertyListModelNode = addressModelNode.asPropertyList();
                for (Property property : propertyListModelNode) {
                    if (!property.getName().equals("property")) continue;
                    ConnectorUtils.getAndValidateOption(loader, property.getValue().asString());
                }
            }
        }

        protected void recreateParentService(OperationContext context, ModelNode parentModel) throws OperationFailedException {
            ConnectorChildResource.recreateParentService(context, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ConnectorChildResource.getParentServiceName(parentAddress);
        }
    }
}

