/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.ConnectorCommon;
import org.jboss.as.remoting.ConnectorUtils;
import org.jboss.as.remoting.HttpConnectorResource;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.xnio.OptionMap;

public class HttpConnectorAdd
extends AbstractAddStepHandler {
    static final HttpConnectorAdd INSTANCE = new HttpConnectorAdd();

    private HttpConnectorAdd() {
        super(new AttributeDefinition[]{HttpConnectorResource.CONNECTOR_REF, HttpConnectorResource.AUTHENTICATION_PROVIDER, HttpConnectorResource.SECURITY_REALM, HttpConnectorResource.SASL_AUTHENTICATION_FACTORY, ConnectorCommon.SASL_PROTOCOL, ConnectorCommon.SERVER_NAME});
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        context.addStep(operation, (OperationStepHandler)HttpConnectorValidationStep.INSTANCE, OperationContext.Stage.MODEL);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        String connectorName = context.getCurrentAddressValue();
        ModelNode fullModel = Resource.Tools.readModel((Resource)resource);
        this.launchServices(context, connectorName, fullModel);
    }

    void launchServices(OperationContext context, String connectorName, ModelNode model) throws OperationFailedException {
        OptionMap optionMap = ConnectorUtils.getFullOptions(context, model);
        String connectorRef = HttpConnectorResource.CONNECTOR_REF.resolveModelAttribute(context, model).asString();
        ModelNode securityRealmModel = HttpConnectorResource.SECURITY_REALM.resolveModelAttribute(context, model);
        if (securityRealmModel.isDefined()) {
            throw RemotingLogger.ROOT_LOGGER.runtimeSecurityRealmUnsupported();
        }
        ModelNode saslAuthenticationFactoryModel = HttpConnectorResource.SASL_AUTHENTICATION_FACTORY.resolveModelAttribute(context, model);
        String saslAuthenticationFactory = saslAuthenticationFactoryModel.asStringOrNull();
        ServiceName saslAuthenticationFactorySvc = saslAuthenticationFactory != null ? context.getCapabilityServiceName("org.wildfly.security.sasl-authentication-factory", saslAuthenticationFactory, SaslAuthenticationFactory.class) : null;
        RemotingHttpUpgradeService.installServices(context, connectorName, connectorRef, RemotingServices.SUBSYSTEM_ENDPOINT, optionMap, saslAuthenticationFactorySvc);
    }

    private static class HttpConnectorValidationStep
    implements OperationStepHandler {
        private static HttpConnectorValidationStep INSTANCE = new HttpConnectorValidationStep();

        private HttpConnectorValidationStep() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            String connectorName = address.getLastElement().getValue();
            PathAddress parentAddress = address.getParent();
            Resource parent = context.readResourceFromRoot(parentAddress, false);
            Resource resource = context.readResourceFromRoot(address, false);
            ModelNode resourceRef = resource.getModel().get("connector-ref");
            boolean listenerAlreadyExists = false;
            for (Resource.ResourceEntry child : parent.getChildren("http-connector")) {
                Resource childResource;
                if (connectorName.equals(child.getName()) || !(childResource = context.readResourceFromRoot(PathAddress.pathAddress((PathAddress)parentAddress, (PathElement[])new PathElement[]{child.getPathElement()}), false)).getModel().get("connector-ref").equals(resourceRef)) continue;
                listenerAlreadyExists = true;
                break;
            }
            if (listenerAlreadyExists) {
                throw ControllerLogger.ROOT_LOGGER.alreadyDefinedAttribute("http-connector", resourceRef.asString(), "connector-ref");
            }
        }
    }
}

