/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.dmr.ModelNode;

class WorkerThreadPoolVsEndpointHandler
implements OperationStepHandler {
    private final boolean forDomain;

    WorkerThreadPoolVsEndpointHandler(boolean forDomain) {
        this.forDomain = forDomain;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        boolean hasLegacy = false;
        if (this.forDomain) {
            for (SimpleAttributeDefinition attribute : RemotingSubsystemRootResource.LEGACY_ATTRIBUTES) {
                if (!model.hasDefined(attribute.getName())) continue;
                hasLegacy = true;
                break;
            }
        }
        if (!hasLegacy && !resource.hasChild(RemotingEndpointResource.ENDPOINT_PATH)) {
            context.addResource(PathAddress.pathAddress((PathElement[])new PathElement[]{RemotingEndpointResource.ENDPOINT_PATH}), Resource.Factory.create());
        }
    }
}

