/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.function.Consumer;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public final class RemotingConnectorBindingInfoService
implements Service {
    private static final ServiceName SERVICE_NAME = RemotingServices.REMOTING_BASE.append(new String[]{"remotingConnectorInfoService"});
    private final Consumer<RemotingConnectorInfo> serviceConsumer;
    private final RemotingConnectorInfo binding;

    private RemotingConnectorBindingInfoService(Consumer<RemotingConnectorInfo> serviceConsumer, RemotingConnectorInfo binding) {
        this.serviceConsumer = serviceConsumer;
        this.binding = binding;
    }

    public static ServiceName serviceName(String connectorName) {
        return SERVICE_NAME.append(new String[]{connectorName});
    }

    public static void install(ServiceTarget target, String connectorName, SocketBinding binding, Protocol protocol) {
        ServiceBuilder sb = target.addService(RemotingConnectorBindingInfoService.serviceName(connectorName));
        Consumer serviceConsumer = sb.provides(new ServiceName[]{RemotingConnectorBindingInfoService.serviceName(connectorName)});
        sb.setInstance((Service)new RemotingConnectorBindingInfoService(serviceConsumer, new RemotingConnectorInfo(binding, protocol)));
        sb.install();
    }

    public void start(StartContext startContext) {
        this.serviceConsumer.accept(this.binding);
    }

    public void stop(StopContext stopContext) {
        this.serviceConsumer.accept(null);
    }

    public static final class RemotingConnectorInfo {
        private final SocketBinding socketBinding;
        private final Protocol protocol;

        public RemotingConnectorInfo(SocketBinding socketBinding, Protocol protocol) {
            this.socketBinding = socketBinding;
            this.protocol = protocol;
        }

        public SocketBinding getSocketBinding() {
            return this.socketBinding;
        }

        public String getProtocol() {
            return this.protocol.toString();
        }
    }
}

