/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionAddHandler;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.ConnectorUtils;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemoteOutboundConnectionService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class RemoteOutboundConnectionAdd
extends AbstractOutboundConnectionAddHandler {
    static final RemoteOutboundConnectionAdd INSTANCE = new RemoteOutboundConnectionAdd();

    private RemoteOutboundConnectionAdd() {
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        super.populateModel(operation, model);
        RemoteOutboundConnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF.validateAndSet(operation, model);
        RemoteOutboundConnectionResourceDefinition.USERNAME.validateAndSet(operation, model);
        RemoteOutboundConnectionResourceDefinition.SECURITY_REALM.validateAndSet(operation, model);
        RemoteOutboundConnectionResourceDefinition.PROTOCOL.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ServiceController serviceController = this.installRuntimeService(context, operation, fullModel, verificationHandler);
        newControllers.add(serviceController);
    }

    ServiceController installRuntimeService(OperationContext context, ModelNode operation, ModelNode fullModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String connectionName = address.getLastElement().getValue();
        String outboundSocketBindingRef = RemoteOutboundConnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF.resolveModelAttribute(context, operation).asString();
        String protocol = RemoteOutboundConnectionResourceDefinition.PROTOCOL.resolveModelAttribute(context, operation).asString();
        ServiceName outboundSocketBindingDependency = OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBindingRef});
        OptionMap connectionCreationOptions = ConnectorUtils.getOptions(context, fullModel.get("property"));
        String username = RemoteOutboundConnectionResourceDefinition.USERNAME.resolveModelAttribute(context, fullModel).asString();
        String securityRealm = fullModel.hasDefined("security-realm") ? fullModel.require("security-realm").asString() : null;
        RemoteOutboundConnectionService outboundConnectionService = new RemoteOutboundConnectionService(connectionName, connectionCreationOptions, username, protocol);
        ServiceName serviceName = AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceName aliasServiceName = RemoteOutboundConnectionService.REMOTE_OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceBuilder svcBuilder = context.getServiceTarget().addService(serviceName, (Service)outboundConnectionService).addAliases(new ServiceName[]{aliasServiceName}).addDependency(RemotingServices.SUBSYSTEM_ENDPOINT, Endpoint.class, outboundConnectionService.getEndpointInjector()).addDependency(outboundSocketBindingDependency, OutboundSocketBinding.class, outboundConnectionService.getDestinationOutboundSocketBindingInjector());
        if (securityRealm != null) {
            SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)svcBuilder, outboundConnectionService.getSecurityRealmInjector(), (String)securityRealm, (boolean)false);
        }
        if (verificationHandler != null) {
            svcBuilder.addListener((ServiceListener)verificationHandler);
        }
        return svcBuilder.install();
    }
}

