/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.InjectedNetworkBindingStreamServerService;
import org.jboss.as.remoting.InjectedSocketBindingStreamServerService;
import org.jboss.as.remoting.ManagementEndpointService;
import org.jboss.as.remoting.RealmSecurityProviderService;
import org.jboss.as.remoting.RemotingSecurityProvider;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

public class RemotingServices {
    public static final ServiceName REMOTING_BASE = ServiceName.JBOSS.append(new String[]{"remoting"});
    public static final ServiceName SUBSYSTEM_ENDPOINT = REMOTING_BASE.append(new String[]{"endpoint", "subsystem"});
    private static final ServiceName CONNECTOR_BASE = REMOTING_BASE.append(new String[]{"connector"});
    private static final ServiceName SERVER_BASE = REMOTING_BASE.append(new String[]{"server"});

    public static ServiceName connectorServiceName(String connectorName) {
        return CONNECTOR_BASE.append(new String[]{connectorName});
    }

    public static ServiceName serverServiceName(String connectorName) {
        return SERVER_BASE.append(new String[]{connectorName});
    }

    public static ServiceName channelServiceName(ServiceName endpointName, String channelName) {
        return endpointName.append(new String[]{"channel"}).append(new String[]{channelName});
    }

    public static void addController(List<ServiceController<?>> newControllers, ServiceVerificationHandler verificationHandler, ServiceBuilder<?> builder) {
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    public static void installRemotingManagementEndpoint(ServiceTarget serviceTarget, ServiceName endpointName, String hostName, EndpointService.EndpointType type, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        RemotingServices.installRemotingManagementEndpoint(serviceTarget, endpointName, hostName, type, OptionMap.EMPTY, verificationHandler, newControllers);
    }

    public static void installRemotingManagementEndpoint(ServiceTarget serviceTarget, ServiceName endpointName, String hostName, EndpointService.EndpointType type, OptionMap options, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ManagementEndpointService endpointService = new ManagementEndpointService(hostName, type, options);
        ServiceBuilder builder = serviceTarget.addService(endpointName, (Service)endpointService).setInitialMode(ServiceController.Mode.ACTIVE);
        RemotingServices.addController(newControllers, verificationHandler, builder);
    }

    public static void installConnectorServicesForNetworkInterfaceBinding(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName networkInterfaceBindingName, int port, OptionMap connectorPropertiesOptionMap, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        RemotingServices.installConnectorServices(serviceTarget, endpointName, connectorName, networkInterfaceBindingName, port, true, connectorPropertiesOptionMap, verificationHandler, newControllers);
    }

    public static void installConnectorServicesForSocketBinding(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName socketBindingName, OptionMap connectorPropertiesOptionMap, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        RemotingServices.installConnectorServices(serviceTarget, endpointName, connectorName, socketBindingName, 0, false, connectorPropertiesOptionMap, verificationHandler, newControllers);
    }

    public static void installSecurityServices(ServiceTarget serviceTarget, String connectorName, String realmName, ServiceName serverCallbackServiceName, ServiceName tmpDirService, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceName securityProviderName = RealmSecurityProviderService.createName(connectorName);
        RealmSecurityProviderService rsps = new RealmSecurityProviderService();
        ServiceBuilder builder = serviceTarget.addService(securityProviderName, (Service)rsps);
        if (realmName != null) {
            SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)builder, rsps.getSecurityRealmInjectedValue(), (String)realmName, (boolean)false);
        }
        if (serverCallbackServiceName != null) {
            builder.addDependency(serverCallbackServiceName, CallbackHandler.class, rsps.getServerCallbackValue());
        }
        builder.addDependency(tmpDirService, String.class, rsps.getTmpDirValue());
        RemotingServices.addController(newControllers, verificationHandler, builder);
    }

    private static void installConnectorServices(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName bindingName, int port, boolean isNetworkInterfaceBinding, OptionMap connectorPropertiesOptionMap, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceName securityProviderName = RealmSecurityProviderService.createName(connectorName);
        if (isNetworkInterfaceBinding) {
            InjectedNetworkBindingStreamServerService streamServerService = new InjectedNetworkBindingStreamServerService(connectorPropertiesOptionMap, port);
            RemotingServices.addController(newControllers, verificationHandler, serviceTarget.addService(RemotingServices.serverServiceName(connectorName), (Service)streamServerService).addDependency(securityProviderName, RemotingSecurityProvider.class, streamServerService.getSecurityProviderInjector()).addDependency(endpointName, Endpoint.class, streamServerService.getEndpointInjector()).addDependency(bindingName, NetworkInterfaceBinding.class, streamServerService.getInterfaceBindingInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, streamServerService.getSocketBindingManagerInjector()));
        } else {
            InjectedSocketBindingStreamServerService streamServerService = new InjectedSocketBindingStreamServerService(connectorPropertiesOptionMap);
            RemotingServices.addController(newControllers, verificationHandler, serviceTarget.addService(RemotingServices.serverServiceName(connectorName), (Service)streamServerService).addDependency(securityProviderName, RemotingSecurityProvider.class, streamServerService.getSecurityProviderInjector()).addDependency(endpointName, Endpoint.class, streamServerService.getEndpointInjector()).addDependency(bindingName, SocketBinding.class, streamServerService.getSocketBindingInjector()).addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, streamServerService.getSocketBindingManagerInjector()));
        }
    }

    public static void removeConnectorServices(OperationContext context, String connectorName) {
        ServiceName securityProviderName = RealmSecurityProviderService.createName(connectorName);
        context.removeService(RemotingServices.serverServiceName(connectorName));
        context.removeService(securityProviderName);
    }
}

