/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.EndpointConfigFactory;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.WorkerThreadPoolVsEndpointHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.io.IOServices;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

class RemotingSubsystemAdd
extends AbstractAddStepHandler {
    static final RemotingSubsystemAdd INSTANCE = new RemotingSubsystemAdd();
    static final OperationContext.AttachmentKey<Boolean> RUNTIME_KEY = OperationContext.AttachmentKey.create(Boolean.class);

    private RemotingSubsystemAdd() {
        super(RemotingSubsystemRootResource.ATTRIBUTES);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        context.addStep(WorkerThreadPoolVsEndpointHandler.INSTANCE, OperationContext.Stage.MODEL);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.attach(RUNTIME_KEY, (Object)Boolean.FALSE);
        this.launchServices(context);
    }

    void launchServices(OperationContext context) throws OperationFailedException {
        ServiceController controller;
        ModelNode endpointModel = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{RemotingEndpointResource.ENDPOINT_PATH})).getModel();
        String workerName = RemotingEndpointResource.WORKER.resolveModelAttribute(context, endpointModel).asString();
        OptionMap map = EndpointConfigFactory.populate((ExpressionResolver)context, endpointModel);
        ServiceTarget serviceTarget = context.getServiceTarget();
        String nodeName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
        EndpointService endpointService = new EndpointService(nodeName, EndpointService.EndpointType.SUBSYSTEM, map);
        if (context.getProcessType() == ProcessType.DOMAIN_SERVER && (controller = context.getServiceRegistry(false).getService(RemotingServices.SUBSYSTEM_ENDPOINT)) != null) {
            return;
        }
        ServiceBuilder builder = serviceTarget.addService(RemotingServices.SUBSYSTEM_ENDPOINT, (Service)endpointService).addDependency(IOServices.WORKER.append(new String[]{workerName}), XnioWorker.class, endpointService.getWorker());
        builder.install();
    }

    private boolean areWorkerAttributesSet(OperationContext context, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : RemotingSubsystemRootResource.ATTRIBUTES) {
            ModelNode value = attribute.resolveModelAttribute(context, model);
            if (!value.isDefined() || value.equals(attribute.getDefaultValue())) continue;
            return true;
        }
        return false;
    }
}

