/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolConnectionManager;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.as.protocol.mgmt.FutureManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelReceiver;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.OptionMap;

public abstract class ManagementClientChannelStrategy
implements Closeable {
    private static final String DEFAULT_CHANNEL_SERVICE_TYPE = "management";

    public abstract Channel getChannel() throws IOException;

    public static ManagementClientChannelStrategy create(Channel channel) {
        return new Existing(channel);
    }

    public static ManagementClientChannelStrategy create(ProtocolConnectionConfiguration baseConfig, ManagementMessageHandler handler, CallbackHandler cbHandler, Map<String, String> saslOptions, SSLContext sslContext, CloseHandler<Channel> closeHandler) {
        return ManagementClientChannelStrategy.create(ManagementClientChannelStrategy.createConfiguration(baseConfig, saslOptions, cbHandler, sslContext), ManagementChannelReceiver.createDelegating(handler), closeHandler);
    }

    public static ManagementClientChannelStrategy create(ProtocolConnectionConfiguration configuration, Channel.Receiver receiver, CloseHandler<Channel> closeHandler) {
        return new Establishing(configuration, receiver, closeHandler);
    }

    private static ProtocolConnectionConfiguration createConfiguration(ProtocolConnectionConfiguration configuration, Map<String, String> saslOptions, CallbackHandler callbackHandler, SSLContext sslContext) {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(configuration);
        config.setCallbackHandler(callbackHandler);
        config.setSslContext(sslContext);
        config.setSaslOptions(saslOptions);
        return config;
    }

    private static class Existing
    extends ManagementClientChannelStrategy {
        private final Channel channel;
        private volatile boolean closed = false;

        private Existing(Channel channel) {
            this.channel = channel;
        }

        @Override
        public Channel getChannel() throws IOException {
            if (this.closed) {
                throw ProtocolLogger.ROOT_LOGGER.channelClosed();
            }
            return this.channel;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private static class Establishing
    extends FutureManagementChannel {
        private final String serviceType = "management";
        private final OptionMap channelOptions;
        private final Channel.Receiver receiver;
        private final ProtocolConnectionManager connectionManager;
        private final CloseHandler<Channel> closeHandler;
        private final long timeout;
        private Long deadline;

        private Establishing(ProtocolConnectionConfiguration configuration, Channel.Receiver receiver, CloseHandler<Channel> closeHandler) {
            this.receiver = receiver;
            this.channelOptions = configuration.getOptionMap();
            this.connectionManager = ProtocolConnectionManager.create(configuration, (ProtocolConnectionManager.ConnectionOpenHandler)this);
            this.closeHandler = closeHandler;
            this.timeout = configuration.getConnectionTimeout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Channel getChannel() throws IOException {
            Channel channel = super.getChannel();
            if (channel != null) {
                return channel;
            }
            ProtocolConnectionManager protocolConnectionManager = this.connectionManager;
            synchronized (protocolConnectionManager) {
                this.deadline = System.currentTimeMillis() + this.timeout;
                this.connectionManager.connect();
                this.deadline = null;
            }
            channel = super.getChannel();
            if (channel == null) {
                throw ProtocolLogger.ROOT_LOGGER.channelClosed();
            }
            return channel;
        }

        @Override
        public void connectionOpened(Connection connection) throws IOException {
            Channel channel = this.openChannel(connection, ManagementClientChannelStrategy.DEFAULT_CHANNEL_SERVICE_TYPE, this.channelOptions);
            if (this.setChannel(channel)) {
                channel.receiveMessage(this.receiver);
            } else {
                channel.closeAsync();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.connectionManager.shutdown();
            }
        }

        @Override
        protected Channel openChannel(Connection connection, String serviceType, OptionMap options) throws IOException {
            if (!Thread.holdsLock(this.connectionManager)) {
                throw new IllegalStateException();
            }
            Channel channel = this.openChannel(connection, serviceType, options, this.deadline);
            channel.addCloseHandler(this.closeHandler);
            return channel;
        }
    }
}

