/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.IOException;
import java.util.List;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.RollbackPatch;
import org.jboss.as.patching.validation.AbstractArtifact;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.as.patching.validation.PatchingArtifactProcessor;
import org.jboss.as.patching.validation.PatchingArtifactValidationContext;
import org.jboss.as.patching.validation.PatchingArtifacts;
import org.jboss.as.patching.validation.PatchingXmlArtifact;

class RollbackTargetArtifact
extends AbstractArtifact<PatchingXmlArtifact.XmlArtifactState<RollbackPatch>, State> {
    RollbackTargetArtifact() {
        super(new PatchingArtifact[0]);
    }

    @Override
    public boolean process(PatchingXmlArtifact.XmlArtifactState<RollbackPatch> parent, PatchingArtifactProcessor processor) {
        RollbackPatch patch = parent.getPatch();
        PatchingArtifacts.PatchID patchID = processor.getParentArtifact(PatchingArtifacts.HISTORY_RECORD);
        InstalledIdentity identity = patch.getIdentityState();
        processor.getValidationContext().setCurrentPatchIdentity(identity);
        State state = new State(identity, patchID);
        if (identity == null) {
            processor.getValidationContext().getErrorHandler().addMissing(PatchingArtifacts.ROLLBACK_TARGET, state);
            return false;
        }
        return processor.process(this, state);
    }

    static class State
    implements PatchingArtifact.ArtifactState {
        private final InstalledIdentity rollbackIdentity;
        private final PatchingArtifacts.PatchID reference;

        State(InstalledIdentity rollbackIdentity, PatchingArtifacts.PatchID reference) {
            this.rollbackIdentity = rollbackIdentity;
            this.reference = reference;
        }

        @Override
        public boolean isValid(PatchingArtifactValidationContext context) {
            try {
                PatchableTarget.TargetInfo target = this.rollbackIdentity.getIdentity().loadTargetInfo();
                List<String> patches = target.getPatchIDs();
                String rollbackTo = patches.isEmpty() ? target.getCumulativePatchID() : patches.get(0);
                String ref = this.reference.getNextPatchID();
                if (rollbackTo.equals(ref)) {
                    return true;
                }
                if (ref == null && "base".equals(rollbackTo)) {
                    return true;
                }
                context.getErrorHandler().addInconsistent(PatchingArtifacts.ROLLBACK_TARGET, this);
            }
            catch (IOException e) {
                context.getErrorHandler().addError(PatchingArtifacts.ROLLBACK_TARGET, this);
            }
            return false;
        }

        public String toString() {
            return this.reference.getPatchID() != null ? this.reference.getPatchID() : "base";
        }
    }
}

