/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.tool;

import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;

public interface ContentVerificationPolicy {
    public static final ContentVerificationPolicy STRICT = new ContentVerificationPolicy(){

        @Override
        public boolean ignoreContentValidation(ContentItem item) {
            return false;
        }

        @Override
        public boolean preserveExisting(ContentItem item) {
            return false;
        }
    };
    public static final ContentVerificationPolicy OVERRIDE_ALL = new ContentVerificationPolicy(){

        @Override
        public boolean ignoreContentValidation(ContentItem item) {
            return true;
        }

        @Override
        public boolean preserveExisting(ContentItem item) {
            return false;
        }
    };
    public static final ContentVerificationPolicy PRESERVE_ALL = new ContentVerificationPolicy(){

        @Override
        public boolean ignoreContentValidation(ContentItem item) {
            return false;
        }

        @Override
        public boolean preserveExisting(ContentItem item) {
            return item.getContentType() == ContentType.MISC;
        }
    };

    public boolean ignoreContentValidation(ContentItem var1);

    public boolean preserveExisting(ContentItem var1);
}

