/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.patching.PatchInfo;
import org.jboss.as.patching.installation.PatchableTarget;

public class VerbosePatchInfo
implements PatchInfo {
    private final String version;
    private final String cpId;
    private final List<String> patchIds;
    private final Map<String, PatchableTarget.TargetInfo> layers;
    private final Map<String, PatchableTarget.TargetInfo> addons;

    public static Builder builder() {
        return new Builder();
    }

    private VerbosePatchInfo(String version, String cpId, List<String> patchIds, Map<String, PatchableTarget.TargetInfo> layers, Map<String, PatchableTarget.TargetInfo> addons) {
        this.version = version;
        this.cpId = cpId;
        this.patchIds = patchIds;
        this.layers = layers;
        this.addons = addons;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getCumulativePatchID() {
        return this.cpId;
    }

    @Override
    public List<String> getPatchIDs() {
        return this.patchIds;
    }

    public boolean hasLayers() {
        return !this.layers.isEmpty();
    }

    public Collection<String> getLayerNames() {
        return this.layers.keySet();
    }

    public PatchableTarget.TargetInfo getLayerInfo(String name) {
        return this.layers.get(name);
    }

    public boolean hasAddOns() {
        return !this.addons.isEmpty();
    }

    public Collection<String> getAddOnNames() {
        return this.addons.keySet();
    }

    public PatchableTarget.TargetInfo getAddOnInfo(String name) {
        return this.addons.get(name);
    }

    public static class Builder {
        private String version;
        private String cpId;
        private List<String> patchIds = Collections.emptyList();
        private Map<String, PatchableTarget.TargetInfo> layers = Collections.emptyMap();
        private Map<String, PatchableTarget.TargetInfo> addons = Collections.emptyMap();

        private Builder() {
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setCumulativePatchId(String cpId) {
            this.cpId = cpId;
            return this;
        }

        public Builder setPatchIds(List<String> patchIds) {
            this.patchIds = patchIds;
            return this;
        }

        public Builder addLayerInfo(String name, PatchableTarget.TargetInfo info) {
            this.addInfo(name, info, true);
            return this;
        }

        public Builder addAddOnInfo(String name, PatchableTarget.TargetInfo info) {
            this.addInfo(name, info, false);
            return this;
        }

        private void addInfo(String name, PatchableTarget.TargetInfo info, boolean layer) {
            Map<String, PatchableTarget.TargetInfo> map = layer ? this.layers : this.addons;
            switch (map.size()) {
                case 0: {
                    map = Collections.singletonMap(name, info);
                    if (layer) {
                        this.layers = map;
                        break;
                    }
                    this.addons = map;
                    break;
                }
                case 1: {
                    map = new HashMap<String, PatchableTarget.TargetInfo>(map);
                    if (layer) {
                        this.layers = map;
                    } else {
                        this.addons = map;
                    }
                }
                default: {
                    map.put(name, info);
                }
            }
        }

        public VerbosePatchInfo build() {
            return new VerbosePatchInfo(this.version, this.cpId, Collections.unmodifiableList(this.patchIds), Collections.unmodifiableMap(this.layers), Collections.unmodifiableMap(this.addons));
        }
    }
}

