/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationModificationImpl;
import org.jboss.as.patching.installation.InstalledIdentityImpl;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.LayerInfo;
import org.jboss.as.patching.installation.LayersFactory;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.version.ProductConfig;

public abstract class InstalledIdentity {
    private final AtomicBoolean writable = new AtomicBoolean(true);

    public abstract List<String> getAllInstalledPatches();

    public abstract Identity getIdentity();

    public abstract List<String> getLayerNames();

    public abstract Layer getLayer(String var1);

    public abstract List<Layer> getLayers();

    public abstract Collection<String> getAddOnNames();

    public abstract AddOn getAddOn(String var1);

    public abstract Collection<AddOn> getAddOns();

    protected abstract void updateState(String var1, InstallationModificationImpl var2, InstallationModificationImpl.InstallationState var3);

    public abstract InstalledImage getInstalledImage();

    public InstallationManager.InstallationModification modifyInstallation(final InstallationManager.ModificationCompletionCallback callback) {
        if (!this.writable.compareAndSet(true, false)) {
            throw new ConcurrentModificationException();
        }
        try {
            final InstalledIdentity original = InstalledIdentity.copy(this);
            final Identity identity = original.getIdentity();
            PatchableTarget.TargetInfo identityInfo = identity.loadTargetInfo();
            InstallationModificationImpl.InstallationState state = InstalledIdentity.load(this);
            return new InstallationModificationImpl(identityInfo, identity.getName(), identity.getVersion(), this.getAllInstalledPatches(), state){

                @Override
                public InstalledIdentity getUnmodifiedInstallationState() {
                    return original;
                }

                @Override
                public void complete() {
                    try {
                        InstalledIdentity.this.updateState(identity.getName(), this, this.internalComplete());
                        InstalledIdentity.this.writable.set(true);
                    }
                    catch (Exception e) {
                        this.cancel();
                        throw new RuntimeException(e);
                    }
                    if (callback != null) {
                        callback.completed();
                    }
                }

                @Override
                public void cancel() {
                    try {
                        if (callback != null) {
                            callback.canceled();
                        }
                    }
                    finally {
                        InstalledIdentity.this.writable.set(true);
                    }
                }
            };
        }
        catch (Exception e) {
            this.writable.set(true);
            throw new RuntimeException(e);
        }
    }

    protected static InstallationModificationImpl.InstallationState load(InstalledIdentity installedIdentity) throws IOException {
        InstallationModificationImpl.InstallationState state = new InstallationModificationImpl.InstallationState();
        for (Layer layer : installedIdentity.getLayers()) {
            state.putLayer(layer);
        }
        for (AddOn addOn : installedIdentity.getAddOns()) {
            state.putAddOn(addOn);
        }
        return state;
    }

    public static InstalledIdentity load(File jbossHome, ProductConfig productConfig, File ... repoRoots) throws IOException {
        InstalledImage installedImage = InstalledIdentity.installedImage(jbossHome);
        return InstalledIdentity.load(installedImage, productConfig, Arrays.asList(repoRoots), Collections.emptyList());
    }

    public static InstalledIdentity load(InstalledImage installedImage, ProductConfig productConfig, List<File> moduleRoots, List<File> bundleRoots) throws IOException {
        return LayersFactory.load(installedImage, productConfig, moduleRoots, bundleRoots);
    }

    protected static InstalledIdentity copy(InstalledIdentity original) throws IOException {
        InstalledIdentityImpl copy = new InstalledIdentityImpl(original.getIdentity(), original.getAllInstalledPatches(), original.getInstalledImage());
        for (Layer layer : original.getLayers()) {
            copy.putLayer(layer.getName(), new LayerInfo(layer.getName(), layer.loadTargetInfo(), layer.getDirectoryStructure()));
        }
        for (AddOn addOn : original.getAddOns()) {
            copy.putAddOn(addOn.getName(), new LayerInfo(addOn.getName(), addOn.loadTargetInfo(), addOn.getDirectoryStructure()));
        }
        return copy;
    }

    static InstalledImage installedImage(final File jbossHome) {
        final File appClient = new File(jbossHome, "appclient");
        final File bundles = new File(jbossHome, "bundles");
        final File domain = new File(jbossHome, "domain");
        final File modules = new File(jbossHome, "modules");
        final File metadata = new File(jbossHome, ".installation");
        final File layersConf = new File(modules, "layers.conf");
        final File standalone = new File(jbossHome, "standalone");
        return new InstalledImage(){

            @Override
            public File getJbossHome() {
                return jbossHome;
            }

            @Override
            public File getAppClientDir() {
                return appClient;
            }

            @Override
            public File getBundlesDir() {
                return bundles;
            }

            @Override
            public File getDomainDir() {
                return domain;
            }

            @Override
            public File getInstallationMetadata() {
                return metadata;
            }

            @Override
            public File getPatchesDir() {
                return new File(this.getInstallationMetadata(), "patches");
            }

            @Override
            public File getModulesDir() {
                return modules;
            }

            @Override
            public File getPatchHistoryDir(String patchId) {
                return new File(this.getPatchesDir(), patchId);
            }

            @Override
            public File getStandaloneDir() {
                return standalone;
            }

            @Override
            public File getLayersConf() {
                return layersConf;
            }
        };
    }
}

