/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.runner.PatchUtils;

public class LayerInfo
implements Layer,
AddOn {
    private final String name;
    private final PatchableTarget.TargetInfo targetInfo;
    private final DirectoryStructure structure;

    public LayerInfo(String name, PatchableTarget.TargetInfo targetInfo, DirectoryStructure structure) {
        this.name = name;
        this.targetInfo = targetInfo;
        this.structure = structure;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DirectoryStructure getDirectoryStructure() {
        return this.structure;
    }

    @Override
    public PatchableTarget.TargetInfo loadTargetInfo() {
        return this.targetInfo;
    }

    static PatchableTarget.TargetInfo loadTargetInfoFromDisk(DirectoryStructure structure) throws IOException {
        Properties properties = PatchUtils.loadProperties(structure.getInstallationInfo());
        return LayerInfo.loadTargetInfo(properties, structure);
    }

    public static PatchableTarget.TargetInfo loadTargetInfo(Properties properties, DirectoryStructure structure) {
        String ref = PatchUtils.readRef(properties, "cumulative-patch-id");
        List<String> patches = PatchUtils.readRefs(properties);
        return new TargetInfoImpl(properties, ref, patches, structure);
    }

    static class TargetInfoImpl
    implements PatchableTarget.TargetInfo {
        private final Properties properties;
        private final String cumulativeID;
        private final List<String> patches;
        private final DirectoryStructure structure;

        TargetInfoImpl(Properties properties, String cumulativeID, List<String> patches, DirectoryStructure structure) {
            this.properties = properties;
            this.cumulativeID = cumulativeID;
            this.patches = Collections.unmodifiableList(patches);
            this.structure = structure;
        }

        @Override
        public String getCumulativePatchID() {
            return this.cumulativeID;
        }

        @Override
        public List<String> getPatchIDs() {
            return this.patches;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public DirectoryStructure getDirectoryStructure() {
            return this.structure;
        }
    }
}

