/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.ModuleItem;

public final class PatchUtils {
    public static final String JAR_EXT = ".jar";
    public static final String BACKUP_EXT = ".jar.patched";

    public static String readRef(Properties properties, String name) {
        String ref = (String)properties.get(name);
        if (ref == null) {
            return "base";
        }
        return ref;
    }

    public static List<String> readRefs(Properties properties) {
        return PatchUtils.readRefs(properties, "patches");
    }

    public static List<String> readRefs(Properties properties, String property) {
        String layersProp = (String)properties.get(property);
        if (layersProp == null || (layersProp = layersProp.trim()).length() == 0) {
            return Collections.emptyList();
        }
        String[] names = layersProp.split(",");
        ArrayList<String> patches = new ArrayList<String>();
        for (String name : names) {
            patches.add(name);
        }
        return Collections.unmodifiableList(patches);
    }

    public static String asString(List<String> values) {
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append(value);
            builder.append(',');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String readRef(File file) throws IOException {
        if (!file.exists()) {
            return "base";
        }
        FileInputStream is = new FileInputStream(file);
        try {
            String string = PatchUtils.readRef(is);
            return string;
        }
        finally {
            IoUtils.safeClose(is);
        }
    }

    public static List<String> readRefs(File file) throws IOException {
        if (!file.exists()) {
            return Collections.emptyList();
        }
        FileInputStream is = new FileInputStream(file);
        try {
            List<String> list = PatchUtils.readRefs(is);
            return list;
        }
        finally {
            IoUtils.safeClose(is);
        }
    }

    static String readRef(InputStream is) throws IOException {
        StringBuffer buffer = new StringBuffer();
        PatchUtils.readLine(is, buffer);
        return buffer.toString();
    }

    static List<String> readRefs(InputStream is) throws IOException {
        ArrayList<String> refs = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        do {
            String ref;
            if (buffer.length() <= 0 || (ref = buffer.toString().trim()).length() <= 0) continue;
            refs.add(ref);
        } while (PatchUtils.readLine(is, buffer));
        return refs;
    }

    public static void writeRef(File file, String ref) throws IOException {
        IoUtils.mkdir(file.getParentFile(), new String[0]);
        FileOutputStream os = new FileOutputStream(file);
        try {
            PatchUtils.writeLine(os, ref);
            os.flush();
            ((OutputStream)os).close();
        }
        finally {
            IoUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRefs(File file, List<String> refs, boolean append) throws IOException {
        IoUtils.mkdir(file.getParentFile(), new String[0]);
        FileOutputStream os = new FileOutputStream(file, append);
        try {
            PatchUtils.writeRefs(os, refs);
            os.flush();
            ((OutputStream)os).close();
        }
        finally {
            IoUtils.safeClose(os);
        }
    }

    public static void writeRefs(File file, List<String> refs) throws IOException {
        PatchUtils.writeRefs(file, refs, false);
    }

    static void writeRefs(OutputStream os, List<String> refs) throws IOException {
        for (String ref : refs) {
            PatchUtils.writeLine(os, ref);
        }
    }

    static void writeLine(OutputStream os, String s) throws IOException {
        os.write(s.getBytes());
        os.write(10);
    }

    static boolean readLine(InputStream is, StringBuffer buffer) throws IOException {
        buffer.setLength(0);
        block5: while (true) {
            int c = is.read();
            switch (c) {
                case 9: 
                case 13: {
                    continue block5;
                }
                case -1: {
                    return false;
                }
                case 10: {
                    return true;
                }
            }
            buffer.append((char)c);
        }
    }

    static String generateTimestamp() {
        return DateFormat.getInstance().format(new Date());
    }

    static File[] getModulePath(DirectoryStructure structure, PatchableTarget.TargetInfo info) {
        ArrayList<File> path = new ArrayList<File>();
        List<String> patches = info.getPatchIDs();
        for (String patch : patches) {
            path.add(structure.getModulePatchDirectory(patch));
        }
        String ref = info.getCumulativePatchID();
        if (!"base".equals(ref)) {
            path.add(structure.getModulePatchDirectory(ref));
        }
        path.add(structure.getModuleRoot());
        return path.toArray(new File[path.size()]);
    }

    static File[] getBundlePath(DirectoryStructure structure, PatchableTarget.TargetInfo info) {
        List<String> patches = info.getPatchIDs();
        ArrayList<File> path = new ArrayList<File>();
        for (String patch : patches) {
            path.add(structure.getBundlesPatchDirectory(patch));
        }
        String ref = info.getCumulativePatchID();
        if (!"base".equals(ref)) {
            path.add(structure.getBundlesPatchDirectory(ref));
        }
        path.add(structure.getBundleRepositoryRoot());
        return path.toArray(new File[path.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(File file, Properties properties) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
            properties.store(writer, "read only");
            ((Writer)writer).close();
        }
        finally {
            IoUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) throws IOException {
        Properties properties;
        if (!file.exists()) {
            return new Properties();
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            Properties props = new Properties();
            props.load(reader);
            properties = props;
        }
        catch (Throwable throwable) {
            IoUtils.safeClose(reader);
            throw throwable;
        }
        IoUtils.safeClose(reader);
        return properties;
    }

    public static File getRenamedFileName(File file) {
        String fileName = file.getName();
        if (fileName.endsWith(BACKUP_EXT)) {
            return new File(file.getParentFile(), fileName.substring(0, fileName.length() - BACKUP_EXT.length()) + JAR_EXT);
        }
        if (fileName.endsWith(JAR_EXT)) {
            return new File(file.getParentFile(), fileName.substring(0, fileName.length() - JAR_EXT.length()) + BACKUP_EXT);
        }
        return file;
    }

    public static byte[] getAbsentModuleContent(ModuleItem item) {
        StringBuilder builder = new StringBuilder(128);
        builder.append("<?xml version='1.0' encoding='UTF-8'?>\n<module-absent xmlns=\"urn:jboss:module:1.2\"");
        builder.append(" name=\"").append(item.getName()).append("\"");
        builder.append(" slot=\"").append(item.getSlot()).append("\"");
        builder.append(" />\n");
        return builder.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] getAbsentModuleContentHash(ModuleItem item) throws IOException {
        byte[] content = PatchUtils.getAbsentModuleContent(item);
        return HashUtils.hashBytes(content);
    }
}

