/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.ZipUtils;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.BundleItem;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationBuilderTarget;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBuilder;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchElementBuilder;
import org.jboss.as.patching.metadata.PatchElementProvider;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.metadata.SecurityActions;
import org.jboss.as.patching.runner.PatchUtils;

public class PatchMerger {
    private static final String DIRECTORY_PREFIX = "wildfly-patch-";
    public static final String PATCH_XML_SUFFIX = "-patch.xml";
    private static final File TEMP_DIR = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));

    public static File merge(File patch1, File patch2, File merged) throws PatchingException {
        File workDir = PatchMerger.createTempDir();
        File patch1Dir = PatchMerger.expandContent(patch1, workDir, "patch1");
        File patch2Dir = PatchMerger.expandContent(patch2, workDir, "patch2");
        File mergedDir = new File(workDir, "merged");
        Patch patch1Metadata = PatchMerger.parsePatchXml(patch1Dir, patch1);
        Patch patch2Metadata = PatchMerger.parsePatchXml(patch2Dir, patch2);
        Patch mergedMetadata = PatchMerger.merge(patch1Metadata, patch2Metadata);
        if (!mergedDir.mkdirs()) {
            throw new PatchingException("Failed to create directory " + mergedDir.getAbsolutePath());
        }
        for (File f : patch1Dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(PatchMerger.PATCH_XML_SUFFIX);
            }
        })) {
            Patch patch;
            try {
                patch = PatchXml.parse(f).resolvePatch(null, null);
            }
            catch (Exception e) {
                throw new PatchingException("Failed to parse " + f.getAbsolutePath(), e);
            }
            patch = PatchMerger.merge(patch, patch2Metadata);
            FileWriter writer = null;
            try {
                writer = new FileWriter(new File(mergedDir, f.getName()));
                PatchXml.marshal(writer, patch);
            }
            catch (Exception e) {
                try {
                    throw new PatchingException("Failed to marshal merged metadata into " + f.getName(), e);
                }
                catch (Throwable throwable) {
                    IoUtils.safeClose(writer);
                    throw throwable;
                }
            }
            IoUtils.safeClose(writer);
        }
        PatchMerger.copyFile(new File(patch2Dir, "patch.xml"), new File(mergedDir, patch2Metadata.getIdentity().getVersion() + PATCH_XML_SUFFIX));
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(mergedDir, "patch.xml"));
            PatchXml.marshal(writer, mergedMetadata);
        }
        catch (Exception e) {
            try {
                throw new PatchingException("Failed to marshal merged metadata into patch.xml", e);
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(writer);
                throw throwable;
            }
        }
        IoUtils.safeClose(writer);
        try {
            PatchMerger.mergeRootContent(new File(patch1Dir, patch1Metadata.getPatchId()), new File(patch2Dir, patch2Metadata.getPatchId()), new File(mergedDir, patch2Metadata.getPatchId()));
        }
        catch (IOException e) {
            throw new PatchingException("Failed to merge root modifications", e);
        }
        try {
            PatchMerger.mergeElementContent(patch1Dir, patch2Dir, mergedDir, patch1Metadata, patch2Metadata);
        }
        catch (IOException e) {
            throw new PatchingException("Failed to merge element modifications", e);
        }
        ZipUtils.zip(mergedDir, merged);
        IoUtils.recursiveDelete(workDir);
        return merged;
    }

    private static void copyFile(File source, File target) throws PatchingException {
        try {
            IoUtils.copy(source, target);
        }
        catch (IOException e1) {
            throw new PatchingException("Failed to copy " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        }
    }

    private static void mergeElementContent(File patch1Dir, File patch2Dir, File mergedDir, Patch patch1Metadata, Patch patch2Metadata) throws PatchingException, IOException {
        HashMap<String, PatchElement> patch2Elements = new HashMap<String, PatchElement>(patch2Metadata.getElements().size());
        for (PatchElement e : patch2Metadata.getElements()) {
            patch2Elements.put(e.getProvider().getName(), e);
        }
        for (PatchElement e1 : patch1Metadata.getElements()) {
            File e1Dir = new File(patch1Dir, e1.getId());
            PatchElement e2 = (PatchElement)patch2Elements.remove(e1.getProvider().getName());
            if (e2 == null) {
                if (!e1Dir.exists()) continue;
                IoUtils.copyFile(e1Dir, new File(mergedDir, e1.getId()));
                continue;
            }
            ContentModifications cp2Mods = new ContentModifications(e2.getModifications());
            for (ContentModification cp1Mod : e1.getModifications()) {
                ContentModification cp2Mod = cp2Mods.remove(cp1Mod.getItem());
                if (cp2Mod == null) {
                    PatchMerger.copyModificationContent(patch1Dir, e1.getId(), mergedDir, e2.getId(), cp1Mod);
                    continue;
                }
                PatchMerger.copyModificationContent(patch2Dir, e2.getId(), mergedDir, e2.getId(), cp2Mod);
            }
            for (ContentModification cp2Mod : cp2Mods.getModifications()) {
                PatchMerger.copyModificationContent(patch2Dir, e2.getId(), mergedDir, e2.getId(), cp2Mod);
            }
        }
        for (PatchElement e2 : patch2Elements.values()) {
            File e2Dir = new File(patch2Dir, e2.getId());
            if (!e2Dir.exists()) continue;
            IoUtils.copyFile(e2Dir, new File(mergedDir, e2.getId()));
        }
    }

    private static void copyModificationContent(File srcPatchDir, String srcElementId, File targetPatchDir, String targetElementId, ContentModification mod) throws PatchingException {
        ModificationType type = mod.getType();
        if (type.equals((Object)ModificationType.REMOVE)) {
            return;
        }
        File modSrcDir = new File(srcPatchDir, srcElementId);
        File modTrgDir = new File(targetPatchDir, targetElementId);
        ContentType contentType = mod.getItem().getContentType();
        if (contentType.equals((Object)ContentType.MODULE)) {
            modSrcDir = new File(modSrcDir, "modules");
            modTrgDir = new File(modTrgDir, "modules");
            for (String name : mod.getItem().getName().split("\\.")) {
                modSrcDir = new File(modSrcDir, name);
                modTrgDir = new File(modTrgDir, name);
            }
        } else if (contentType.equals((Object)ContentType.BUNDLE)) {
            modSrcDir = new File(modSrcDir, "bundles");
            modTrgDir = new File(modTrgDir, "bundles");
            for (String name : mod.getItem().getName().split("\\.")) {
                modSrcDir = new File(modSrcDir, name);
                modTrgDir = new File(modTrgDir, name);
            }
        } else if (ContentType.MISC.equals((Object)contentType)) {
            modSrcDir = new File(modSrcDir, "misc");
            modTrgDir = new File(modTrgDir, "misc");
            for (String path : ((MiscContentItem)mod.getItem()).getPath()) {
                modSrcDir = new File(modSrcDir, path);
                modTrgDir = new File(modTrgDir, path);
            }
        } else {
            throw new PatchingException("Unexpected content type " + (Object)((Object)contentType));
        }
        try {
            IoUtils.copyFile(modSrcDir, modTrgDir);
        }
        catch (IOException e) {
            throw new PatchingException("Failed to copy modification content from " + modSrcDir.getAbsolutePath() + " to " + modTrgDir.getAbsolutePath());
        }
    }

    private static void mergeRootContent(File root1Dir, File root2Dir, File mergedRootDir) throws IOException {
        if (root1Dir.exists()) {
            IoUtils.copyFile(root1Dir, mergedRootDir);
        }
        if (root2Dir.exists()) {
            IoUtils.copyFile(root2Dir, mergedRootDir);
        }
    }

    private static Patch parsePatchXml(File patch1Dir, File patch1) throws PatchingException {
        File patch1Xml = new File(patch1Dir, "patch.xml");
        if (!patch1Xml.exists()) {
            throw new PatchingException("Failed to locate patch.xml in " + patch1.getAbsolutePath());
        }
        try {
            return PatchXml.parse(patch1Xml).resolvePatch(null, null);
        }
        catch (Exception e) {
            throw new PatchingException("Failed to parse patch.xml from " + patch1.getAbsolutePath(), e);
        }
    }

    private static File expandContent(File patchFile, File workDir, String expandDirName) throws PatchingException {
        File patchDir;
        try {
            if (!patchFile.isDirectory()) {
                patchDir = new File(workDir, expandDirName);
                File cachedContent = new File(patchDir, "content");
                IoUtils.copy(patchFile, cachedContent);
                ZipUtils.unzip(cachedContent, patchDir);
            } else {
                patchDir = patchFile;
            }
        }
        catch (IOException e) {
            throw new PatchingException("Failed to unzip " + patchFile.getAbsolutePath());
        }
        return patchDir;
    }

    public static Patch merge(Patch cp1, Patch cp2) throws PatchingException {
        return PatchMerger.merge(cp1, cp2, true);
    }

    public static Patch merge(Patch cp1, Patch cp2, boolean nextVersion) throws PatchingException {
        PatchElementProvider provider;
        Identity.IdentityUpgrade cp1Identity = cp1.getIdentity().forType(Patch.PatchType.CUMULATIVE, Identity.IdentityUpgrade.class);
        Identity.IdentityUpgrade cp2Identity = cp2.getIdentity().forType(Patch.PatchType.CUMULATIVE, Identity.IdentityUpgrade.class);
        PatchMerger.assertUpgrade(cp1Identity.getPatchType());
        PatchMerger.assertUpgrade(cp2Identity.getPatchType());
        if (!cp1Identity.getName().equals(cp2Identity.getName())) {
            throw new PatchingException("Patches target different identities: " + cp1Identity.getName() + " and " + cp2Identity.getName());
        }
        if (nextVersion && !cp1Identity.getResultingVersion().equals(cp2Identity.getVersion())) {
            throw new PatchingException(cp1.getPatchId() + " upgrades to version " + cp1Identity.getResultingVersion() + " but " + cp2.getPatchId() + " targets version " + cp2Identity.getVersion());
        }
        PatchBuilder builder = PatchBuilder.create().setPatchId(cp2.getPatchId()).setDescription(cp2.getDescription()).setLink(cp2.getLink());
        builder.upgradeIdentity(cp1Identity.getName(), cp1Identity.getVersion(), cp2Identity.getResultingVersion());
        HashMap<String, PatchElement> cp2LayerElements = new HashMap<String, PatchElement>();
        HashMap<String, PatchElement> cp2AddonElements = new HashMap<String, PatchElement>();
        for (PatchElement pe : cp2.getElements()) {
            provider = pe.getProvider();
            PatchMerger.assertUpgrade(provider.getPatchType());
            if (provider.isAddOn()) {
                cp2AddonElements.put(provider.getName(), pe);
                continue;
            }
            cp2LayerElements.put(provider.getName(), pe);
        }
        for (PatchElement cp1El : cp1.getElements()) {
            provider = cp1El.getProvider();
            PatchMerger.assertUpgrade(provider.getPatchType());
            PatchElement cp2El = provider.isAddOn() ? (PatchElement)cp2AddonElements.remove(provider.getName()) : (PatchElement)cp2LayerElements.remove(provider.getName());
            if (cp2El == null) {
                builder.addElement(cp1El);
                continue;
            }
            PatchElementBuilder elementBuilder = builder.upgradeElement(cp2El.getId(), provider.getName(), provider.isAddOn()).setDescription(cp2El.getDescription());
            PatchMerger.mergeModifications(elementBuilder, cp1El.getModifications(), cp2El.getModifications(), cp1, cp2);
        }
        for (PatchElement cp2Element : cp2LayerElements.values()) {
            builder.addElement(cp2Element);
        }
        for (PatchElement cp2Element : cp2AddonElements.values()) {
            builder.addElement(cp2Element);
        }
        PatchMerger.mergeModifications(builder, cp1.getModifications(), cp2.getModifications(), cp1, cp2);
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void mergeModifications(ModificationBuilderTarget<?> elementBuilder, Collection<ContentModification> cp1Modifications, Collection<ContentModification> cp2Modifications, Patch cp1, Patch cp2) throws PatchingException {
        ContentModifications cp2Mods = new ContentModifications(cp2Modifications);
        for (ContentModification cp1Mod : cp1Modifications) {
            ContentItem cp1Item;
            BundleItem bundle;
            MiscContentItem misc;
            ModuleItem module;
            ModificationType modType;
            ModificationType cp2Type;
            ContentModification cp2Mod;
            block24: {
                ModificationType cp1Type;
                block25: {
                    cp2Mod = cp2Mods.remove(cp1Mod.getItem());
                    if (cp2Mod == null) {
                        elementBuilder.addContentModification(cp1Mod);
                        continue;
                    }
                    cp1Type = cp1Mod.getType();
                    cp2Type = cp2Mod.getType();
                    if (!cp1Type.equals((Object)ModificationType.ADD)) break block25;
                    if (cp2Type.equals((Object)ModificationType.ADD)) {
                        throw new PatchingException("Patch " + cp2.getPatchId() + " adds " + cp1Mod.getItem().getRelativePath() + " already added by patch " + cp1.getPatchId());
                    }
                    if (cp2Type.equals((Object)ModificationType.MODIFY)) {
                        modType = ModificationType.ADD;
                        break block24;
                    } else if (cp1Mod.getItem().getContentType().equals((Object)ContentType.MODULE)) {
                        modType = ModificationType.ADD;
                        break block24;
                    } else {
                        modType = null;
                        continue;
                    }
                }
                if (cp1Type.equals((Object)ModificationType.REMOVE)) {
                    if (cp2Type.equals((Object)ModificationType.REMOVE)) {
                        throw new PatchingException("Patch " + cp2.getPatchId() + " removes " + cp1Mod.getItem().getRelativePath() + " already removed by patch " + cp1.getPatchId());
                    }
                    modType = ModificationType.MODIFY;
                } else {
                    if (cp2Type.equals((Object)ModificationType.ADD)) {
                        throw new PatchingException("Patch " + cp2.getPatchId() + " adds " + cp1Mod.getItem().getRelativePath() + " modified by patch " + cp1.getPatchId());
                    }
                    modType = cp2Type.equals((Object)ModificationType.REMOVE) ? ModificationType.REMOVE : ModificationType.MODIFY;
                }
            }
            if (ModificationType.ADD.equals((Object)modType)) {
                ContentItem cp2Item = cp2Mod.getItem();
                if (cp2Item.getContentType().equals((Object)ContentType.MODULE)) {
                    module = (ModuleItem)cp2Item;
                    if (cp2Type.equals((Object)ModificationType.REMOVE)) {
                        try {
                            elementBuilder.addModule(module.getName(), module.getSlot(), PatchUtils.getAbsentModuleContentHash(module));
                            continue;
                        }
                        catch (IOException e) {
                            throw new PatchingException("Failed to calculate hash for the removed module " + module.getName(), e);
                        }
                    }
                    elementBuilder.addModule(module.getName(), module.getSlot(), module.getContentHash());
                    continue;
                }
                if (cp2Item.getContentType().equals((Object)ContentType.MISC)) {
                    misc = (MiscContentItem)cp2Item;
                    elementBuilder.addFile(misc.getName(), Arrays.asList(misc.getPath()), misc.getContentHash(), misc.isDirectory());
                    continue;
                }
                bundle = (BundleItem)cp2Item;
                elementBuilder.addBundle(bundle.getName(), bundle.getSlot(), bundle.getContentHash());
                continue;
            }
            if (ModificationType.REMOVE.equals((Object)modType)) {
                cp1Item = cp1Mod.getItem();
                if (cp1Item.getContentType().equals((Object)ContentType.MODULE)) {
                    module = (ModuleItem)cp2Mod.getItem();
                    elementBuilder.removeModule(module.getName(), module.getSlot(), cp1Mod.getTargetHash());
                    continue;
                }
                if (cp1Item.getContentType().equals((Object)ContentType.MISC)) {
                    misc = (MiscContentItem)cp2Mod.getItem();
                    elementBuilder.removeFile(misc.getName(), Arrays.asList(misc.getPath()), cp1Mod.getTargetHash(), misc.isDirectory());
                    continue;
                }
                bundle = (BundleItem)cp2Mod.getItem();
                elementBuilder.removeBundle(bundle.getName(), bundle.getSlot(), cp1Mod.getTargetHash());
                continue;
            }
            cp1Item = cp1Mod.getItem();
            if (cp1Item.getContentType().equals((Object)ContentType.MODULE)) {
                module = (ModuleItem)cp2Mod.getItem();
                elementBuilder.modifyModule(module.getName(), module.getSlot(), cp1Mod.getTargetHash(), module.getContentHash());
                continue;
            }
            if (cp1Item.getContentType().equals((Object)ContentType.MISC)) {
                misc = (MiscContentItem)cp2Mod.getItem();
                elementBuilder.modifyFile(misc.getName(), Arrays.asList(misc.getPath()), cp1Mod.getTargetHash(), misc.getContentHash(), misc.isDirectory());
                continue;
            }
            bundle = (BundleItem)cp2Mod.getItem();
            elementBuilder.modifyBundle(bundle.getName(), bundle.getSlot(), cp1Mod.getTargetHash(), bundle.getContentHash());
        }
        Iterator<ContentModification> iterator = cp2Mods.getModifications().iterator();
        while (iterator.hasNext()) {
            ContentModification cp2Mod = iterator.next();
            elementBuilder.addContentModification(cp2Mod);
        }
        return;
    }

    private static void assertUpgrade(Patch.PatchType patchType) throws PatchingException {
        if (!Patch.PatchType.CUMULATIVE.equals((Object)patchType)) {
            throw new PatchingException("Merging one-off patches is not supported at this point.");
        }
    }

    static File createTempDir() throws PatchingException {
        return PatchMerger.createTempDir(TEMP_DIR);
    }

    static File createTempDir(File parent) throws PatchingException {
        File workDir = null;
        int count = 0;
        while (workDir == null || workDir.exists()) {
            workDir = new File(parent == null ? TEMP_DIR : parent, DIRECTORY_PREFIX + ++count);
        }
        if (!workDir.mkdirs()) {
            throw new PatchingException(PatchLogger.ROOT_LOGGER.cannotCreateDirectory(workDir.getAbsolutePath()));
        }
        return workDir;
    }

    private static void ls(File f) {
        System.out.println(f.getAbsolutePath());
        for (File c : f.listFiles()) {
            PatchMerger.ls(c, "  ");
        }
    }

    private static void ls(File f, String offset) {
        System.out.println(offset + f.getName());
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                PatchMerger.ls(c, offset + "  ");
            }
        }
    }

    private static class ContentModifications {
        private final Map<Integer, ContentModification> modifications;

        ContentModifications(Collection<ContentModification> mods) {
            this.modifications = new HashMap<Integer, ContentModification>(mods.size());
            for (ContentModification mod : mods) {
                this.modifications.put(this.getKey(mod.getItem()), mod);
            }
        }

        ContentModification remove(ContentItem item) {
            return this.modifications.remove(this.getKey(item));
        }

        Collection<ContentModification> getModifications() {
            return this.modifications.values();
        }

        private Integer getKey(ContentItem item) {
            int prime = 31;
            int result = 1;
            result = 31 * result + item.getContentType().hashCode();
            result = 31 * result + item.getRelativePath().hashCode();
            return result;
        }
    }
}

