/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationManagerService;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.management.PatchResourceDefinition;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.as.patching.tool.PatchTool;
import org.jboss.as.patching.tool.PatchingResult;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceRegistry;

public class LocalPatchRollbackLastHandler
implements OperationStepHandler {
    public static final LocalPatchRollbackLastHandler INSTANCE = new LocalPatchRollbackLastHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean resetConfiguration = PatchResourceDefinition.RESET_CONFIGURATION.resolveModelAttribute(context, operation).asBoolean();
        ServiceRegistry registry = context.getServiceRegistry(true);
        final InstallationManager installationManager = (InstallationManager)registry.getRequiredService(InstallationManagerService.NAME).getValue();
        if (installationManager.requiresRestart()) {
            throw PatchLogger.ROOT_LOGGER.serverRequiresRestart();
        }
        PatchTool runner = PatchTool.Factory.create(installationManager);
        ContentVerificationPolicy policy = PatchTool.Factory.create(operation);
        try {
            final PatchingResult result = runner.rollbackLast(policy, resetConfiguration);
            installationManager.restartRequired();
            context.restartRequired();
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        result.commit();
                    } else {
                        installationManager.clearRestartRequired();
                        context.revertRestartRequired();
                        result.rollback();
                    }
                }
            });
        }
        catch (PatchingException e) {
            ModelNode failureDescription = context.getFailureDescription();
            PatchOperationTarget.formatFailedResponse(e, failureDescription);
            installationManager.clearRestartRequired();
            context.stepCompleted();
        }
    }
}

