/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.tool;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.patching.ContentConflictsException;
import org.jboss.as.patching.PatchInfo;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.tool.ContentPolicyBuilderImpl;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchTool;
import org.jboss.as.patching.tool.PatchingResult;
import org.jboss.dmr.ModelNode;

public abstract class PatchOperationTarget {
    static final PathElement CORE_SERVICES = PathElement.pathElement((String)"core-service", (String)"patching");

    public static final PatchOperationTarget createLocal(File jbossHome, List<File> moduleRoots, List<File> bundlesRoots) throws IOException {
        PatchTool tool = PatchTool.Factory.createLocalTool(jbossHome, moduleRoots, bundlesRoots);
        return new LocalPatchOperationTarget(tool);
    }

    public static final PatchOperationTarget createStandalone(ModelControllerClient controllerClient) {
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{CORE_SERVICES});
        return new RemotePatchOperationTarget(address, controllerClient);
    }

    public static final PatchOperationTarget createHost(String hostName, ModelControllerClient client) {
        PathElement host = PathElement.pathElement((String)"host", (String)hostName);
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{host, CORE_SERVICES});
        return new RemotePatchOperationTarget(address, client);
    }

    protected abstract ModelNode info() throws IOException;

    protected abstract ModelNode history() throws IOException;

    protected abstract ModelNode applyPatch(File var1, ContentPolicyBuilderImpl var2) throws IOException;

    protected abstract ModelNode rollback(String var1, ContentPolicyBuilderImpl var2, boolean var3, boolean var4) throws IOException;

    protected abstract ModelNode rollbackLast(ContentPolicyBuilderImpl var1, boolean var2) throws IOException;

    static ModelNode formatFailedResponse(PatchingException e) {
        ModelNode result = new ModelNode();
        result.get("outcome").set("failed");
        PatchOperationTarget.formatFailedResponse(e, result.get("failure-description"));
        return result;
    }

    public static void formatFailedResponse(PatchingException e, ModelNode failureDescription) {
        if (e instanceof ContentConflictsException) {
            failureDescription.get("message").set(PatchLogger.ROOT_LOGGER.detectedConflicts());
            ModelNode conflicts = failureDescription.get("conflicts");
            for (ContentItem item : ((ContentConflictsException)e).getConflicts()) {
                ContentType type = item.getContentType();
                switch (type) {
                    case BUNDLE: {
                        conflicts.get("bundles").add(item.getRelativePath());
                        break;
                    }
                    case MODULE: {
                        conflicts.get("modules").add(item.getRelativePath());
                        break;
                    }
                    case MISC: {
                        conflicts.get("misc").add(item.getRelativePath());
                    }
                }
            }
        } else {
            failureDescription.set(e.getLocalizedMessage());
        }
    }

    static ModelNode createOperation(String operationName, ModelNode addr, ContentPolicyBuilderImpl builder) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set(operationName);
        operation.get("address").set(addr);
        operation.get("override-modules").set(builder.ignoreModulesChanges);
        operation.get("override-all").set(builder.overrideAll);
        if (!builder.override.isEmpty()) {
            for (String o : builder.override) {
                operation.get("override").add(o);
            }
        }
        if (!builder.preserve.isEmpty()) {
            for (String p : builder.preserve) {
                operation.get("preserve").add(p);
            }
        }
        return operation;
    }

    protected static class RemotePatchOperationTarget
    extends PatchOperationTarget {
        private final PathAddress address;
        private final ModelControllerClient client;

        public RemotePatchOperationTarget(PathAddress address, ModelControllerClient client) {
            this.address = address;
            this.client = client;
        }

        @Override
        protected ModelNode info() throws IOException {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-resource");
            operation.get("address").set(this.address.toModelNode());
            operation.get("recursive").set(true);
            operation.get("include-runtime").set(true);
            return this.client.execute(operation);
        }

        @Override
        protected ModelNode history() throws IOException {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("show-history");
            operation.get("address").set(this.address.toModelNode());
            return this.client.execute(operation);
        }

        @Override
        protected ModelNode applyPatch(File file, ContentPolicyBuilderImpl policyBuilder) throws IOException {
            ModelNode operation = RemotePatchOperationTarget.createOperation("patch", this.address.toModelNode(), policyBuilder);
            operation.get("input-stream-index").set(0);
            OperationBuilder operationBuilder = OperationBuilder.create((ModelNode)operation);
            operationBuilder.addFileAsAttachment(file);
            return this.client.execute(operationBuilder.build());
        }

        @Override
        protected ModelNode rollback(String patchId, ContentPolicyBuilderImpl builder, boolean rollbackTo, boolean resetConfiguration) throws IOException {
            ModelNode operation = RemotePatchOperationTarget.createOperation("rollback", this.address.toModelNode(), builder);
            operation.get("patch-id").set(patchId);
            operation.get("reset-configuration").set(resetConfiguration);
            operation.get("rollback-to").set(rollbackTo);
            return this.client.execute(operation);
        }

        @Override
        protected ModelNode rollbackLast(ContentPolicyBuilderImpl builder, boolean restoreConfiguration) throws IOException {
            ModelNode operation = RemotePatchOperationTarget.createOperation("rollback-last", this.address.toModelNode(), builder);
            operation.get("reset-configuration").set(restoreConfiguration);
            return this.client.execute(operation);
        }
    }

    protected static class LocalPatchOperationTarget
    extends PatchOperationTarget {
        private final PatchTool tool;

        public LocalPatchOperationTarget(PatchTool tool) {
            this.tool = tool;
        }

        @Override
        protected ModelNode info() throws IOException {
            PatchInfo info = this.tool.getPatchInfo();
            ModelNode result = new ModelNode();
            result.get("outcome").set("success");
            result.get(new String[]{"result", "cumulative-patch-id"}).set(info.getCumulativePatchID());
            result.get(new String[]{"result", "patches"}).setEmptyList();
            for (String patch : info.getPatchIDs()) {
                result.get(new String[]{"result", "patches"}).add(patch);
            }
            return result;
        }

        @Override
        protected ModelNode history() {
            ModelNode result = new ModelNode();
            result.get("outcome").set("success");
            try {
                result.get("result").set(this.tool.getPatchingHistory().getHistory());
            }
            catch (PatchingException e) {
                return LocalPatchOperationTarget.formatFailedResponse(e);
            }
            return result;
        }

        @Override
        protected ModelNode applyPatch(File file, ContentPolicyBuilderImpl builder) {
            ContentVerificationPolicy policy = builder.createPolicy();
            ModelNode result = new ModelNode();
            try {
                PatchingResult apply = this.tool.applyPatch(file, policy);
                apply.commit();
                result.get("outcome").set("success");
                result.get("result").setEmptyObject();
            }
            catch (PatchingException e) {
                return LocalPatchOperationTarget.formatFailedResponse(e);
            }
            return result;
        }

        @Override
        protected ModelNode rollback(String patchId, ContentPolicyBuilderImpl builder, boolean rollbackTo, boolean resetConfiguration) {
            ContentVerificationPolicy policy = builder.createPolicy();
            ModelNode result = new ModelNode();
            try {
                PatchingResult rollback = this.tool.rollback(patchId, policy, rollbackTo, resetConfiguration);
                rollback.commit();
                result.get("outcome").set("success");
                result.get("result").setEmptyObject();
            }
            catch (PatchingException e) {
                return LocalPatchOperationTarget.formatFailedResponse(e);
            }
            return result;
        }

        @Override
        protected ModelNode rollbackLast(ContentPolicyBuilderImpl builder, boolean restoreConfiguration) {
            ContentVerificationPolicy policy = builder.createPolicy();
            ModelNode result = new ModelNode();
            try {
                PatchingResult rollback = this.tool.rollbackLast(policy, restoreConfiguration);
                rollback.commit();
                result.get("outcome").set("success");
                result.get("result").setEmptyObject();
            }
            catch (PatchingException e) {
                return LocalPatchOperationTarget.formatFailedResponse(e);
            }
            return result;
        }
    }
}

