/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class ModelTestUtils {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");

    public static String readResource(Class<?> clazz, String name) throws IOException {
        URL configURL = clazz.getResource(name);
        Assert.assertNotNull((String)(name + " url is null"), (Object)configURL);
        StringWriter writer = new StringWriter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(configURL.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write("\n");
            }
        }
        return writer.toString();
    }

    public static ModelNode checkResultAndGetContents(ModelNode result) {
        ModelTestUtils.checkOutcome(result);
        Assert.assertTrue((String)("could not check for result as its missing!  look for yourself here [" + result.toString() + "] and result.hasDefined(RESULT) returns " + result.hasDefined("result")), (boolean)result.hasDefined("result"));
        return result.get("result");
    }

    public static ModelNode checkOutcome(ModelNode result) {
        boolean success = "success".equals(result.get("outcome").asString());
        Assert.assertTrue((String)result.get("failure-description").asString(), (boolean)success);
        return result;
    }

    public static ModelNode checkFailed(ModelNode result) {
        Assert.assertEquals((Object)"failed", (Object)result.get("outcome").asString());
        return result.get("failure-description");
    }

    public static void validateModelDescriptions(PathAddress address, ImmutableManagementResourceRegistration reg) {
        ModelNode description = reg.getModelDescription(PathAddress.EMPTY_ADDRESS).getModelDescription(Locale.getDefault());
        ModelNode attributes = description.get("attributes");
        Set regAttributeNames = reg.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        Set<String> attributeNames = new HashSet<String>();
        if (attributes.isDefined()) {
            if (attributes.asList().size() != regAttributeNames.size()) {
                for (Property p : attributes.asPropertyList()) {
                    attributeNames.add(p.getName());
                }
                if (regAttributeNames.size() > attributeNames.size()) {
                    regAttributeNames.removeAll(attributeNames);
                    Assert.fail((String)("More attributes defined on resource registration than in description, missing: " + String.valueOf(regAttributeNames) + " for " + String.valueOf(address)));
                } else if (regAttributeNames.size() < attributeNames.size()) {
                    attributeNames.removeAll(regAttributeNames);
                    Assert.fail((String)("More attributes defined in description than on resource registration, missing: " + String.valueOf(attributeNames) + " for " + String.valueOf(address)));
                }
            }
            LinkedHashMap<String, ModelNode> attrMap = new LinkedHashMap<String, ModelNode>();
            for (Property property : attributes.asPropertyList()) {
                attrMap.put(property.getName(), property.getValue());
            }
            attributeNames = attrMap.keySet();
            if (!attributeNames.containsAll(regAttributeNames)) {
                HashSet<Object> missDesc = new HashSet<Object>(attributeNames);
                missDesc.removeAll(regAttributeNames);
                HashSet hashSet = new HashSet(regAttributeNames);
                hashSet.removeAll(attributeNames);
                if (!hashSet.isEmpty()) {
                    Assert.fail((String)("There are different attributes defined on resource registration than in description, registered only on Resource Reg: " + String.valueOf(hashSet) + " for " + String.valueOf(address)));
                }
                if (!missDesc.isEmpty()) {
                    Assert.fail((String)("There are different attributes defined on resource registration than in description, registered only int description: " + String.valueOf(missDesc) + " for " + String.valueOf(address)));
                }
            }
            for (Map.Entry entry : attrMap.entrySet()) {
                ModelTestUtils.validateRequiredNillable("attribute " + (String)entry.getKey(), (ModelNode)entry.getValue());
            }
        }
        if (description.hasDefined("operations")) {
            ModelNode operations = description.get("operations");
            for (Property property : operations.asPropertyList()) {
                String prefix;
                ModelNode opDesc = property.getValue();
                if (opDesc.hasDefined("request-properties")) {
                    prefix = "operation " + property.getName() + " param ";
                    for (Property param : opDesc.get("request-properties").asPropertyList()) {
                        ModelTestUtils.validateRequiredNillable(prefix + param.getName(), param.getValue());
                    }
                }
                if (!opDesc.hasDefined("reply-properties")) continue;
                prefix = "operation " + property.getName() + " reply field ";
                for (Property field : opDesc.get("reply-properties").asPropertyList()) {
                    ModelTestUtils.validateRequiredNillable(prefix + field.getName(), field.getValue());
                }
            }
        }
        for (PathElement pe : reg.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ImmutableManagementResourceRegistration immutableManagementResourceRegistration = reg.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}));
            ModelTestUtils.validateModelDescriptions(address.append(new PathElement[]{pe}), immutableManagementResourceRegistration);
        }
    }

    private static void validateRequiredNillable(String name, ModelNode desc) {
        Assert.assertTrue((String)(name + " does not have 'required' metadata"), (boolean)desc.hasDefined("required"));
        Assert.assertEquals((String)(name + " does not have boolean 'required' metadata"), (Object)ModelType.BOOLEAN, (Object)desc.get("required").getType());
        Assert.assertTrue((String)(name + " does not have 'nillable' metadata"), (boolean)desc.hasDefined("nillable"));
        Assert.assertEquals((String)(name + " does not have boolean 'nillable' metadata"), (Object)ModelType.BOOLEAN, (Object)desc.get("nillable").getType());
        boolean alternatives = false;
        if (desc.hasDefined("alternatives")) {
            Assert.assertEquals((String)(name + " does not have 'alternatives' metadata in list form"), (Object)ModelType.LIST, (Object)desc.get("alternatives").getType());
            alternatives = desc.get("alternatives").asInt() > 0;
        }
        boolean required = desc.get("required").asBoolean();
        Assert.assertEquals((String)(name + " does not have correct 'nillable' metadata. required: " + required + " -- alternatives: " + String.valueOf(desc.get("alternatives"))), (Object)(!required || alternatives ? 1 : 0), (Object)desc.get("nillable").asBoolean());
    }

    public static void compare(ModelNode node1, ModelNode node2) {
        ModelTestUtils.compare(node1, node2, false);
    }

    public static void resolveAndCompareModels(ModelNode node1, ModelNode node2) {
        ModelTestUtils.compare(ModelTestUtils.resolve(node1), ModelTestUtils.resolve(node2), false, true, new Stack<String>());
    }

    private static ModelNode resolve(ModelNode unresolved) {
        try {
            return ExpressionResolver.TEST_RESOLVER.resolveExpressions(unresolved);
        }
        catch (OperationFailedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void compare(ModelNode node1, ModelNode node2, boolean ignoreUndefined) {
        ModelTestUtils.compare(node1, node2, ignoreUndefined, false, new Stack<String>());
    }

    public static String normalizeXML(String xml) throws Exception {
        xml = xml.replaceAll("\\s*<", "<");
        xml = xml.replaceAll(">\\s*", ">");
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS domLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSParser lsParser = domLS.createLSParser((short)1, null);
        LSInput input = domLS.createLSInput();
        input.setStringData(xml);
        Document document = lsParser.parse(input);
        LSSerializer lsSerializer = domLS.createLSSerializer();
        lsSerializer.getDomConfig().setParameter("comments", Boolean.FALSE);
        lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        return lsSerializer.writeToString(document);
    }

    public static void compareXml(String original, String marshalled) throws Exception {
        ModelTestUtils.compareXml(original, marshalled, false);
    }

    public static void compareXml(String original, String marshalled, boolean ignoreNamespace) throws Exception {
        String xmlMarshalled;
        String xmlOriginal;
        if (ignoreNamespace) {
            xmlOriginal = ModelTestUtils.removeNamespace(original);
            xmlMarshalled = ModelTestUtils.removeNamespace(marshalled);
        } else {
            xmlOriginal = original;
            xmlMarshalled = marshalled;
        }
        Assert.assertEquals((Object)ModelTestUtils.normalizeXML(xmlOriginal), (Object)ModelTestUtils.normalizeXML(xmlMarshalled));
    }

    public static ModelNode getSubModel(ModelNode model, PathElement pathElement) {
        return model.get(new String[]{pathElement.getKey(), pathElement.getValue()});
    }

    public static ModelNode getSubModel(ModelNode model, PathAddress pathAddress) {
        for (PathElement pathElement : pathAddress) {
            model = ModelTestUtils.getSubModel(model, pathElement);
        }
        return model;
    }

    public static void scanForExpressionFormattedStrings(ModelNode model) {
        if (model.getType().equals((Object)ModelType.STRING)) {
            if (EXPRESSION_PATTERN.matcher(model.asString()).matches()) {
                Assert.fail((String)("ModelNode with type==STRING contains an expression formatted string: " + model.asString()));
            }
        } else if (model.getType() == ModelType.OBJECT) {
            for (String key : model.keys()) {
                ModelNode child = model.get(key);
                ModelTestUtils.scanForExpressionFormattedStrings(child);
            }
        } else if (model.getType() == ModelType.LIST) {
            List list = model.asList();
            for (ModelNode entry : list) {
                ModelTestUtils.scanForExpressionFormattedStrings(entry);
            }
        } else if (model.getType() == ModelType.PROPERTY) {
            Property prop = model.asProperty();
            ModelTestUtils.scanForExpressionFormattedStrings(prop.getValue());
        }
    }

    private static String removeNamespace(String xml) {
        int start = xml.indexOf(" xmlns=\"");
        int end = xml.indexOf(34, start + "xmlns=\"".length() + 1);
        if (start != -1) {
            StringBuilder sb = new StringBuilder(xml.substring(0, start));
            sb.append(xml.substring(end + 1));
            return sb.toString();
        }
        return xml;
    }

    private static void compare(ModelNode node1, ModelNode node2, boolean ignoreUndefined, boolean ignoreType, Stack<String> stack) {
        if (!ignoreType) {
            Assert.assertEquals((String)(ModelTestUtils.getCompareStackAsString(stack) + " types"), (Object)node1.getType(), (Object)node2.getType());
        }
        if (node1.getType() == ModelType.OBJECT) {
            ModelNode model1 = ignoreUndefined ? ModelTestUtils.trimUndefinedChildren(node1) : node1;
            ModelNode model2 = ignoreUndefined ? ModelTestUtils.trimUndefinedChildren(node2) : node2;
            TreeSet keys1 = new TreeSet(model1.keys());
            TreeSet keys2 = new TreeSet(model2.keys());
            if (!((Object)keys1).toString().equals(((Object)keys2).toString())) {
                System.out.print("");
            }
            Assert.assertEquals((String)(ModelTestUtils.getCompareStackAsString(stack) + ": " + String.valueOf(node1) + "\n" + String.valueOf(node2)), (Object)((Object)keys1).toString(), (Object)((Object)keys2).toString());
            Assert.assertTrue((boolean)keys1.containsAll(keys2));
            for (String key : keys1) {
                ModelNode child1 = model1.get(key);
                Assert.assertTrue((String)("Missing: " + key + "\n" + String.valueOf(node1) + "\n" + String.valueOf(node2)), (boolean)model2.has(key));
                ModelNode child2 = model2.get(key);
                if (child1.isDefined()) {
                    if (!ignoreUndefined) {
                        Assert.assertTrue((String)(ModelTestUtils.getCompareStackAsString(stack) + " key=" + key + "\n with child1 \n" + child1.toString() + "\n has child2 not defined\n node2 is:\n" + node2.toString()), (boolean)child2.isDefined());
                    }
                    stack.push(key + "/");
                    ModelTestUtils.compare(child1, child2, ignoreUndefined, ignoreType, stack);
                    stack.pop();
                    continue;
                }
                if (ignoreUndefined) continue;
                Assert.assertFalse((String)(ModelTestUtils.getCompareStackAsString(stack) + " key=" + key + "\n with child1 undefined has child2 \n" + child2.asString()), (boolean)child2.isDefined());
            }
        } else if (node1.getType() == ModelType.LIST) {
            List list1 = node1.asList();
            List list2 = node2.asList();
            Assert.assertEquals((String)(String.valueOf(list1) + "\n" + String.valueOf(list2)), (long)list1.size(), (long)list2.size());
            for (int i = 0; i < list1.size(); ++i) {
                stack.push(i + "/");
                ModelTestUtils.compare((ModelNode)list1.get(i), (ModelNode)list2.get(i), ignoreUndefined, ignoreType, stack);
                stack.pop();
            }
        } else if (node1.getType() == ModelType.PROPERTY) {
            Property prop1 = node1.asProperty();
            Property prop2 = node2.asProperty();
            Assert.assertEquals((String)(String.valueOf(prop1) + "\n" + String.valueOf(prop2)), (Object)prop1.getName(), (Object)prop2.getName());
            stack.push(prop1.getName() + "/");
            ModelTestUtils.compare(prop1.getValue(), prop2.getValue(), ignoreUndefined, ignoreType, stack);
            stack.pop();
        } else {
            Assert.assertEquals((String)(ModelTestUtils.getCompareStackAsString(stack) + "\n\"" + node1.asString() + "\"\n\"" + node2.asString() + "\"\n-----"), (Object)node1.asString().trim(), (Object)node2.asString().trim());
        }
    }

    private static ModelNode trimUndefinedChildren(ModelNode model) {
        ModelNode copy = model.clone();
        for (String key : new HashSet(copy.keys())) {
            if (!copy.hasDefined(key)) {
                copy.remove(key);
                continue;
            }
            if (copy.get(key).getType() != ModelType.OBJECT) continue;
            for (ModelNode mn : model.get(key).asList()) {
                boolean undefined = true;
                Property p = mn.asProperty();
                if (p.getValue().getType() != ModelType.OBJECT) continue;
                for (String subKey : new HashSet(p.getValue().keys())) {
                    if (copy.get(new String[]{key, p.getName()}).hasDefined(subKey)) {
                        undefined = false;
                        break;
                    }
                    copy.get(new String[]{key, p.getName()}).remove(subKey);
                }
                if (!undefined) continue;
                copy.get(key).remove(p.getName());
                if (!copy.hasDefined(key)) {
                    copy.remove(key);
                    continue;
                }
                if (copy.get(key).getType() != ModelType.OBJECT || !copy.get(key).keys().isEmpty()) continue;
                copy.remove(key);
            }
        }
        return copy;
    }

    private static String getCompareStackAsString(Stack<String> stack) {
        StringBuilder buf = new StringBuilder();
        for (String element : stack) {
            buf.append(element);
        }
        return buf.toString();
    }

    public static void checkModelAgainstDefinition(ModelNode model, ManagementResourceRegistration rr) {
        ModelTestUtils.checkModelAgainstDefinition(model, rr, new Stack<PathElement>());
    }

    private static void checkModelAgainstDefinition(ModelNode model, ManagementResourceRegistration rr, Stack<PathElement> stack) {
        Set children = rr.getChildNames(PathAddress.EMPTY_ADDRESS);
        Set attributeNames = rr.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        for (ModelNode el : model.asList()) {
            String name = el.asProperty().getName();
            ModelNode value = el.asProperty().getValue();
            if (attributeNames.contains(name)) {
                AttributeAccess aa = rr.getAttributeAccess(PathAddress.EMPTY_ADDRESS, name);
                Assert.assertNotNull((String)(ModelTestUtils.getComparePathAsString(stack) + " Attribute " + name + " is not known"), (Object)aa);
                AttributeDefinition ad = aa.getAttributeDefinition();
                if (!value.isDefined()) {
                    Assert.assertTrue((String)(ModelTestUtils.getComparePathAsString(stack) + " Attribute " + name + " does not allow null"), (!ad.isRequired() || ad.getDefaultValue() == null ? 1 : 0) != 0);
                }
                try {
                    if (!ad.isRequired() || !value.isDefined()) continue;
                    ad.getValidator().validateParameter(name, value);
                }
                catch (OperationFailedException e) {
                    Assert.fail((String)(ModelTestUtils.getComparePathAsString(stack) + " validation for attribute '" + name + "' failed, " + e.getFailureDescription().asString()));
                }
                continue;
            }
            if (children.contains(name)) continue;
            Assert.fail((String)(ModelTestUtils.getComparePathAsString(stack) + " Element '" + name + "' is not known in target definition"));
        }
        List<PathElement> sortedChildAddresses = ModelTestUtils.moveWildcardChildrenToEnd(rr.getChildAddresses(PathAddress.EMPTY_ADDRESS));
        HashSet<PathElement> handledChildren = new HashSet<PathElement>();
        for (PathElement pe : sortedChildAddresses) {
            if (pe.isWildcard()) {
                if (children.contains(pe.getKey()) && model.hasDefined(pe.getKey())) {
                    for (ModelNode v : model.get(pe.getKey()).asList()) {
                        String name = v.asProperty().getName();
                        if (handledChildren.contains(PathElement.pathElement((String)pe.getKey(), (String)name))) continue;
                        ModelNode value = v.asProperty().getValue();
                        ManagementResourceRegistration sub = rr.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}));
                        Assert.assertNotNull((String)(ModelTestUtils.getComparePathAsString(stack) + " Child with name '" + name + "' not found"), (Object)sub);
                        if (!value.isDefined()) continue;
                        stack.push(pe);
                        ModelTestUtils.checkModelAgainstDefinition(value, sub, stack);
                        stack.pop();
                    }
                }
            } else if (children.contains(pe.getKey()) && model.hasDefined(pe.getKey()) && model.get(pe.getKey()).hasDefined(pe.getValue())) {
                String name = pe.getValue();
                ModelNode value = model.get(pe.getKeyValuePair());
                ManagementResourceRegistration sub = rr.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}));
                Assert.assertNotNull((String)(ModelTestUtils.getComparePathAsString(stack) + " Child with name '" + name + "' not found"), (Object)sub);
                if (value.isDefined()) {
                    stack.push(pe);
                    ModelTestUtils.checkModelAgainstDefinition(value, sub, stack);
                    stack.pop();
                }
            }
            handledChildren.add(pe);
        }
    }

    private static String getComparePathAsString(Stack<PathElement> stack) {
        PathAddress pa = PathAddress.EMPTY_ADDRESS;
        for (PathElement element : stack) {
            pa = pa.append(new PathElement[]{element});
        }
        return pa.toModelNode().asString();
    }

    public static void checkFailedTransformedBootOperations(ModelTestKernelServices<?> mainServices, ModelVersion modelVersion, List<ModelNode> operations, FailedOperationTransformationConfig config) throws OperationFailedException {
        ModelNode mainComposite = Util.createEmptyOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
        ModelNode mainSteps = mainComposite.get("steps").setEmptyList();
        for (ModelNode op : operations) {
            mainSteps.add(op.clone());
        }
        Assert.assertEquals(operations, (Object)mainSteps.asList());
        ModelTestUtils.checkOutcome(mainServices.executeOperation(mainComposite, new InputStream[0]));
        ModelNode legacyComposite = Util.createEmptyOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
        ModelNode legacySteps = legacyComposite.get("steps").setEmptyList();
        ArrayList<ModelNode> writeOps = new ArrayList<ModelNode>();
        for (ModelNode op : operations) {
            writeOps.addAll(config.createWriteAttributeOperations(op));
            ModelTestUtils.checkFailedTransformedAddOperation(mainServices, modelVersion, op, config, legacySteps);
        }
        config.invokeCallback();
        if (config.isTransformComposite()) {
            OperationTransformer.TransformedOperation transformedComposite = mainServices.transformOperation(modelVersion, legacyComposite);
            if (transformedComposite.rejectOperation(ModelTestUtils.successResult())) {
                Assert.fail((String)transformedComposite.getFailureDescription());
            }
            ModelTestUtils.checkOutcome(mainServices.executeOperation(modelVersion, transformedComposite));
        } else {
            Object legacyServices = mainServices.getLegacyServices(modelVersion);
            ModelTestUtils.checkOutcome(legacyServices.executeOperation(legacyComposite, new InputStream[0]));
        }
        for (ModelNode writeOp : writeOps) {
            ModelTestUtils.checkFailedTransformedWriteAttributeOperation(mainServices, modelVersion, writeOp, config);
        }
    }

    private static void checkFailedTransformedAddOperation(ModelTestKernelServices<?> mainServices, ModelVersion modelVersion, ModelNode operation, FailedOperationTransformationConfig config, ModelNode legacySteps) throws OperationFailedException {
        OperationTransformer.TransformedOperation transformedOperation = mainServices.transformOperation(modelVersion, operation.clone());
        if (config.expectFailed(operation)) {
            Assert.assertTrue((String)("Expected transformation to get rejected " + String.valueOf(operation) + " for version " + String.valueOf(modelVersion)), (boolean)transformedOperation.rejectOperation(ModelTestUtils.successResult()));
            Assert.assertNotNull((String)("Expected transformation to get rejected " + String.valueOf(operation) + " for version " + String.valueOf(modelVersion)), (Object)transformedOperation.getFailureDescription());
            if (config.canCorrectMore(operation)) {
                ModelTestUtils.checkFailedTransformedAddOperation(mainServices, modelVersion, config.correctOperation(operation), config, legacySteps);
            }
        } else if (config.expectDiscarded(operation)) {
            Assert.assertNull((String)("Expected null transformed operation for discarded " + String.valueOf(operation)), (Object)transformedOperation.getTransformedOperation());
            Assert.assertFalse((String)("Expected transformation to not be rejected for discarded " + String.valueOf(operation)), (boolean)transformedOperation.rejectOperation(ModelTestUtils.successResult()));
        } else {
            if (transformedOperation.rejectOperation(ModelTestUtils.successResult())) {
                Assert.fail((String)(String.valueOf(operation) + " should not have been rejected " + transformedOperation.getFailureDescription()));
            }
            Assert.assertFalse((boolean)config.canCorrectMore(operation));
            config.operationDone(operation);
            if (config.isTransformComposite()) {
                legacySteps.add(operation);
            } else {
                ModelNode transformed = transformedOperation.getTransformedOperation();
                if (transformed != null) {
                    legacySteps.add(transformed);
                }
            }
        }
    }

    private static void checkFailedTransformedWriteAttributeOperation(ModelTestKernelServices<?> mainServices, ModelVersion modelVersion, ModelNode operation, FailedOperationTransformationConfig config) throws OperationFailedException {
        OperationTransformer.TransformedOperation transformedOperation = mainServices.transformOperation(modelVersion, operation.clone());
        if (config.expectFailedWriteAttributeOperation(operation)) {
            Assert.assertNotNull((String)("Expected transformation to get rejected " + String.valueOf(operation)), (Object)transformedOperation.getFailureDescription());
            ModelTestUtils.checkFailedTransformedWriteAttributeOperation(mainServices, modelVersion, config.correctWriteAttributeOperation(operation), config);
        } else {
            ModelNode result = mainServices.executeOperation(modelVersion, transformedOperation);
            Assert.assertEquals((String)("Failed: " + String.valueOf(operation) + "\n: " + String.valueOf(result)), (Object)"success", (Object)result.get("outcome").asString());
        }
    }

    private static ModelNode successResult() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("success");
        result.get("result");
        return result;
    }

    public static List<PathElement> moveWildcardChildrenToEnd(Set<PathElement> children) {
        List<Object> childrenForKey;
        LinkedHashSet<String> childKeys = new LinkedHashSet<String>();
        HashMap<String, ArrayList<PathElement>> childMap = new HashMap<String, ArrayList<PathElement>>();
        HashMap<String, PathElement> childWildcards = new HashMap<String, PathElement>();
        for (PathElement child : children) {
            String key = child.getKey();
            childKeys.add(key);
            if (child.isWildcard()) {
                childWildcards.putIfAbsent(key, child);
                continue;
            }
            childrenForKey = (ArrayList<PathElement>)childMap.get(key);
            if (childrenForKey == null) {
                childrenForKey = new ArrayList<PathElement>();
                childMap.put(key, (ArrayList<PathElement>)childrenForKey);
            }
            childrenForKey.add(child);
        }
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        for (String key : childKeys) {
            PathElement wildcardForKey;
            childrenForKey = (List)childMap.get(key);
            if (childrenForKey != null) {
                result.addAll((Collection<PathElement>)childrenForKey);
            }
            if ((wildcardForKey = (PathElement)childWildcards.get(key)) == null) continue;
            result.add(wildcardForKey);
        }
        return result;
    }
}

