/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.jboss.as.model.test.ChildFirstClassLoader;
import org.jboss.as.model.test.MavenUtil;
import org.jboss.logging.Logger;
import org.jboss.modules.filter.ClassFilter;
import org.xnio.IoUtils;

public class ChildFirstClassLoaderBuilder {
    private static final String STRICT_PROPERTY = "org.jboss.model.test.cache.strict";
    private static final String ROOT_PROPERTY = "org.jboss.model.test.cache.root";
    private static final String CACHE_FOLDER_PROPERTY = "org.jboss.model.test.classpath.cache";
    static final String MAVEN_REPOSITORY_URLS = "org.jboss.model.test.maven.repository.urls";
    private final MavenUtil mavenUtil;
    private final File cache;
    private final Set<URL> classloaderURLs = new LinkedHashSet<URL>();
    private final Set<Pattern> parentFirst = new LinkedHashSet<Pattern>();
    private final Set<Pattern> childFirst = new LinkedHashSet<Pattern>();
    private ClassFilter parentExclusionFilter;
    Map<URL, Set<String>> singleClassesByUrl = new HashMap<URL, Set<String>>();
    private static final Logger log = Logger.getLogger(ChildFirstClassLoaderBuilder.class);

    public ChildFirstClassLoaderBuilder(boolean useEapRepository) {
        this.mavenUtil = MavenUtil.create(useEapRepository);
        String root = System.getProperty(ROOT_PROPERTY);
        String cacheFolderName = System.getProperty(CACHE_FOLDER_PROPERTY);
        if (root == null && cacheFolderName == null) {
            if (System.getProperty(STRICT_PROPERTY) != null) {
                throw new IllegalStateException("Please use the org.jboss.model.test.cache.root and org.jboss.model.test.classpath.cache system properties to take advantage of cached classpaths");
            }
            this.cache = new File("target", "cached-classloader");
            this.cache.mkdirs();
            if (!this.cache.exists()) {
                throw new IllegalStateException("Could not create cache file");
            }
            log.info((Object)"To optimize this test use the org.jboss.model.test.cache.root and org.jboss.model.test.classpath.cache system properties to take advantage of cached classpaths");
        } else if (root != null && cacheFolderName != null) {
            String[] rootChildren;
            if (cacheFolderName.indexOf(47) != -1 && cacheFolderName.indexOf(92) != -1) {
                throw new IllegalStateException("Please use either '/' or '\\' as a file separator");
            }
            File file = new File(".").getAbsoluteFile();
            String[] stringArray = rootChildren = root.startsWith("[") && root.endsWith("]") ? root.substring(1, root.length() - 1).split(",") : null;
            if (rootChildren.length > 1) {
                for (int i = 0; i < rootChildren.length; ++i) {
                    if (rootChildren[i].indexOf("/") != -1 || rootChildren[i].indexOf("\\") != -1) {
                        throw new IllegalStateException("Children must be direct children");
                    }
                    rootChildren[i] = rootChildren[i].trim();
                }
            }
            while (file != null) {
                if (rootChildren == null) {
                    if (file.getName().equals(root)) {
                        break;
                    }
                } else {
                    boolean hasAllChildren = true;
                    for (String child : rootChildren) {
                        if (new File(file, child).exists()) continue;
                        hasAllChildren = false;
                        break;
                    }
                    if (hasAllChildren) break;
                }
                file = file.getParentFile();
            }
            if (file != null) {
                String separator = cacheFolderName.contains("/") ? "/" : "\\\\";
                for (String part : cacheFolderName.split(separator)) {
                    if ((file = new File(file, part)).exists()) {
                        if (file.isDirectory()) continue;
                        throw new IllegalStateException(file.getAbsolutePath() + " is not a directory");
                    }
                    if (file.mkdir() || file.exists()) continue;
                    throw new IllegalStateException(file.getAbsolutePath() + " could not be created");
                }
                this.cache = file;
            } else {
                if (System.getProperty(STRICT_PROPERTY) != null) {
                    throw new IllegalStateException("Could not find a parent file called '" + root + "'");
                }
                this.cache = new File("target", "cached-classloader");
                this.cache.mkdirs();
                if (!this.cache.exists()) {
                    throw new IllegalStateException("Could not create cache file");
                }
            }
        } else {
            throw new IllegalStateException("You must either set both org.jboss.model.test.cache.root and org.jboss.model.test.classpath.cache, or none of them");
        }
    }

    public ChildFirstClassLoaderBuilder addURL(URL url) {
        this.classloaderURLs.add(url);
        return this;
    }

    public ChildFirstClassLoaderBuilder addSimpleResourceURL(String resource) throws MalformedURLException {
        URL url = ChildFirstClassLoader.class.getResource(resource);
        if (url == null) {
            File file;
            ClassLoader cl = ChildFirstClassLoader.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            if ((url = cl.getResource(resource)) == null && (file = new File(resource)).exists()) {
                url = file.toURI().toURL();
            }
        }
        if (url == null) {
            throw new IllegalArgumentException("Could not find resource " + resource);
        }
        this.classloaderURLs.add(url);
        return this;
    }

    public ChildFirstClassLoaderBuilder addMavenResourceURL(String artifactGav) throws IOException, ClassNotFoundException {
        String name = "maven-" + this.escape(artifactGav);
        File file = new File(this.cache, name);
        if (file.exists()) {
            log.trace((Object)("Using cached maven url for " + artifactGav + " from " + file.getAbsolutePath()));
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            try {
                this.classloaderURLs.add((URL)in.readObject());
            }
            catch (Exception e) {
                log.warn((Object)("Error loading cached maven url for " + artifactGav + " from " + file.getAbsolutePath()));
                throw e;
            }
            finally {
                IoUtils.safeClose((Closeable)in);
            }
        }
        log.trace((Object)("No cached maven url for " + artifactGav + " found. " + file.getAbsolutePath() + " does not exist."));
        URL url = this.mavenUtil.createMavenGavURL(artifactGav);
        this.classloaderURLs.add(url);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            out.writeObject(url);
        }
        catch (Exception e) {
            log.warn((Object)("Error writing cached maven url for " + artifactGav + " to " + file.getAbsolutePath()));
            throw e;
        }
        finally {
            IoUtils.safeClose((Closeable)out);
        }
        return this;
    }

    public ChildFirstClassLoaderBuilder addRecursiveMavenResourceURL(String artifactGav, String ... excludes) throws DependencyCollectionException, DependencyResolutionException, IOException, ClassNotFoundException {
        String name = "maven-recursive-" + this.escape(artifactGav);
        File file = new File(this.cache, name);
        if (file.exists()) {
            log.trace((Object)("Using cached recursive maven urls for " + artifactGav + " from " + file.getAbsolutePath()));
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            try {
                this.classloaderURLs.addAll((List)in.readObject());
            }
            catch (Exception e) {
                log.warn((Object)("Error loading cached recursive maven urls for " + artifactGav + " from " + file.getAbsolutePath()));
                throw e;
            }
            finally {
                IoUtils.safeClose((Closeable)in);
            }
        }
        log.trace((Object)("No cached recursive maven urls for " + artifactGav + " found. " + file.getAbsolutePath() + " does not exist."));
        List<URL> urls = this.mavenUtil.createMavenGavRecursiveURLs(artifactGav, excludes);
        this.classloaderURLs.addAll(urls);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            out.writeObject(urls);
        }
        catch (Exception e) {
            log.warn((Object)("Error writing cached recursive maven urls for " + artifactGav + " to " + file.getAbsolutePath()));
            throw e;
        }
        finally {
            IoUtils.safeClose((Closeable)out);
        }
        return this;
    }

    public ChildFirstClassLoaderBuilder addParentFirstClassPattern(String pattern) {
        this.parentFirst.add(this.compilePattern(pattern));
        return this;
    }

    public ChildFirstClassLoaderBuilder addChildFirstClassPattern(String pattern) {
        this.childFirst.add(this.compilePattern(pattern));
        return this;
    }

    public ChildFirstClassLoaderBuilder excludeFromParent(ClassFilter filter) {
        this.parentExclusionFilter = filter;
        return this;
    }

    private String escape(String artifactGav) {
        return artifactGav.replaceAll(":", "-x-");
    }

    public URLClassLoader build() {
        for (Map.Entry<URL, Set<String>> entry : this.singleClassesByUrl.entrySet()) {
            if (this.classloaderURLs.contains(entry.getKey())) {
                throw new IllegalStateException("Url " + entry.getKey() + " which is the code source for the following classes has already been set up via other means: " + entry.getValue());
            }
            this.classloaderURLs.add(entry.getKey());
            HashSet<String> childFirstNames = new HashSet<String>();
            for (String clazz : entry.getValue()) {
                this.childFirst.add(this.compilePattern(clazz));
                childFirstNames.add(clazz);
            }
            try {
                File file = new File(entry.getKey().toURI());
                if (file.isDirectory()) {
                    this.addParentFirstPatternsFromDirectory(file, "", childFirstNames);
                    continue;
                }
                throw new IllegalStateException("Single class exclusions from jar files is not working: " + entry);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        ClassLoader parent = this.getClass().getClassLoader() != null ? this.getClass().getClassLoader() : null;
        return new ChildFirstClassLoader(parent, this.parentFirst, this.childFirst, this.parentExclusionFilter, this.classloaderURLs.toArray(new URL[this.classloaderURLs.size()]));
    }

    private void addParentFirstPatternsFromDirectory(File directory, String prefix, Set<String> childFirstClassNames) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.addParentFirstPatternsFromDirectory(file, prefix + file.getName() + ".", childFirstClassNames);
                continue;
            }
            String fileName = file.getName();
            if (!fileName.endsWith(".class")) continue;
            String className = prefix + file.getName().substring(0, fileName.length() - ".class".length());
            this.parentFirst.add(this.compilePattern(className));
        }
    }

    private Pattern compilePattern(String pattern) {
        return Pattern.compile(pattern.replace(".", "\\.").replace("*", ".*"));
    }

    public ChildFirstClassLoaderBuilder addSingleChildFirstClass(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
            Set<String> classSet = this.singleClassesByUrl.get(url);
            if (classSet == null) {
                classSet = new HashSet<String>();
                this.singleClassesByUrl.put(url, classSet);
            }
            classSet.add(clazz.getName());
        }
        return this;
    }
}

