/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.version.Stability;
import org.wildfly.legacy.version.LegacyVersions;

public enum ModelTestControllerVersion {
    MASTER(CurrentVersion.VERSION, false, null, "master"),
    EAP_7_4_0("7.4.0.GA-redhat-00005", true, "23.0.0", "15.0.2.Final-redhat-00001", "7.4.0"),
    EAP_8_0_0("8.0.0.GA-redhat-00011", true, "29.0.0", "21.0.5.Final-redhat-00001", "8.0.0"),
    EAP_8_1_0("35.0.1.Final", false, "35.0.0", "27.0.1.Final", "wf35"),
    EAP_XP_4("4.0.0.GA-redhat-00003", true, "23.0.0", "15.0.26.Final-redhat-00001", "xp4"),
    EAP_XP_5("5.0.0.GA-redhat-00005", true, "29.0.0", "21.0.5.Final-redhat-00001", "xp5"),
    WILDFLY_31_0_0("31.0.0.Final", false, "31.0.0", "23.0.1.Final", "wf31");

    private final String mavenGavVersion;
    private final String testControllerVersion;
    private final boolean eap;
    private final boolean validLegacyController;
    private final String coreVersion;
    private final String mavenGroupId;
    private final String coreMavenGroupId;
    private final String serverMavenArtifactId;
    private final String hostControllerMavenArtifactId;
    private final String realVersionName;
    private final String artifactIdPrefix;
    private final Map<String, ModelVersion> subsystemModelVersions = new LinkedHashMap<String, ModelVersion>();
    private final Stability stability;
    private final boolean ignored;

    private ModelTestControllerVersion(String mavenGavVersion, boolean eap, String testControllerVersion, String realVersionName) {
        this(mavenGavVersion, eap, testControllerVersion, null, realVersionName);
    }

    private ModelTestControllerVersion(String mavenGavVersion, boolean eap, String testControllerVersion, String coreVersion, String realVersionName) {
        this(mavenGavVersion, eap, testControllerVersion, coreVersion, realVersionName, false);
    }

    private ModelTestControllerVersion(String mavenGavVersion, boolean eap, String testControllerVersion, String coreVersion, String realVersionName, boolean ignored) {
        this.mavenGavVersion = mavenGavVersion;
        this.testControllerVersion = testControllerVersion;
        this.eap = eap;
        this.stability = eap ? Stability.DEFAULT : Stability.COMMUNITY;
        this.validLegacyController = testControllerVersion != null;
        this.coreVersion = coreVersion == null ? mavenGavVersion : coreVersion;
        this.realVersionName = realVersionName;
        this.ignored = ignored;
        if (eap) {
            if (coreVersion != null) {
                this.coreMavenGroupId = "org.wildfly.core";
                this.mavenGroupId = "org.jboss.eap";
                this.serverMavenArtifactId = "wildfly-server";
                this.hostControllerMavenArtifactId = "wildfly-host-controller";
                this.artifactIdPrefix = "wildfly-";
            } else {
                this.mavenGroupId = "org.jboss.as";
                this.coreMavenGroupId = "org.jboss.as";
                this.serverMavenArtifactId = "jboss-as-server";
                this.hostControllerMavenArtifactId = "jboss-as-host-controller";
                this.artifactIdPrefix = "jboss-as-";
            }
        } else {
            this.coreMavenGroupId = "org.wildfly.core";
            this.mavenGroupId = "org.wildfly";
            this.serverMavenArtifactId = "wildfly-server";
            this.hostControllerMavenArtifactId = "wildfly-host-controller";
            this.artifactIdPrefix = "wildfly-";
        }
    }

    public String getMavenGavVersion() {
        return this.mavenGavVersion;
    }

    public String getTestControllerVersion() {
        return this.testControllerVersion;
    }

    public boolean isEap() {
        return this.eap;
    }

    public boolean hasValidLegacyController() {
        return this.validLegacyController;
    }

    public String getCoreVersion() {
        return this.coreVersion;
    }

    public String getMavenGroupId() {
        return this.mavenGroupId;
    }

    public String getCoreMavenGroupId() {
        return this.coreMavenGroupId;
    }

    public String getServerMavenArtifactId() {
        return this.serverMavenArtifactId;
    }

    public String getHostControllerMavenArtifactId() {
        return this.hostControllerMavenArtifactId;
    }

    public String getRealVersionName() {
        return this.realVersionName;
    }

    @Deprecated(forRemoval=true)
    public String getArtifactIdPrefix() {
        return this.artifactIdPrefix;
    }

    public ModelVersion getSubsystemModelVersion(String subsystemName) {
        return this.getSubsystemModelVersions().get(subsystemName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ModelVersion> getSubsystemModelVersions() {
        if (this.subsystemModelVersions.isEmpty()) {
            Map<String, ModelVersion> map = this.subsystemModelVersions;
            synchronized (map) {
                this.subsystemModelVersions.putAll(LegacyVersions.getModelVersions((String)this.realVersionName));
            }
        }
        return this.subsystemModelVersions;
    }

    public String createGAV(String artifactId) {
        return String.format("%s:%s:%s", this.getMavenGroupId(), artifactId, this.getMavenGavVersion());
    }

    public String createCoreGAV(String artifactId) {
        return String.format("%s:%s:%s", this.getCoreMavenGroupId(), artifactId, this.getCoreVersion());
    }

    @Deprecated(forRemoval=true)
    public String getMavenGav(String artifactIdPart, boolean coreArtifact) {
        return String.format("%s:%s%s:%s", coreArtifact ? this.getCoreMavenGroupId() : this.getMavenGroupId(), this.getArtifactIdPrefix(), artifactIdPart, coreArtifact ? this.getCoreVersion() : this.getMavenGavVersion());
    }

    public Stability getStability() {
        return this.stability;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public static interface CurrentVersion {
        public static final String VERSION = VersionLocator.VERSION;
    }

    static final class VersionLocator {
        private static String VERSION;

        VersionLocator() {
        }

        static String getCurrentVersion() {
            return VERSION;
        }

        static {
            try {
                Properties props = new Properties();
                props.load(ModelTestControllerVersion.class.getResourceAsStream("version.properties"));
                VERSION = props.getProperty("as.version");
            }
            catch (Exception e) {
                VERSION = "10.0.0.Alpha5-SNAPSHOT";
                e.printStackTrace();
            }
        }
    }
}

