/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.controller.ModelVersion;
import org.wildfly.legacy.version.LegacyVersions;

public enum ModelTestControllerVersion {
    MASTER(CurrentVersion.VERSION, false, null, "master"),
    EAP_7_4_0("7.4.0.GA-redhat-00005", true, "23.0.0", "15.0.2.Final-redhat-00001", "7.4.0"),
    EAP_XP_4("26.0.0.Beta1", false, "25.0.0", "18.0.0.Final", "wf26");

    private final String mavenGavVersion;
    private final String testControllerVersion;
    private final boolean eap;
    private final boolean validLegacyController;
    private final String coreVersion;
    private final String mavenGroupId;
    private final String coreMavenGroupId;
    private final String serverMavenArtifactId;
    private final String hostControllerMavenArtifactId;
    private final String realVersionName;
    private final String artifactIdPrefix;
    private final Map<String, ModelVersion> subsystemModelVersions = new LinkedHashMap<String, ModelVersion>();

    private ModelTestControllerVersion(String mavenGavVersion, boolean eap, String testControllerVersion, String realVersionName) {
        this(mavenGavVersion, eap, testControllerVersion, null, realVersionName);
    }

    private ModelTestControllerVersion(String mavenGavVersion, boolean eap, String testControllerVersion, String coreVersion, String realVersionName) {
        this.mavenGavVersion = mavenGavVersion;
        this.testControllerVersion = testControllerVersion;
        this.eap = eap;
        this.validLegacyController = testControllerVersion != null;
        this.coreVersion = coreVersion == null ? mavenGavVersion : coreVersion;
        this.realVersionName = realVersionName;
        if (eap) {
            if (coreVersion != null) {
                this.coreMavenGroupId = "org.wildfly.core";
                this.mavenGroupId = "org.jboss.eap";
                this.serverMavenArtifactId = "wildfly-server";
                this.hostControllerMavenArtifactId = "wildfly-host-controller";
                this.artifactIdPrefix = "wildfly-";
            } else {
                this.mavenGroupId = "org.jboss.as";
                this.coreMavenGroupId = "org.jboss.as";
                this.serverMavenArtifactId = "jboss-as-server";
                this.hostControllerMavenArtifactId = "jboss-as-host-controller";
                this.artifactIdPrefix = "jboss-as-";
            }
        } else {
            this.coreMavenGroupId = "org.wildfly.core";
            this.mavenGroupId = "org.wildfly";
            this.serverMavenArtifactId = "wildfly-server";
            this.hostControllerMavenArtifactId = "wildfly-host-controller";
            this.artifactIdPrefix = "wildfly-";
        }
    }

    public String getMavenGavVersion() {
        return this.mavenGavVersion;
    }

    public String getTestControllerVersion() {
        return this.testControllerVersion;
    }

    public boolean isEap() {
        return this.eap;
    }

    public boolean hasValidLegacyController() {
        return this.validLegacyController;
    }

    public String getCoreVersion() {
        return this.coreVersion;
    }

    public String getMavenGroupId() {
        return this.mavenGroupId;
    }

    public String getCoreMavenGroupId() {
        return this.coreMavenGroupId;
    }

    public String getServerMavenArtifactId() {
        return this.serverMavenArtifactId;
    }

    public String getHostControllerMavenArtifactId() {
        return this.hostControllerMavenArtifactId;
    }

    public String getRealVersionName() {
        return this.realVersionName;
    }

    public String getArtifactIdPrefix() {
        return this.artifactIdPrefix;
    }

    public ModelVersion getSubsystemModelVersion(String subsystemName) {
        return this.getSubsystemModelVersions().get(subsystemName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ModelVersion> getSubsystemModelVersions() {
        if (this.subsystemModelVersions.isEmpty()) {
            Map<String, ModelVersion> map = this.subsystemModelVersions;
            synchronized (map) {
                this.subsystemModelVersions.putAll(LegacyVersions.getModelVersions((String)this.realVersionName));
            }
        }
        return this.subsystemModelVersions;
    }

    public String getMavenGav(String artifactIdPart, boolean coreArtifact) {
        return String.format("%s:%s%s:%s", coreArtifact ? this.getCoreMavenGroupId() : this.getMavenGroupId(), this.getArtifactIdPrefix(), artifactIdPart, this.getMavenGavVersion());
    }

    static final class VersionLocator {
        private static String VERSION;

        VersionLocator() {
        }

        static String getCurrentVersion() {
            return VERSION;
        }

        static {
            try {
                Properties props = new Properties();
                props.load(ModelTestControllerVersion.class.getResourceAsStream("version.properties"));
                VERSION = props.getProperty("as.version");
            }
            catch (Exception e) {
                VERSION = "10.0.0.Alpha5-SNAPSHOT";
                e.printStackTrace();
            }
        }
    }

    public static interface CurrentVersion {
        public static final String VERSION = VersionLocator.VERSION;
    }
}

