/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceFilter;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LoggingResource
implements Resource {
    private static final List<String> FILE_RESOURCE_NAMES = Arrays.asList("file-handler", "periodic-rotating-file-handler", "periodic-size-rotating-file-handler", "size-rotating-file-handler");
    private final PathManager pathManager;
    private final Resource delegate;
    private final ModelNode fileHandlersModel;

    public LoggingResource(PathManager pathManager) {
        this(Resource.Factory.create(), pathManager);
    }

    public LoggingResource(Resource delegate, PathManager pathManager) {
        this(delegate, pathManager, null);
    }

    private LoggingResource(Resource delegate, PathManager pathManager, ModelNode fileHandlersModel) {
        assert (pathManager != null) : "PathManager cannot be null";
        this.delegate = delegate;
        this.pathManager = pathManager;
        this.fileHandlersModel = fileHandlersModel;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("log-file".equals(element.getKey())) {
            return this.hasReadableFile(element.getValue());
        }
        return this.delegate.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("log-file".equals(element.getKey())) {
            if (this.hasReadableFile(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
            return null;
        }
        return this.delegate.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("log-file".equals(element.getKey())) {
            if (this.hasReadableFile(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
            throw new Resource.NoSuchResourceException(element);
        }
        return this.delegate.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("log-file".equals(childType)) {
            String logDir = this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath();
            if (logDir != null) {
                final Path dir = Paths.get(logDir, new String[0]);
                Collection<String> validFileNames = LoggingResource.findValidFileNames(this.getFileHandlersModel());
                for (final String name : validFileNames) {
                    Path file = dir.resolve(name);
                    if (Files.exists(file, new LinkOption[0]) && Files.isReadable(file)) {
                        return true;
                    }
                    final AtomicBoolean found = new AtomicBoolean(false);
                    try {
                        Files.walkFileTree(dir, Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Path relativeFile = dir.relativize(file);
                                String resourceName = relativeFile.toString();
                                if ((resourceName.equals(name) || resourceName.startsWith(name)) && Files.isReadable(file)) {
                                    found.set(true);
                                    return FileVisitResult.TERMINATE;
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        if (!found.get()) continue;
                        return true;
                    }
                    catch (IOException e) {
                        LoggingLogger.ROOT_LOGGER.errorDeterminingChildrenExist(e, childType);
                    }
                }
            }
            return false;
        }
        return this.delegate.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "log-file".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new Resource.NoSuchResourceException(address.getElement(1));
            }
            return PlaceholderResource.INSTANCE;
        }
        return this.delegate.navigate(address);
    }

    public Set<String> getChildTypes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.delegate.getChildTypes());
        result.add("log-file");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("log-file".equals(childType)) {
            String logDir = this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath();
            try {
                Set<Path> validPaths = LoggingResource.findFiles(logDir, this.getFileHandlersModel(), true);
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (Path p : validPaths) {
                    result.add(p.toString());
                }
                return result;
            }
            catch (IOException e) {
                LoggingLogger.ROOT_LOGGER.errorProcessingLogDirectory(logDir);
            }
        }
        return this.delegate.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("log-file".equals(childType)) {
            Set<String> names = this.getChildrenNames(childType);
            LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>(names.size());
            for (String name : names) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("log-file", name));
            }
            return result;
        }
        return this.delegate.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        String type = address.getKey();
        if ("log-file".equals(type)) {
            throw LoggingLogger.ROOT_LOGGER.cannotRegisterResourceOfType(type);
        }
        this.delegate.registerChild(address, resource);
    }

    public void registerChild(PathElement address, int index, Resource resource) {
        String type = address.getKey();
        if ("log-file".equals(type)) {
            throw LoggingLogger.ROOT_LOGGER.cannotRegisterResourceOfType(type);
        }
        this.delegate.registerChild(address, index, resource);
    }

    public Resource removeChild(PathElement address) {
        String type = address.getKey();
        if ("log-file".equals(type)) {
            throw LoggingLogger.ROOT_LOGGER.cannotRemoveResourceOfType(type);
        }
        return this.delegate.removeChild(address);
    }

    public boolean isRuntime() {
        return this.delegate.isRuntime();
    }

    public boolean isProxy() {
        return this.delegate.isProxy();
    }

    public Set<String> getOrderedChildTypes() {
        return Collections.emptySet();
    }

    public Resource clone() {
        return new LoggingResource(this.delegate.clone(), this.pathManager, this.fileHandlersModel);
    }

    public Resource shallowCopy() {
        ModelNode fileHdlrsModel = this.getFileHandlersModel();
        return new LoggingResource(this.delegate.shallowCopy(), this.pathManager, fileHdlrsModel);
    }

    private boolean hasReadableFile(String fileName) {
        String logDir = this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath();
        if (logDir != null) {
            Path dir = Paths.get(logDir, new String[0]);
            Collection<String> validFileNames = LoggingResource.findValidFileNames(this.getFileHandlersModel());
            for (String name : validFileNames) {
                if (!fileName.equals(name) && !fileName.startsWith(name)) continue;
                Path file = dir.resolve(fileName);
                return Files.exists(file, new LinkOption[0]) && Files.isReadable(file);
            }
        }
        return false;
    }

    private ModelNode getFileHandlersModel() {
        return this.fileHandlersModel == null ? Resource.Tools.readModel((Resource)this.delegate, (int)-1, (ResourceFilter)FileHandlerResourceFilter.INSTANCE) : this.fileHandlersModel;
    }

    static Set<Path> findFiles(String logDir, ModelNode model, final boolean relativize) throws IOException {
        if (logDir == null) {
            return Collections.emptySet();
        }
        final Collection<String> validFileNames = LoggingResource.findValidFileNames(model);
        final TreeSet<Path> logFiles = new TreeSet<Path>();
        final Path dir = Paths.get(logDir, new String[0]);
        Files.walkFileTree(dir, Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            boolean first = true;

            @Override
            public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
                if (this.first || relativize) {
                    this.first = false;
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (Files.isReadable(file)) {
                    throw exc;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relativeFile = dir.relativize(file);
                String resourceName = relativeFile.toString();
                for (String name : validFileNames) {
                    if (!resourceName.equals(name) && !resourceName.startsWith(name) || !Files.isReadable(file)) continue;
                    if (relativize) {
                        logFiles.add(relativeFile);
                        continue;
                    }
                    logFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return logFiles;
    }

    private static Collection<String> findValidFileNames(ModelNode model) {
        ArrayList<String> names = new ArrayList<String>();
        LinkedHashSet<String> unresolvableExpressions = new LinkedHashSet<String>();
        for (Property resource : model.asPropertyList()) {
            String name = resource.getName();
            if (!FILE_RESOURCE_NAMES.contains(name)) continue;
            for (Property handlerResource : resource.getValue().asPropertyList()) {
                ModelNode path;
                ModelNode fileModel;
                ModelNode handlerModel = handlerResource.getValue();
                if (!handlerModel.hasDefined(CommonAttributes.FILE.getName()) || !(fileModel = handlerModel.get(CommonAttributes.FILE.getName())).hasDefined(PathResourceDefinition.RELATIVE_TO.getName()) || !"jboss.server.log.dir".equals(fileModel.get(PathResourceDefinition.RELATIVE_TO.getName()).asString()) || !fileModel.hasDefined(PathResourceDefinition.PATH.getName())) continue;
                try {
                    path = ExpressionResolver.SIMPLE.resolveExpressions(fileModel.get(PathResourceDefinition.PATH.getName()));
                }
                catch (OperationFailedException e) {
                    unresolvableExpressions.add(fileModel.get(PathResourceDefinition.PATH.getName()).asString());
                    continue;
                }
                names.add(path.asString());
            }
        }
        if (!unresolvableExpressions.isEmpty()) {
            LoggingLogger.ROOT_LOGGER.unresolvablePathExpressions(unresolvableExpressions);
        }
        return names;
    }

    private static class FileHandlerResourceFilter
    implements ResourceFilter {
        static final FileHandlerResourceFilter INSTANCE = new FileHandlerResourceFilter();

        private FileHandlerResourceFilter() {
        }

        public boolean accepts(PathAddress address, Resource resource) {
            PathElement last = address.getLastElement();
            return last == null || FILE_RESOURCE_NAMES.contains(last.getKey());
        }
    }
}

