/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments.resources;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.server.deployment.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

abstract class LoggingConfigurationReadStepHandler
implements OperationStepHandler {
    LoggingConfigurationReadStepHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        LogContextConfiguration configuration = null;
        ServiceController controller = context.getServiceRegistry(false).getService(LoggingConfigurationReadStepHandler.getServiceName(context));
        if (controller != null) {
            configuration = (LogContextConfiguration)controller.getValue();
        }
        if (configuration != null) {
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            String name = context.getCurrentAddressValue();
            ModelNode result = context.getResult();
            this.updateModel(configuration, name, result);
        }
    }

    protected abstract void updateModel(LogContextConfiguration var1, String var2, ModelNode var3);

    static void addProperties(PropertyConfigurable configuration, ModelNode model) {
        configuration.getPropertyNames().forEach(name -> LoggingConfigurationReadStepHandler.setModelValue(model.get(name), configuration.getPropertyValueString(name)));
    }

    static void setModelValue(ModelNode model, String value) {
        if (value != null) {
            model.set(value);
        }
    }

    static void setModelValue(ModelNode model, Boolean value) {
        if (value != null) {
            model.set(value.booleanValue());
        }
    }

    private static ServiceName getServiceName(OperationContext context) {
        String deploymentName = null;
        String subdeploymentName = null;
        PathAddress address = context.getCurrentAddress();
        for (PathElement element : address) {
            if ("deployment".equals(element.getKey())) {
                deploymentName = LoggingConfigurationReadStepHandler.getRuntimeName(context, element);
                continue;
            }
            if (!"subdeployment".endsWith(element.getKey())) continue;
            subdeploymentName = element.getValue();
        }
        if (deploymentName == null) {
            throw LoggingLogger.ROOT_LOGGER.deploymentNameNotFound(address);
        }
        ServiceName result = subdeploymentName == null ? Services.deploymentUnitName(deploymentName) : Services.deploymentUnitName(deploymentName, subdeploymentName);
        return result.append(new String[]{"logging", "configuration"});
    }

    private static String getRuntimeName(OperationContext context, PathElement element) {
        ModelNode deploymentModel = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{element}), false).getModel();
        if (!deploymentModel.hasDefined("runtime-name")) {
            throw LoggingLogger.ROOT_LOGGER.deploymentNameNotFound(context.getCurrentAddress());
        }
        return deploymentModel.get("runtime-name").asString();
    }
}

