/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathInfoHandler;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.CustomFormatterResourceDefinition;
import org.jboss.as.logging.CustomHandlerResourceDefinition;
import org.jboss.as.logging.FileHandlerResourceDefinition;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LogFileResourceDefinition;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.LoggingProfileOperations;
import org.jboss.as.logging.LoggingResourceDefinition;
import org.jboss.as.logging.LoggingSubsystemParser_1_0;
import org.jboss.as.logging.LoggingSubsystemParser_1_1;
import org.jboss.as.logging.LoggingSubsystemParser_1_2;
import org.jboss.as.logging.LoggingSubsystemParser_1_3;
import org.jboss.as.logging.LoggingSubsystemParser_1_4;
import org.jboss.as.logging.LoggingSubsystemParser_1_5;
import org.jboss.as.logging.LoggingSubsystemParser_2_0;
import org.jboss.as.logging.LoggingSubsystemParser_3_0;
import org.jboss.as.logging.LoggingSubsystemWriter;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.PeriodicSizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.RootLoggerResourceDefinition;
import org.jboss.as.logging.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.SyslogHandlerResourceDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.deployments.resources.LoggingDeploymentResources;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.logmanager.WildFlyLogContextSelector;
import org.jboss.as.logging.stdio.LogContextStdioContextSelector;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.LogManager;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LoggingExtension
implements Extension {
    private static final String RESOURCE_NAME = LoggingExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final String SKIP_LOG_MANAGER_PROPERTY = "org.wildfly.logging.skipLogManagerCheck";
    public static final String SUBSYSTEM_NAME = "logging";
    static final PathElement LOGGING_PROFILE_PATH = PathElement.pathElement((String)"logging-profile");
    static final GenericSubsystemDescribeHandler DESCRIBE_HANDLER = GenericSubsystemDescribeHandler.create((Comparator)LoggingChildResourceComparator.INSTANCE);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 3;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ModelVersion CURRENT_VERSION = ModelVersion.create((int)3, (int)0, (int)0);
    private static final ModuleIdentifier[] LOGGING_API_MODULES = new ModuleIdentifier[]{ModuleIdentifier.create((String)"org.apache.commons.logging"), ModuleIdentifier.create((String)"org.apache.log4j"), ModuleIdentifier.create((String)"org.jboss.logging"), ModuleIdentifier.create((String)"org.jboss.logging.jul-to-slf4j-stub"), ModuleIdentifier.create((String)"org.jboss.logmanager"), ModuleIdentifier.create((String)"org.slf4j"), ModuleIdentifier.create((String)"org.slf4j.ext"), ModuleIdentifier.create((String)"org.slf4j.impl")};
    private static final List<String> DELEGATE_DESC_OPTS = Arrays.asList("update-properties", "set-root-logger");

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, LoggingExtension.class.getClassLoader(), true, false){

            public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
                if (DELEGATE_DESC_OPTS.contains(operationName)) {
                    return this.getResourceAttributeDescription(paramName, locale, bundle);
                }
                return super.getOperationParameterDescription(operationName, paramName, locale, bundle);
            }

            public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
                if (DELEGATE_DESC_OPTS.contains(operationName)) {
                    return this.getResourceAttributeDescription(paramName, locale, bundle);
                }
                return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle, suffixes);
            }

            public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
                if (DELEGATE_DESC_OPTS.contains(operationName)) {
                    return this.getResourceAttributeDeprecatedDescription(paramName, locale, bundle);
                }
                return super.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle);
            }
        };
    }

    public void initialize(ExtensionContext context) {
        if (LoggingExtension.getBooleanProperty(SKIP_LOG_MANAGER_PROPERTY)) {
            LoggingLogger.ROOT_LOGGER.debugf("System property %s was set to true. Skipping the log manager check.", SKIP_LOG_MANAGER_PROPERTY);
            String logManagerName = WildFlySecurityManager.getPropertyPrivileged((String)"java.util.logging.manager", null);
            if (!LogManager.class.getName().equals(logManagerName)) {
                LoggingLogger.ROOT_LOGGER.unknownLogManager(logManagerName);
            }
        } else if (!java.util.logging.LogManager.getLogManager().getClass().getName().equals(LogManager.class.getName())) {
            throw LoggingLogger.ROOT_LOGGER.extensionNotInitialized();
        }
        WildFlyLogContextSelector contextSelector = WildFlyLogContextSelector.Factory.create();
        LogContext.setLogContextSelector((LogContextSelector)contextSelector);
        StdioContext.setStdioContextSelector((StdioContextSelector)new LogContextStdioContextSelector(StdioContext.getStdioContext()));
        try {
            ModuleLoader moduleLoader = Module.forClass(LoggingExtension.class).getModuleLoader();
            for (ModuleIdentifier moduleIdentifier : LOGGING_API_MODULES) {
                try {
                    contextSelector.addLogApiClassLoader((ClassLoader)moduleLoader.loadModule(moduleIdentifier).getClassLoader());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Exception moduleLoader) {
            // empty catch block
        }
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_VERSION);
        PathManager pathManager = null;
        if (context.getProcessType().isServer()) {
            pathManager = context.getPathManager();
        }
        LoggingResourceDefinition rootResource = new LoggingResourceDefinition(pathManager, contextSelector);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)rootResource);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)DESCRIBE_HANDLER);
        this.registerSubModels(registration, true, subsystem, rootResource, context.isRegisterTransformers(), pathManager);
        ApplicationTypeConfig atc = new ApplicationTypeConfig(SUBSYSTEM_NAME, "logging-profile");
        SimpleResourceDefinition profile = new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(LOGGING_PROFILE_PATH, LoggingExtension.getResourceDescriptionResolver(new String[0])).setAddHandler((OperationStepHandler)new LoggingProfileOperations.LoggingProfileAdd(pathManager)).setRemoveHandler(LoggingProfileOperations.REMOVE_PROFILE).setAccessConstraints(new AccessConstraintDefinition[]{new ApplicationTypeAccessConstraintDefinition(atc)}));
        this.registerLoggingProfileSubModels(registration.registerSubModel((ResourceDefinition)profile), pathManager);
        if (context.isRuntimeOnlyRegistrationValid()) {
            SimpleResourceDefinition deploymentSubsystem = new SimpleResourceDefinition(LoggingResourceDefinition.SUBSYSTEM_PATH, LoggingExtension.getResourceDescriptionResolver("deployment"));
            ManagementResourceRegistration deployments = subsystem.registerDeploymentModel((ResourceDefinition)deploymentSubsystem);
            ManagementResourceRegistration configurationResource = deployments.registerSubModel((ResourceDefinition)LoggingDeploymentResources.CONFIGURATION);
            configurationResource.registerSubModel((ResourceDefinition)LoggingDeploymentResources.HANDLER);
            configurationResource.registerSubModel((ResourceDefinition)LoggingDeploymentResources.LOGGER);
            configurationResource.registerSubModel((ResourceDefinition)LoggingDeploymentResources.FORMATTER);
            configurationResource.registerSubModel((ResourceDefinition)LoggingDeploymentResources.FILTER);
            configurationResource.registerSubModel((ResourceDefinition)LoggingDeploymentResources.POJO);
            configurationResource.registerSubModel((ResourceDefinition)LoggingDeploymentResources.ERROR_MANAGER);
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)LoggingSubsystemWriter.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        LoggingExtension.setParser(context, Namespace.LOGGING_1_0, new LoggingSubsystemParser_1_0());
        LoggingExtension.setParser(context, Namespace.LOGGING_1_1, new LoggingSubsystemParser_1_1());
        LoggingExtension.setParser(context, Namespace.LOGGING_1_2, new LoggingSubsystemParser_1_2());
        LoggingExtension.setParser(context, Namespace.LOGGING_1_3, new LoggingSubsystemParser_1_3());
        LoggingExtension.setParser(context, Namespace.LOGGING_1_4, new LoggingSubsystemParser_1_4());
        LoggingExtension.setParser(context, Namespace.LOGGING_1_5, new LoggingSubsystemParser_1_5());
        LoggingExtension.setParser(context, Namespace.LOGGING_2_0, new LoggingSubsystemParser_2_0());
        LoggingExtension.setParser(context, Namespace.LOGGING_3_0, new LoggingSubsystemParser_3_0());
    }

    private void registerLoggingProfileSubModels(ManagementResourceRegistration registration, PathManager pathManager) {
        this.registerSubModels(registration, false, null, null, false, pathManager);
    }

    private void registerSubModels(ManagementResourceRegistration registration, boolean includeLegacyAttributes, SubsystemRegistration subsystem, LoggingResourceDefinition subsystemResourceDefinition, boolean registerTransformers, PathManager pathManager) {
        ResolvePathHandler resolvePathHandler = null;
        PathInfoHandler diskUsagePathHandler = null;
        if (pathManager != null) {
            resolvePathHandler = ResolvePathHandler.Builder.of((PathManager)pathManager).setParentAttribute((AttributeDefinition)CommonAttributes.FILE).build();
            diskUsagePathHandler = PathInfoHandler.Builder.of((PathManager)pathManager).setParentAttribute((AttributeDefinition)CommonAttributes.FILE).addAttribute((AttributeDefinition)PathResourceDefinition.PATH, (AttributeDefinition)PathResourceDefinition.RELATIVE_TO).build();
            LogFileResourceDefinition logFileResourceDefinition = new LogFileResourceDefinition(pathManager);
            registration.registerSubModel((ResourceDefinition)logFileResourceDefinition);
        }
        RootLoggerResourceDefinition rootLoggerResourceDefinition = new RootLoggerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)rootLoggerResourceDefinition);
        LoggerResourceDefinition loggerResourceDefinition = new LoggerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)loggerResourceDefinition);
        AsyncHandlerResourceDefinition asyncHandlerResourceDefinition = new AsyncHandlerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)asyncHandlerResourceDefinition);
        ConsoleHandlerResourceDefinition consoleHandlerResourceDefinition = new ConsoleHandlerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)consoleHandlerResourceDefinition);
        FileHandlerResourceDefinition fileHandlerResourceDefinition = new FileHandlerResourceDefinition(resolvePathHandler, diskUsagePathHandler, includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)fileHandlerResourceDefinition);
        PeriodicHandlerResourceDefinition periodicHandlerResourceDefinition = new PeriodicHandlerResourceDefinition(resolvePathHandler, diskUsagePathHandler, includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)periodicHandlerResourceDefinition);
        PeriodicSizeRotatingHandlerResourceDefinition periodicSizeRotatingHandlerResourceDefinition = new PeriodicSizeRotatingHandlerResourceDefinition(resolvePathHandler, diskUsagePathHandler);
        registration.registerSubModel((ResourceDefinition)periodicSizeRotatingHandlerResourceDefinition);
        SizeRotatingHandlerResourceDefinition sizeRotatingHandlerResourceDefinition = new SizeRotatingHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)sizeRotatingHandlerResourceDefinition);
        CustomHandlerResourceDefinition customHandlerResourceDefinition = new CustomHandlerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)customHandlerResourceDefinition);
        registration.registerSubModel((ResourceDefinition)SyslogHandlerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)PatternFormatterResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)CustomFormatterResourceDefinition.INSTANCE);
        if (registerTransformers) {
            this.registerTransformers(subsystem, subsystemResourceDefinition, rootLoggerResourceDefinition, loggerResourceDefinition, asyncHandlerResourceDefinition, consoleHandlerResourceDefinition, fileHandlerResourceDefinition, periodicHandlerResourceDefinition, periodicSizeRotatingHandlerResourceDefinition, sizeRotatingHandlerResourceDefinition, customHandlerResourceDefinition, SyslogHandlerResourceDefinition.INSTANCE, PatternFormatterResourceDefinition.INSTANCE, CustomFormatterResourceDefinition.INSTANCE);
        }
    }

    private void registerTransformers(SubsystemRegistration registration, TransformerResourceDefinition ... defs) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getSubsystemVersion());
        this.registerTransformers(chainedBuilder, registration.getSubsystemVersion(), KnownModelVersion.VERSION_2_0_0, defs);
        this.registerTransformers(chainedBuilder, registration.getSubsystemVersion(), KnownModelVersion.VERSION_1_5_0, defs);
        this.registerTransformers(chainedBuilder, KnownModelVersion.VERSION_1_5_0, KnownModelVersion.VERSION_1_4_0, defs);
        this.registerTransformers(chainedBuilder, KnownModelVersion.VERSION_1_4_0, KnownModelVersion.VERSION_1_3_0, defs);
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{KnownModelVersion.VERSION_2_0_0.getModelVersion()}, {KnownModelVersion.VERSION_1_3_0.getModelVersion(), KnownModelVersion.VERSION_1_4_0.getModelVersion(), KnownModelVersion.VERSION_1_5_0.getModelVersion()}});
    }

    private void registerTransformers(ChainedTransformationDescriptionBuilder chainedBuilder, KnownModelVersion fromVersion, KnownModelVersion toVersion, TransformerResourceDefinition ... defs) {
        this.registerTransformers(chainedBuilder, fromVersion.getModelVersion(), toVersion, defs);
    }

    private void registerTransformers(ChainedTransformationDescriptionBuilder chainedBuilder, ModelVersion fromVersion, KnownModelVersion toVersion, TransformerResourceDefinition ... defs) {
        ResourceTransformationDescriptionBuilder subsystemBuilder = chainedBuilder.createBuilder(fromVersion, toVersion.getModelVersion());
        ResourceTransformationDescriptionBuilder loggingProfileBuilder = subsystemBuilder.addChildResource(LOGGING_PROFILE_PATH);
        for (TransformerResourceDefinition def : defs) {
            def.registerTransformers(toVersion, subsystemBuilder, loggingProfileBuilder);
        }
    }

    private static void setParser(ExtensionParsingContext context, Namespace namespace, XMLElementReader<List<ModelNode>> parser) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUriString(), parser);
    }

    private static boolean getBooleanProperty(final String property) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean(property);
                }
            });
        }
        return Boolean.getBoolean(property);
    }

    public static class LoggingChildResourceComparator
    implements Comparator<PathElement> {
        static final LoggingChildResourceComparator INSTANCE = new LoggingChildResourceComparator();
        static final int GREATER = 1;
        static final int EQUAL = 0;
        static final int LESS = -1;

        @Override
        public int compare(PathElement o1, PathElement o2) {
            String key2;
            String key1 = o1.getKey();
            int result = key1.compareTo(key2 = o2.getKey());
            if (result != 0) {
                if ("subsystem".equals(key1)) {
                    result = -1;
                } else if ("subsystem".equals(key2)) {
                    result = 1;
                } else if ("logging-profile".equals(key1)) {
                    result = -1;
                } else if ("logging-profile".equals(key2)) {
                    result = 1;
                } else if (PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName().equals(key1)) {
                    result = -1;
                } else if (PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName().equals(key2)) {
                    result = 1;
                } else if (CustomFormatterResourceDefinition.CUSTOM_FORMATTER.getName().equals(key1)) {
                    result = -1;
                } else if (CustomFormatterResourceDefinition.CUSTOM_FORMATTER.getName().equals(key2)) {
                    result = 1;
                } else if ("root-logger".equals(key1)) {
                    result = 1;
                } else if ("root-logger".equals(key2)) {
                    result = -1;
                } else if ("logger".equals(key1)) {
                    result = 1;
                } else if ("logger".equals(key2)) {
                    result = -1;
                } else if ("async-handler".equals(key1)) {
                    result = 1;
                } else if ("async-handler".equals(key2)) {
                    result = -1;
                }
            }
            return result;
        }
    }
}

