/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class LoggingCleanupDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final AttachmentKey<Set<AutoCloseable>> RESOURCES_TO_CLOSE = AttachmentKey.create(Set.class);

    public void deploy(DeploymentPhaseContext phaseContext) {
    }

    public void undeploy(DeploymentUnit context) {
        Set resources = (Set)context.removeAttachment(RESOURCES_TO_CLOSE);
        if (resources != null) {
            for (AutoCloseable resource : resources) {
                try {
                    LoggingLogger.ROOT_LOGGER.tracef("Closing %s", resource);
                    resource.close();
                }
                catch (Exception e) {
                    LoggingLogger.ROOT_LOGGER.failedToCloseResource(e, resource);
                }
            }
        }
    }

    static synchronized void addResource(DeploymentUnit deploymentUnit, AutoCloseable resource) {
        Set resources = (Set)deploymentUnit.getAttachment(RESOURCES_TO_CLOSE);
        if (resources == null) {
            resources = Collections.newSetFromMap(new IdentityHashMap());
            deploymentUnit.putAttachment(RESOURCES_TO_CLOSE, resources);
        }
        resources.add(resource);
    }
}

