/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.loggers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.filters.Filters;
import org.jboss.as.logging.loggers.LoggerAttributes;
import org.jboss.as.logging.loggers.LoggerResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;

final class LoggerOperations {
    static final OperationStepHandler REMOVE_LOGGER = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(context.getCurrentAddressValue());
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.loggerNotFound(loggerName));
            }
            logContextConfiguration.removeLoggerConfiguration(loggerName);
        }
    };
    static final OperationStepHandler ADD_HANDLER = new LoggerUpdateOperationStepHandler(new AttributeDefinition[]{LoggerAttributes.HANDLERS}){

        @Override
        public void updateModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode handlerName = operation.get(CommonAttributes.HANDLER_NAME.getName());
            ModelNode handlers = model.get(LoggerAttributes.HANDLERS.getName()).clone();
            if (!handlers.isDefined()) {
                handlers.setEmptyList();
            }
            handlers.add(handlerName);
            LoggerAttributes.HANDLERS.getValidator().validateParameter(LoggerAttributes.HANDLERS.getName(), handlers);
            model.get(LoggerAttributes.HANDLERS.getName()).add(handlerName);
            LoggerAttributes.HANDLER.addCapabilityRequirements(context, resource, handlerName);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LoggerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            String handlerName = CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, operation).asString();
            String loggerName = LoggerOperations.getLogManagerLoggerName(name);
            if (configuration.getHandlerNames().contains(handlerName)) {
                LoggingLogger.ROOT_LOGGER.tracef("Handler %s is already assigned to logger %s", handlerName, loggerName);
            } else {
                LoggingLogger.ROOT_LOGGER.tracef("Adding handler '%s' to logger '%s' at '%s'", handlerName, LoggerOperations.getLogManagerLoggerName(loggerName), context.getCurrentAddress());
                configuration.addHandlerName(handlerName);
            }
        }
    };
    static final OperationStepHandler REMOVE_HANDLER = new LoggerUpdateOperationStepHandler(new AttributeDefinition[]{LoggerAttributes.HANDLERS}){

        @Override
        public void updateModel(OperationContext context, ModelNode operation, ModelNode model) {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            String handlerName = operation.get(CommonAttributes.HANDLER_NAME.getName()).asString();
            boolean found = false;
            List handlers = model.get(LoggerAttributes.HANDLERS.getName()).asList();
            ArrayList<ModelNode> newHandlers = new ArrayList<ModelNode>(handlers.size());
            for (ModelNode handler : handlers) {
                if (handlerName.equals(handler.asString())) {
                    LoggerAttributes.HANDLER.removeCapabilityRequirements(context, resource, handler);
                    found = true;
                    continue;
                }
                newHandlers.add(handler);
            }
            if (found) {
                model.get(LoggerAttributes.HANDLERS.getName()).set(newHandlers);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LoggerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            configuration.removeHandlerName(CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, operation).asString());
        }
    };
    static final OperationStepHandler CHANGE_LEVEL = new LoggerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.LEVEL}){

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LoggerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, model, configuration);
        }
    };

    LoggerOperations() {
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LoggerConfiguration configuration) throws OperationFailedException {
        LoggerOperations.handleProperty(attribute, context, model, configuration, true);
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LoggerConfiguration configuration, boolean resolveValue) throws OperationFailedException {
        if (LoggerAttributes.FILTER_SPEC.equals(attribute)) {
            ModelNode valueNode = resolveValue ? LoggerAttributes.FILTER_SPEC.resolveModelAttribute(context, model) : model;
            String resolvedValue = valueNode.isDefined() ? valueNode.asString() : null;
            configuration.setFilter(resolvedValue);
        } else if (CommonAttributes.LEVEL.equals(attribute)) {
            String resolvedValue = resolveValue ? CommonAttributes.LEVEL.resolvePropertyValue(context, model) : CommonAttributes.LEVEL.resolver().resolveValue(context, model);
            configuration.setLevel(resolvedValue);
        } else if (LoggerAttributes.HANDLERS.equals(attribute)) {
            Object resolvedValue = resolveValue ? LoggerAttributes.HANDLERS.resolvePropertyValue(context, model) : (Collection)LoggerAttributes.HANDLERS.resolver().resolveValue(context, model);
            configuration.setHandlerNames((Collection)resolvedValue);
        } else if (LoggerResourceDefinition.USE_PARENT_HANDLERS.equals(attribute)) {
            ModelNode useParentHandlers = resolveValue ? LoggerResourceDefinition.USE_PARENT_HANDLERS.resolveModelAttribute(context, model) : model;
            Boolean resolvedValue = useParentHandlers.isDefined() ? Boolean.valueOf(useParentHandlers.asBoolean()) : null;
            configuration.setUseParentHandlers(resolvedValue);
        }
    }

    private static String getLogManagerLoggerName(String name) {
        return name.equals("ROOT") ? "" : name;
    }

    static class LoggerWriteAttributeHandler
    extends LoggingOperations.LoggingWriteAttributeHandler {
        LoggerWriteAttributeHandler() {
        }

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(addressName);
            if (logContextConfiguration.getLoggerNames().contains(loggerName)) {
                LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
                if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, configuration, false);
                } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)LoggerAttributes.FILTER_SPEC, context, value, configuration, false);
                } else if (LoggerAttributes.FILTER_SPEC.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)LoggerAttributes.FILTER_SPEC, context, value, configuration, false);
                } else if (LoggerAttributes.HANDLERS.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)LoggerAttributes.HANDLERS, context, value, configuration, false);
                } else if (LoggerResourceDefinition.USE_PARENT_HANDLERS.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)LoggerResourceDefinition.USE_PARENT_HANDLERS, context, value, configuration, false);
                }
            }
            return false;
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                String filterSpec = Filters.filterToFilterSpec(newValue);
                ModelNode filterSpecValue = filterSpec.isEmpty() ? new ModelNode() : new ModelNode(filterSpec);
                model.getModel().get(LoggerAttributes.FILTER_SPEC.getName()).set(filterSpecValue);
            }
        }
    }

    static final class LoggerAddOperationStepHandler
    extends LoggingOperations.LoggingAddOperationStepHandler {
        private final AttributeDefinition[] attributes;

        LoggerAddOperationStepHandler(AttributeDefinition[] attributes) {
            super(attributes);
            this.attributes = attributes;
        }

        public void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                if (CommonAttributes.FILTER.equals((Object)attribute)) {
                    ModelNode filter = CommonAttributes.FILTER.validateOperation(operation);
                    if (!filter.isDefined()) continue;
                    String value = Filters.filterToFilterSpec(filter);
                    model.get(LoggerAttributes.FILTER_SPEC.getName()).set(value.isEmpty() ? new ModelNode() : new ModelNode(value));
                    continue;
                }
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            String loggerName = LoggerOperations.getLogManagerLoggerName(name);
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
            if (configuration == null) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding logger '%s' at '%s'", name, context.getCurrentAddress());
                configuration = logContextConfiguration.addLoggerConfiguration(loggerName);
            }
            for (AttributeDefinition attribute : this.attributes) {
                LoggerOperations.handleProperty(attribute, context, model, configuration);
            }
        }
    }

    static abstract class LoggerUpdateOperationStepHandler
    extends LoggingOperations.LoggingUpdateOperationStepHandler {
        LoggerUpdateOperationStepHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        @Override
        public final void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(context.getCurrentAddressValue());
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.loggerConfigurationNotFound(loggerName));
            }
            this.performRuntime(context, operation, configuration, loggerName, model);
        }

        public abstract void performRuntime(OperationContext var1, ModelNode var2, LoggerConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;
    }
}

