/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.capabilities.Capabilities;
import org.jboss.as.logging.handlers.AbstractHandlerDefinition;
import org.jboss.as.logging.handlers.HandlerOperations;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.as.logging.validators.Validators;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.handlers.SyslogHandler;

public class SyslogHandlerResourceDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "syslog-handler";
    private static final PathElement SYSLOG_HANDLER_PATH = PathElement.pathElement((String)"syslog-handler");
    public static final PropertyAttributeDefinition APP_NAME = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("app-name", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setPropertyName("appName").setValidator((ParameterValidator)Validators.NOT_EMPTY_NULLABLE_STRING_VALIDATOR)).build();
    public static final PropertyAttributeDefinition FACILITY = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("facility", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(FacilityAttribute.USER_LEVEL.toString()))).setResolver(FacilityResolver.INSTANCE).setValidator((ParameterValidator)EnumValidator.create(FacilityAttribute.class, EnumSet.allOf(FacilityAttribute.class)))).build();
    public static final PropertyAttributeDefinition HOSTNAME = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("hostname", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setValidator((ParameterValidator)Validators.NOT_EMPTY_NULLABLE_STRING_VALIDATOR)).build();
    public static final PropertyAttributeDefinition PORT = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("port", ModelType.INT, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(514))).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true))).build();
    public static final PropertyAttributeDefinition SERVER_ADDRESS = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("server-address", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode("localhost"))).setPropertyName("serverHostname").setValidator((ParameterValidator)Validators.NOT_EMPTY_NULLABLE_STRING_VALIDATOR)).build();
    public static final PropertyAttributeDefinition SYSLOG_FORMATTER = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("syslog-format", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement(attribute.getXmlName());
            String content = resourceModel.hasDefined(attribute.getName()) ? resourceModel.get(attribute.getName()).asString() : attribute.getDefaultValue().asString();
            writer.writeAttribute(Attribute.SYSLOG_TYPE.getLocalName(), content);
            writer.writeEndElement();
        }
    })).setDefaultValue(new ModelNode(SyslogHandler.SyslogType.RFC5424.name()))).setPropertyName("syslogType").setValidator((ParameterValidator)EnumValidator.create(SyslogHandler.SyslogType.class, EnumSet.allOf(SyslogHandler.SyslogType.class)))).build();
    public static final SimpleAttributeDefinition NAMED_FORMATTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)AbstractHandlerDefinition.NAMED_FORMATTER).setAlternatives(new String[0])).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.NAME_ATTRIBUTE_MARSHALLER)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{APP_NAME, CommonAttributes.ENABLED, FACILITY, HOSTNAME, CommonAttributes.LEVEL, PORT, SERVER_ADDRESS, SYSLOG_FORMATTER, NAMED_FORMATTER};
    private static final HandlerOperations.HandlerAddOperationStepHandler ADD_HANDLER = new HandlerOperations.HandlerAddOperationStepHandler(SyslogHandler.class, ATTRIBUTES, new ConfigurationProperty[0]);
    private static final HandlerOperations.LogHandlerWriteAttributeHandler WRITE_HANDLER = new HandlerOperations.LogHandlerWriteAttributeHandler();
    public static final SyslogHandlerResourceDefinition INSTANCE = new SyslogHandlerResourceDefinition();

    private SyslogHandlerResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(SYSLOG_HANDLER_PATH, LoggingExtension.getResourceDescriptionResolver(NAME)).setAddHandler((OperationStepHandler)ADD_HANDLER).setRemoveHandler(HandlerOperations.REMOVE_HANDLER).setCapabilities(new RuntimeCapability[]{Capabilities.HANDLER_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)WRITE_HANDLER);
        }
    }

    static class FacilityResolver
    implements ModelNodeResolver<String> {
        static final FacilityResolver INSTANCE = new FacilityResolver();

        FacilityResolver() {
        }

        @Override
        public String resolveValue(OperationContext context, ModelNode value) {
            return FacilityAttribute.fromString(value.asString()).getFacility().name();
        }
    }

    public static enum FacilityAttribute {
        KERNEL("kernel"),
        USER_LEVEL("user-level"),
        MAIL_SYSTEM("mail-system"),
        SYSTEM_DAEMONS("system-daemons"),
        SECURITY("security"),
        SYSLOGD("syslogd"),
        LINE_PRINTER("line-printer"),
        NETWORK_NEWS("network-news"),
        UUCP("uucp"),
        CLOCK_DAEMON("clock-daemon"),
        SECURITY2("security2"),
        FTP_DAEMON("ftp-daemon"),
        NTP("ntp"),
        LOG_AUDIT("log-audit"),
        LOG_ALERT("log-alert"),
        CLOCK_DAEMON2("clock-daemon2"),
        LOCAL_USE_0("local-use-0"),
        LOCAL_USE_1("local-use-1"),
        LOCAL_USE_2("local-use-2"),
        LOCAL_USE_3("local-use-3"),
        LOCAL_USE_4("local-use-4"),
        LOCAL_USE_5("local-use-5"),
        LOCAL_USE_6("local-use-6"),
        LOCAL_USE_7("local-use-7");

        private static final Map<String, FacilityAttribute> MAP;
        private final SyslogHandler.Facility facility;
        private final String value;

        private FacilityAttribute(String value) {
            this.value = value;
            this.facility = SyslogHandler.Facility.valueOf((String)value.replace("-", "_").toUpperCase(Locale.ENGLISH));
        }

        public SyslogHandler.Facility getFacility() {
            return this.facility;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static FacilityAttribute fromString(String value) {
            return MAP.get(value);
        }

        static {
            MAP = new HashMap<String, FacilityAttribute>();
            for (FacilityAttribute facilityAttribute : FacilityAttribute.values()) {
                MAP.put(facilityAttribute.toString(), facilityAttribute);
            }
        }
    }

    public static final class TransformerDefinition
    extends TransformerResourceDefinition {
        public TransformerDefinition() {
            super(SYSLOG_HANDLER_PATH);
        }

        @Override
        public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
            switch (modelVersion) {
                case VERSION_7_0_0: {
                    ResourceTransformationDescriptionBuilder resourceBuilder = rootResourceBuilder.addChildResource(SYSLOG_HANDLER_PATH);
                    ResourceTransformationDescriptionBuilder loggingProfileResourceBuilder = loggingProfileBuilder.addChildResource(SYSLOG_HANDLER_PATH);
                    ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)resourceBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{NAMED_FORMATTER})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{NAMED_FORMATTER})).end();
                    ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)loggingProfileResourceBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{NAMED_FORMATTER})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{NAMED_FORMATTER})).end();
                    break;
                }
            }
        }
    }
}

