/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.filters.Filters;
import org.jboss.as.logging.formatters.PatternFormatterResourceDefinition;
import org.jboss.as.logging.handlers.AbstractHandlerDefinition;
import org.jboss.as.logging.handlers.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.PojoConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

final class HandlerOperations {
    private static final Logger.AttachmentKey<Map<String, String>> DISABLED_HANDLERS_KEY = new Logger.AttachmentKey();
    private static final Object HANDLER_LOCK = new Object();
    static final OperationStepHandler CHANGE_LEVEL = new HandlerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.LEVEL});
    static final OperationStepHandler REMOVE_HANDLER = new LogHandlerRemoveHandler();
    static final OperationStepHandler ADD_SUBHANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(new AttributeDefinition[]{AsyncHandlerResourceDefinition.SUBHANDLERS}){

        @Override
        public void updateModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode handlerName = operation.get(CommonAttributes.HANDLER_NAME.getName());
            ModelNode handlers = model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).clone();
            if (!handlers.isDefined()) {
                handlers.setEmptyList();
            }
            handlers.add(handlerName);
            AsyncHandlerResourceDefinition.SUBHANDLERS.getValidator().validateParameter(AsyncHandlerResourceDefinition.SUBHANDLERS.getName(), handlers);
            model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).add(handlerName);
            AsyncHandlerResourceDefinition.HANDLER.addCapabilityRequirements(context, resource, handlerName);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.handlerConfigurationNotFound(name));
            }
            String handlerName = CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, operation).asString();
            if (name.equals(handlerName)) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.cannotAddHandlerToSelf(configuration.getName()));
            }
            if (configuration.getHandlerNames().contains(handlerName)) {
                LoggingLogger.ROOT_LOGGER.tracef("Handler %s is already assigned to handler %s", handlerName, handlerName);
            } else {
                configuration.addHandlerName(handlerName);
            }
        }
    };
    static final OperationStepHandler REMOVE_SUBHANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(new AttributeDefinition[]{AsyncHandlerResourceDefinition.SUBHANDLERS}){

        @Override
        public void updateModel(OperationContext context, ModelNode operation, ModelNode model) {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            String handlerName = operation.get(CommonAttributes.HANDLER_NAME.getName()).asString();
            boolean found = false;
            List handlers = model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).asList();
            ArrayList<ModelNode> newHandlers = new ArrayList<ModelNode>(handlers.size());
            for (ModelNode handler : handlers) {
                if (handlerName.equals(handler.asString())) {
                    AsyncHandlerResourceDefinition.HANDLER.removeCapabilityRequirements(context, resource, handler);
                    found = true;
                    continue;
                }
                newHandlers.add(handler);
            }
            if (found) {
                model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).set(newHandlers);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.handlerConfigurationNotFound(name));
            }
            configuration.removeHandlerName(CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, operation).asString());
        }
    };
    static final OperationStepHandler CHANGE_FILE = new HandlerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.FILE});
    static final LoggingOperations.LoggingUpdateOperationStepHandler ENABLE_HANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(new AttributeDefinition[0]){

        @Override
        public void updateModel(OperationContext context, ModelNode operation, ModelNode model) {
            model.get(CommonAttributes.ENABLED.getName()).set(true);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration configuration) {
            HandlerOperations.enableHandler(configuration, context.getCurrentAddressValue());
        }
    };
    static final LoggingOperations.LoggingUpdateOperationStepHandler DISABLE_HANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(new AttributeDefinition[0]){

        @Override
        public void updateModel(OperationContext context, ModelNode operation, ModelNode model) {
            model.get(CommonAttributes.ENABLED.getName()).set(false);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration configuration) {
            HandlerOperations.disableHandler(configuration, context.getCurrentAddressValue());
        }
    };

    HandlerOperations() {
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration) throws OperationFailedException {
        HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration, true);
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration, boolean resolveValue) throws OperationFailedException {
        if (attribute.getName().equals(CommonAttributes.ENABLED.getName())) {
            boolean value;
            boolean bl = value = resolveValue ? CommonAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean() : model.asBoolean();
            if (value) {
                HandlerOperations.enableHandler(logContextConfiguration, configuration.getName());
            } else {
                HandlerOperations.disableHandler(logContextConfiguration, configuration.getName());
            }
        } else if (attribute.getName().equals(CommonAttributes.ENCODING.getName())) {
            String resolvedValue = resolveValue ? CommonAttributes.ENCODING.resolvePropertyValue(context, model) : (model.isDefined() ? model.asString() : null);
            configuration.setEncoding(resolvedValue);
        } else if (attribute.getName().equals(AbstractHandlerDefinition.FORMATTER.getName())) {
            String defaultFormatterName = PatternFormatterResourceDefinition.getDefaultFomatterName(configuration.getName());
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode m2 = resource.getModel();
            if (m2.hasDefined(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
                if (logContextConfiguration.getFormatterNames().contains(defaultFormatterName)) {
                    logContextConfiguration.removeFormatterConfiguration(defaultFormatterName);
                }
            } else {
                FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterNames().contains(defaultFormatterName) ? logContextConfiguration.getFormatterConfiguration(defaultFormatterName) : logContextConfiguration.addFormatterConfiguration(null, PatternFormatter.class.getName(), defaultFormatterName, new String[]{PatternFormatterResourceDefinition.PATTERN.getPropertyName()});
                String resolvedValue = resolveValue ? AbstractHandlerDefinition.FORMATTER.resolvePropertyValue(context, model) : model.asString();
                fmtConfig.setPropertyValueString(PatternFormatterResourceDefinition.PATTERN.getPropertyName(), resolvedValue);
                configuration.setFormatterName(defaultFormatterName);
            }
        } else if (attribute.getName().equals(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
            ModelNode valueNode;
            String handlerName = configuration.getName();
            String defaultFormatterName = PatternFormatterResourceDefinition.getDefaultFomatterName(handlerName);
            ModelNode modelNode = valueNode = resolveValue ? AbstractHandlerDefinition.NAMED_FORMATTER.resolveModelAttribute(context, model) : model;
            if (valueNode.isDefined()) {
                String resolvedValue = valueNode.asString();
                configuration.setFormatterName(resolvedValue);
                if (logContextConfiguration.getFormatterNames().contains(defaultFormatterName)) {
                    logContextConfiguration.removeFormatterConfiguration(defaultFormatterName);
                }
            } else if (configuration.getClassName().equals(SyslogHandler.class.getName())) {
                Handler instance = (Handler)configuration.getInstance();
                if (instance != null) {
                    instance.setFormatter((Formatter)new PatternFormatter("%s"));
                }
            } else {
                FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterNames().contains(defaultFormatterName) ? logContextConfiguration.getFormatterConfiguration(defaultFormatterName) : logContextConfiguration.addFormatterConfiguration(null, PatternFormatter.class.getName(), defaultFormatterName, new String[]{PatternFormatterResourceDefinition.PATTERN.getPropertyName()});
                Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                fmtConfig.setPropertyValueString(PatternFormatterResourceDefinition.PATTERN.getPropertyName(), AbstractHandlerDefinition.FORMATTER.resolvePropertyValue(context, resource.getModel()));
                configuration.setFormatterName(defaultFormatterName);
            }
        } else if (attribute.getName().equals(AbstractHandlerDefinition.FILTER_SPEC.getName())) {
            ModelNode valueNode = resolveValue ? AbstractHandlerDefinition.FILTER_SPEC.resolveModelAttribute(context, model) : model;
            String resolvedValue = valueNode.isDefined() ? valueNode.asString() : null;
            configuration.setFilter(resolvedValue);
        } else if (attribute.getName().equals(CommonAttributes.LEVEL.getName())) {
            String resolvedValue = resolveValue ? CommonAttributes.LEVEL.resolvePropertyValue(context, model) : CommonAttributes.LEVEL.resolver().resolveValue(context, model);
            configuration.setLevel(resolvedValue);
        } else if (attribute.getName().equals(AsyncHandlerResourceDefinition.SUBHANDLERS.getName())) {
            Object resolvedValue;
            Object object = resolvedValue = resolveValue ? AsyncHandlerResourceDefinition.SUBHANDLERS.resolvePropertyValue(context, model) : (Collection)AsyncHandlerResourceDefinition.SUBHANDLERS.resolver().resolveValue(context, model);
            if (resolvedValue.contains(configuration.getName())) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.cannotAddHandlerToSelf(configuration.getName()));
            }
            configuration.setHandlerNames((Collection)resolvedValue);
        } else if (!attribute.getName().equals(CommonAttributes.HANDLER_NAME.getName())) {
            if (attribute.getName().equals(CommonAttributes.PROPERTIES.getName())) {
                PojoConfiguration pojoConfiguration = logContextConfiguration.getPojoConfiguration(configuration.getName());
                Object propertyConfigurable = pojoConfiguration == null ? configuration : pojoConfiguration;
                if (model.hasDefined(CommonAttributes.PROPERTIES.getName())) {
                    ModelNode resolvedValue = resolveValue ? CommonAttributes.PROPERTIES.resolveModelAttribute(context, model) : model;
                    for (Property property : resolvedValue.asPropertyList()) {
                        propertyConfigurable.setPropertyValueString(property.getName(), property.getValue().asString());
                    }
                }
            } else if (attribute instanceof ConfigurationProperty) {
                boolean addAsStep = CommonAttributes.FILE.equals(attribute);
                ConfigurationProperty configurationProperty = (ConfigurationProperty)attribute;
                if (resolveValue) {
                    if (addAsStep) {
                        context.addStep((c, m) -> configurationProperty.setPropertyValue(c, m, (PropertyConfigurable)configuration), OperationContext.Stage.RUNTIME);
                    } else {
                        configurationProperty.setPropertyValue(context, model, (PropertyConfigurable)configuration);
                    }
                } else {
                    String resolvedValue;
                    ModelNodeResolver resolver = configurationProperty.resolver();
                    String string = resolver == null ? (model.isDefined() ? model.asString() : null) : (resolvedValue = (String)resolver.resolveValue(context, model));
                    if (resolvedValue == null) {
                        if (addAsStep) {
                            context.addStep((c, m) -> {
                                configuration.setPropertyValueString(configurationProperty.getPropertyName(), null);
                                configuration.removeProperty(configurationProperty.getPropertyName());
                            }, OperationContext.Stage.RUNTIME);
                        } else {
                            configuration.setPropertyValueString(configurationProperty.getPropertyName(), null);
                            configuration.removeProperty(configurationProperty.getPropertyName());
                        }
                    } else if (addAsStep) {
                        context.addStep((c, m) -> configuration.setPropertyValueString(configurationProperty.getPropertyName(), resolvedValue), OperationContext.Stage.RUNTIME);
                    } else {
                        configuration.setPropertyValueString(configurationProperty.getPropertyName(), resolvedValue);
                    }
                }
            } else {
                LoggingLogger.ROOT_LOGGER.invalidPropertyAttribute(attribute.getName());
            }
        }
    }

    private static boolean equalValue(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration) throws OperationFailedException {
        boolean result;
        if (attribute.getName().equals(CommonAttributes.ENABLED.getName())) {
            boolean resolvedValue = CommonAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean();
            boolean currentValue = configuration.hasProperty(CommonAttributes.ENABLED.getPropertyName()) ? Boolean.parseBoolean(configuration.getPropertyValueString(CommonAttributes.ENABLED.getPropertyName())) : HandlerOperations.isEnabled(logContextConfiguration.getLogContext(), configuration.getName());
            result = resolvedValue == currentValue;
        } else if (attribute.getName().equals(CommonAttributes.ENCODING.getName())) {
            String resolvedValue = CommonAttributes.ENCODING.resolvePropertyValue(context, model);
            String currentValue = configuration.getEncoding();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else if (attribute.getName().equals(AbstractHandlerDefinition.FORMATTER.getName())) {
            if (model.hasDefined(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
                result = true;
            } else {
                String formatterName = configuration.getName();
                if (formatterName.equals(configuration.getFormatterNameValueExpression().getResolvedValue())) {
                    if (logContextConfiguration.getFormatterNames().contains(formatterName)) {
                        FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterConfiguration(formatterName);
                        String resolvedValue = AbstractHandlerDefinition.FORMATTER.resolvePropertyValue(context, model);
                        String currentValue = fmtConfig.getPropertyValueString(PatternFormatterResourceDefinition.PATTERN.getName());
                        result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
                    } else {
                        result = false;
                    }
                } else {
                    result = false;
                }
            }
        } else if (attribute.getName().equals(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
            ModelNode valueNode = AbstractHandlerDefinition.NAMED_FORMATTER.resolveModelAttribute(context, model);
            if (valueNode.isDefined()) {
                String resolvedValue = valueNode.asString();
                String currentValue = configuration.getFormatterName();
                result = resolvedValue.equals(currentValue);
            } else {
                result = true;
            }
        } else if (attribute.getName().equals(AbstractHandlerDefinition.FILTER_SPEC.getName())) {
            result = false;
        } else if (attribute.getName().equals(CommonAttributes.LEVEL.getName())) {
            String resolvedValue = CommonAttributes.LEVEL.resolvePropertyValue(context, model);
            String currentValue = configuration.getLevel();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(configuration.getLevel());
        } else if (attribute.getName().equals(AsyncHandlerResourceDefinition.SUBHANDLERS.getName())) {
            Object resolvedValue = AsyncHandlerResourceDefinition.SUBHANDLERS.resolvePropertyValue(context, model);
            List currentValue = configuration.getHandlerNames();
            result = resolvedValue.size() == currentValue.size() && resolvedValue.containsAll(currentValue);
        } else if (attribute.getName().equals(CommonAttributes.PROPERTIES.getName())) {
            result = true;
            PojoConfiguration pojoConfiguration = logContextConfiguration.getPojoConfiguration(configuration.getName());
            Object propertyConfigurable = pojoConfiguration == null ? configuration : pojoConfiguration;
            if (model.hasDefined(CommonAttributes.PROPERTIES.getName())) {
                for (Property property : CommonAttributes.PROPERTIES.resolveModelAttribute(context, model).asPropertyList()) {
                    String resolvedValue = property.getValue().asString();
                    String currentValue = propertyConfigurable.getPropertyValueString(property.getName());
                    if (resolvedValue != null ? resolvedValue.equals(currentValue) : currentValue == null) continue;
                    return false;
                }
            } else if (model.has(CommonAttributes.PROPERTIES.getName())) {
                List propertyNames = propertyConfigurable.getPropertyNames();
                for (String propertyName : propertyNames) {
                    String propertyValue = propertyConfigurable.getPropertyValueString(propertyName);
                    if (propertyValue == null) continue;
                    return false;
                }
            }
        } else if (attribute instanceof ConfigurationProperty) {
            ConfigurationProperty propAttribute = (ConfigurationProperty)attribute;
            Object resolvedValue = propAttribute.resolvePropertyValue(context, model);
            String currentValue = configuration.getPropertyValueString(propAttribute.getPropertyName());
            result = resolvedValue == null ? currentValue == null : String.valueOf(resolvedValue).equals(currentValue);
        } else {
            result = false;
        }
        return result;
    }

    private static boolean isEnabled(LogContext logContext, String handlerName) {
        Map disableHandlers = (Map)logContext.getAttachment("", DISABLED_HANDLERS_KEY);
        return disableHandlers == null || !disableHandlers.containsKey(handlerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enableHandler(LogContextConfiguration configuration, String handlerName) {
        HandlerConfiguration handlerConfiguration = configuration.getHandlerConfiguration(handlerName);
        try {
            handlerConfiguration.setPropertyValueString("enabled", "true");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Map disableHandlers = (Map)configuration.getLogContext().getAttachment("", DISABLED_HANDLERS_KEY);
            if (disableHandlers != null && disableHandlers.containsKey(handlerName)) {
                Object object = HANDLER_LOCK;
                synchronized (object) {
                    String filter = (String)disableHandlers.get(handlerName);
                    handlerConfiguration.setFilter(filter);
                    disableHandlers.remove(handlerName);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disableHandler(LogContextConfiguration configuration, String handlerName) {
        HandlerConfiguration handlerConfiguration = configuration.getHandlerConfiguration(handlerName);
        try {
            handlerConfiguration.setPropertyValueString("enabled", "false");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger root = configuration.getLogContext().getLogger("");
            Map<String, String> disableHandlers = (HashMap<String, String>)root.getAttachment(DISABLED_HANDLERS_KEY);
            Object object = HANDLER_LOCK;
            synchronized (object) {
                Map current;
                if (disableHandlers == null && (current = (Map)root.attachIfAbsent(DISABLED_HANDLERS_KEY, disableHandlers = new HashMap<String, String>())) != null) {
                    disableHandlers = current;
                }
                if (!disableHandlers.containsKey(handlerName)) {
                    disableHandlers.put(handlerName, handlerConfiguration.getFilter());
                    handlerConfiguration.setFilter(CommonAttributes.DENY.getName());
                }
            }
            return;
        }
    }

    static class LogHandlerRemoveHandler
    extends LoggingOperations.LoggingRemoveOperationStepHandler {
        LogHandlerRemoveHandler() {
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            List loggerNames = logContextConfiguration.getLoggerNames();
            ArrayList<String> assigned = new ArrayList<String>();
            for (Object loggerName : loggerNames) {
                LoggerConfiguration c = logContextConfiguration.getLoggerConfiguration((String)loggerName);
                if (c == null || !c.getHandlerNames().contains(name)) continue;
                if ("".equals(loggerName)) {
                    assigned.add("ROOT");
                    continue;
                }
                assigned.add((String)loggerName);
            }
            if (!assigned.isEmpty()) {
                context.setRollbackOnly();
                throw LoggingLogger.ROOT_LOGGER.handlerAttachedToLoggers(name, assigned);
            }
            List handlerNames = logContextConfiguration.getHandlerNames();
            for (String handlerName : handlerNames) {
                HandlerConfiguration c = logContextConfiguration.getHandlerConfiguration(handlerName);
                if (c == null || !c.getHandlerNames().contains(name)) continue;
                assigned.add(handlerName);
            }
            if (!assigned.isEmpty()) {
                context.setRollbackOnly();
                throw LoggingLogger.ROOT_LOGGER.handlerAttachedToHandlers(name, assigned);
            }
            logContextConfiguration.removeHandlerConfiguration(name);
            String defaultFormatterName = PatternFormatterResourceDefinition.getDefaultFomatterName(name);
            if (logContextConfiguration.getFormatterNames().contains(defaultFormatterName) && !model.hasDefined(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
                logContextConfiguration.removeFormatterConfiguration(defaultFormatterName);
            }
            if (logContextConfiguration.getPojoNames().contains(name)) {
                logContextConfiguration.removePojoConfiguration(name);
            }
        }
    }

    static class LogHandlerWriteAttributeHandler
    extends LoggingOperations.LoggingWriteAttributeHandler {
        LogHandlerWriteAttributeHandler() {
        }

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            boolean restartRequired = false;
            if (logContextConfiguration.getHandlerNames().contains(addressName)) {
                HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(addressName);
                if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, logContextConfiguration, configuration, false);
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)AbstractHandlerDefinition.FILTER_SPEC, context, value, logContextConfiguration, configuration, false);
                } else if (AbstractHandlerDefinition.FILTER_SPEC.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)AbstractHandlerDefinition.FILTER_SPEC, context, value, logContextConfiguration, configuration, false);
                } else if (AbstractHandlerDefinition.FORMATTER.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)AbstractHandlerDefinition.FORMATTER, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.ENCODING.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.ENCODING, context, value, logContextConfiguration, configuration, false);
                } else if (AsyncHandlerResourceDefinition.SUBHANDLERS.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)AsyncHandlerResourceDefinition.SUBHANDLERS, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.PROPERTIES.getName().equals(attributeName)) {
                    PojoConfiguration pojoConfiguration = logContextConfiguration.getPojoConfiguration(configuration.getName());
                    Object propertyConfigurable = pojoConfiguration == null ? configuration : pojoConfiguration;
                    if (value.isDefined()) {
                        for (Property property : value.asPropertyList()) {
                            propertyConfigurable.setPropertyValueString(property.getName(), property.getValue().asString());
                        }
                    } else {
                        List propertyNames = propertyConfigurable.getPropertyNames();
                        for (String propertyName : propertyNames) {
                            if ("enabled".equals(propertyName)) continue;
                            propertyConfigurable.removeProperty(propertyName);
                            restartRequired = true;
                        }
                    }
                } else if (AsyncHandlerResourceDefinition.QUEUE_LENGTH.getName().equals(attributeName)) {
                    restartRequired = true;
                } else {
                    AttributeDefinition attribute = context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName).getAttributeDefinition();
                    HandlerOperations.handleProperty(attribute, context, value, logContextConfiguration, configuration, false);
                    restartRequired = Logging.requiresReload(attribute.getFlags());
                }
            }
            return restartRequired;
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                String filterSpec = Filters.filterToFilterSpec(newValue);
                ModelNode filterSpecValue = filterSpec.isEmpty() ? new ModelNode() : new ModelNode(filterSpec);
                model.getModel().get(AbstractHandlerDefinition.FILTER_SPEC.getName()).set(filterSpecValue);
            }
        }
    }

    static class HandlerAddOperationStepHandler
    extends LoggingOperations.LoggingAddOperationStepHandler {
        private final String[] constructionProperties;
        private final AttributeDefinition[] attributes;
        private final Class<? extends Handler> type;

        HandlerAddOperationStepHandler(Class<? extends Handler> type, AttributeDefinition[] attributes, ConfigurationProperty<?> ... constructionProperties) {
            super(attributes);
            this.type = type;
            this.attributes = attributes;
            ArrayList<String> names = new ArrayList<String>();
            for (ConfigurationProperty<?> prop : constructionProperties) {
                names.add(prop.getPropertyName());
            }
            this.constructionProperties = names.toArray(new String[0]);
        }

        public void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                if (CommonAttributes.FILTER.equals((Object)attribute)) {
                    ModelNode filter = CommonAttributes.FILTER.validateOperation(operation);
                    if (!filter.isDefined()) continue;
                    String value = Filters.filterToFilterSpec(filter);
                    model.get(AbstractHandlerDefinition.FILTER_SPEC.getName()).set(value.isEmpty() ? new ModelNode() : new ModelNode(value));
                    continue;
                }
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            boolean exists;
            String moduleName;
            String className;
            if (this.type == null) {
                className = CommonAttributes.CLASS.resolveModelAttribute(context, model).asString();
                moduleName = CommonAttributes.MODULE.resolveModelAttribute(context, model).asString();
            } else {
                className = this.type.getName();
                moduleName = null;
            }
            String name = context.getCurrentAddressValue();
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            boolean replaceHandler = false;
            boolean bl = exists = configuration != null;
            if (exists && !context.isBooting()) {
                context.setRollbackOnly();
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.handlerAlreadyDefined(name));
            }
            if (!exists) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding handler '%s' at '%s'", name, context.getCurrentAddress());
                try {
                    configuration = this.createHandlerConfiguration(className, moduleName, name, logContextConfiguration);
                }
                catch (IllegalArgumentException | OperationFailedException e) {
                    context.setRollbackOnly();
                    throw e;
                }
            } else if (!className.equals(configuration.getClassName()) || (moduleName == null ? configuration.getModuleName() != null : !moduleName.equals(configuration.getModuleName()))) {
                replaceHandler = true;
            }
            if (replaceHandler) {
                LoggingLogger.ROOT_LOGGER.replacingNamedHandler(name);
                LoggingLogger.ROOT_LOGGER.debugf("Removing handler %s of type '%s' in module '%s' and replacing with type '%s' in module '%s'", new Object[]{name, configuration.getClassName(), configuration.getModuleName(), className, moduleName});
                logContextConfiguration.removeHandlerConfiguration(name);
                if (logContextConfiguration.getPojoNames().contains(name)) {
                    logContextConfiguration.removePojoConfiguration(name);
                }
                try {
                    configuration = this.createHandlerConfiguration(className, moduleName, name, logContextConfiguration);
                }
                catch (IllegalArgumentException | OperationFailedException e) {
                    context.setRollbackOnly();
                    throw e;
                }
            }
            for (AttributeDefinition attribute : this.attributes) {
                boolean skip;
                if (attribute.equals((Object)CommonAttributes.CLASS) || attribute.equals((Object)CommonAttributes.MODULE) || attribute.equals((Object)CommonAttributes.FILTER)) {
                    skip = true;
                } else {
                    boolean bl2 = skip = exists && HandlerOperations.equalValue(attribute, context, model, logContextConfiguration, configuration);
                }
                if (skip) continue;
                HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration);
            }
        }

        HandlerConfiguration createHandlerConfiguration(String className, String moduleName, String name, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            HandlerConfiguration configuration;
            if (moduleName != null) {
                ModuleLoader moduleLoader = ModuleLoader.forClass(HandlerOperations.class);
                try {
                    Class.forName(className, false, (ClassLoader)moduleLoader.loadModule(moduleName).getClassLoader());
                    if (this.constructionProperties == null) {
                        configuration = logContextConfiguration.addHandlerConfiguration(moduleName, className, name, new String[0]);
                    }
                    configuration = logContextConfiguration.addHandlerConfiguration(moduleName, className, name, this.constructionProperties);
                }
                catch (ClassNotFoundException e) {
                    throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.classNotFound(e, className));
                }
                catch (ModuleLoadException e) {
                    throw LoggingLogger.ROOT_LOGGER.cannotLoadModule(e, moduleName, "handler", name);
                }
            } else {
                configuration = this.constructionProperties == null ? logContextConfiguration.addHandlerConfiguration(null, className, name, new String[0]) : logContextConfiguration.addHandlerConfiguration(null, className, name, this.constructionProperties);
                if (AsyncHandler.class.getName().equals(className)) {
                    configuration.setPropertyValueString("closeChildren", "false");
                }
            }
            return configuration;
        }
    }

    static class HandlerUpdateOperationStepHandler
    extends LoggingOperations.LoggingUpdateOperationStepHandler {
        HandlerUpdateOperationStepHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        @Override
        public final void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.handlerConfigurationNotFound(name));
            }
            AttributeDefinition[] attributes = this.getAttributes();
            if (attributes != null) {
                boolean restartRequired = false;
                boolean reloadRequired = false;
                for (AttributeDefinition attribute : attributes) {
                    if (!operation.has(attribute.getName())) continue;
                    HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration);
                    restartRequired = restartRequired || Logging.requiresRestart(attribute.getFlags());
                    reloadRequired = reloadRequired || Logging.requiresReload(attribute.getFlags());
                }
                if (restartRequired) {
                    context.restartRequired();
                } else if (reloadRequired) {
                    context.reloadRequired();
                }
            }
        }
    }
}

