/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments.resources;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.deployments.resources.LoggingConfigurationReadStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;

class LoggerResourceDefinition
extends SimpleResourceDefinition {
    static final String NAME = "logger";
    public static final PathElement PATH = PathElement.pathElement((String)"logger");
    static final SimpleAttributeDefinition LEVEL = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"level", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition HANDLER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"handler", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final SimpleListAttributeDefinition HANDLERS = ((SimpleListAttributeDefinition.Builder)SimpleListAttributeDefinition.Builder.of((String)"handlers", (AttributeDefinition)HANDLER).setStorageRuntime()).build();
    static final SimpleAttributeDefinition FILTER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"filter", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition USE_PARENT_HANDLERS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-parent-handlers", (ModelType)ModelType.BOOLEAN, (boolean)true).setStorageRuntime()).build();

    public LoggerResourceDefinition() {
        super(PATH, LoggingExtension.getResourceDescriptionResolver("deployment", NAME));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LEVEL, (OperationStepHandler)new LoggerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(LoggerConfiguration configuration, ModelNode model) {
                1.setModelValue(model, configuration.getLevel());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)FILTER, (OperationStepHandler)new LoggerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(LoggerConfiguration configuration, ModelNode model) {
                2.setModelValue(model, configuration.getFilter());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)HANDLERS, (OperationStepHandler)new LoggerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(LoggerConfiguration configuration, ModelNode model) {
                ModelNode handlers = model.setEmptyList();
                configuration.getHandlerNames().forEach(arg_0 -> ((ModelNode)handlers).add(arg_0));
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)USE_PARENT_HANDLERS, (OperationStepHandler)new LoggerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(LoggerConfiguration configuration, ModelNode model) {
                4.setModelValue(model, configuration.getUseParentHandlers());
            }
        });
    }

    static abstract class LoggerConfigurationReadStepHandler
    extends LoggingConfigurationReadStepHandler {
        LoggerConfigurationReadStepHandler() {
        }

        @Override
        protected void updateModel(LogContextConfiguration logContextConfiguration, String name, ModelNode model) {
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration("ROOT".equals(name) ? "" : name);
            this.updateModel(configuration, model);
        }

        protected abstract void updateModel(LoggerConfiguration var1, ModelNode var2);
    }
}

