/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.loggers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.filters.Filters;
import org.jboss.as.logging.loggers.LoggerResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;

final class LoggerOperations {
    static final OperationStepHandler REMOVE_LOGGER = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRemove(context, operation, model);
            if (model.hasDefined(CommonAttributes.FILTER_SPEC.getName())) {
                LoggerOperations.addRegisterFilterStep(context, CommonAttributes.FILTER_SPEC.resolveModelAttribute(context, model), true);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(context.getCurrentAddressValue());
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.loggerNotFound(loggerName));
            }
            logContextConfiguration.removeLoggerConfiguration(loggerName);
        }
    };
    static final OperationStepHandler ADD_HANDLER = new LoggerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.HANDLERS}){

        @Override
        public void updateModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode handlerName = operation.get(CommonAttributes.HANDLER_NAME.getName());
            ModelNode handlers = model.get(CommonAttributes.HANDLERS.getName()).clone();
            if (!handlers.isDefined()) {
                handlers.setEmptyList();
            }
            handlers.add(handlerName);
            CommonAttributes.HANDLERS.getValidator().validateParameter(CommonAttributes.HANDLERS.getName(), handlers);
            model.get(CommonAttributes.HANDLERS.getName()).add(handlerName);
            this.recordCapabilitiesAndRequirements(context, resource, (AttributeDefinition)CommonAttributes.HANDLERS, new ModelNode().setEmptyList().add(handlerName), new ModelNode());
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LoggerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            String handlerName = CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, operation).asString();
            String loggerName = LoggerOperations.getLogManagerLoggerName(name);
            if (configuration.getHandlerNames().contains(handlerName)) {
                LoggingLogger.ROOT_LOGGER.tracef("Handler %s is already assigned to logger %s", handlerName, loggerName);
            } else {
                LoggingLogger.ROOT_LOGGER.tracef("Adding handler '%s' to logger '%s' at '%s'", handlerName, LoggerOperations.getLogManagerLoggerName(loggerName), context.getCurrentAddress());
                configuration.addHandlerName(handlerName);
            }
        }
    };
    static final OperationStepHandler REMOVE_HANDLER = new LoggerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.HANDLERS}){

        @Override
        public void updateModel(OperationContext context, ModelNode operation, ModelNode model) {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            String handlerName = operation.get(CommonAttributes.HANDLER_NAME.getName()).asString();
            boolean found = false;
            List handlers = model.get(CommonAttributes.HANDLERS.getName()).asList();
            ArrayList<ModelNode> newHandlers = new ArrayList<ModelNode>(handlers.size());
            for (ModelNode handler : handlers) {
                if (handlerName.equals(handler.asString())) {
                    CommonAttributes.HANDLER.removeCapabilityRequirements(context, resource, new ModelNode().setEmptyList().add(handlerName));
                    found = true;
                    continue;
                }
                newHandlers.add(handler);
            }
            if (found) {
                model.get(CommonAttributes.HANDLERS.getName()).set(newHandlers);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LoggerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            configuration.removeHandlerName(CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, operation).asString());
        }
    };
    static final OperationStepHandler CHANGE_LEVEL = new LoggerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.LEVEL}){

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LoggerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, model, configuration);
        }
    };

    LoggerOperations() {
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LoggerConfiguration configuration) throws OperationFailedException {
        LoggerOperations.handleProperty(attribute, context, model, configuration, true);
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LoggerConfiguration configuration, boolean resolveValue) throws OperationFailedException {
        if (CommonAttributes.FILTER_SPEC.equals(attribute)) {
            ModelNode valueNode = resolveValue ? CommonAttributes.FILTER_SPEC.resolveModelAttribute(context, model) : model;
            String resolvedValue = valueNode.isDefined() ? valueNode.asString() : null;
            configuration.setFilter(resolvedValue);
        } else if (CommonAttributes.LEVEL.equals(attribute)) {
            String resolvedValue = resolveValue ? CommonAttributes.LEVEL.resolvePropertyValue(context, model) : CommonAttributes.LEVEL.resolver().resolveValue(context, model);
            configuration.setLevel(resolvedValue);
        } else if (CommonAttributes.HANDLERS.equals(attribute)) {
            Object resolvedValue = resolveValue ? CommonAttributes.HANDLERS.resolvePropertyValue(context, model) : (Collection)CommonAttributes.HANDLERS.resolver().resolveValue(context, model);
            configuration.setHandlerNames((Collection)resolvedValue);
        } else if (LoggerResourceDefinition.USE_PARENT_HANDLERS.equals(attribute)) {
            ModelNode useParentHandlers = resolveValue ? LoggerResourceDefinition.USE_PARENT_HANDLERS.resolveModelAttribute(context, model) : model;
            Boolean resolvedValue = useParentHandlers.isDefined() ? Boolean.valueOf(useParentHandlers.asBoolean()) : null;
            configuration.setUseParentHandlers(resolvedValue);
        }
    }

    private static String getLogManagerLoggerName(String name) {
        return name.equals("ROOT") ? "" : name;
    }

    private static void addRegisterFilterStep(OperationContext context, ModelNode filterSpec, boolean forRemove) {
        context.addStep((OperationStepHandler)new RegisterFilterOperationStepHandler(filterSpec.asString(), forRemove), OperationContext.Stage.MODEL);
    }

    private static class RegisterFilterOperationStepHandler
    implements OperationStepHandler {
        private final String filterSpec;
        private final boolean forRemove;

        private RegisterFilterOperationStepHandler(String filterSpec, boolean forRemove) {
            this.filterSpec = filterSpec;
            this.forRemove = forRemove;
        }

        public void execute(OperationContext context, ModelNode operation) {
            if (this.forRemove) {
                Filters.unregisterFilter(this.filterSpec, context.getCurrentAddress());
            } else {
                Filters.registerFilter(this.filterSpec, context.getCurrentAddress());
            }
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    if (forRemove) {
                        Filters.registerFilter(filterSpec, context.getCurrentAddress());
                    } else {
                        Filters.unregisterFilter(filterSpec, context.getCurrentAddress());
                    }
                }
            });
        }
    }

    static class LoggerWriteAttributeHandler
    extends LoggingOperations.LoggingWriteAttributeHandler {
        LoggerWriteAttributeHandler(AttributeDefinition[] attributes) {
            super(attributes);
        }

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(addressName);
            if (logContextConfiguration.getLoggerNames().contains(loggerName)) {
                LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
                if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, configuration, false);
                } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.FILTER_SPEC, context, value, configuration, false);
                } else if (CommonAttributes.FILTER_SPEC.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.FILTER_SPEC, context, value, configuration, false);
                } else if (CommonAttributes.HANDLERS.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.HANDLERS, context, value, configuration, false);
                } else if (LoggerResourceDefinition.USE_PARENT_HANDLERS.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)LoggerResourceDefinition.USE_PARENT_HANDLERS, context, value, configuration, false);
                }
            }
            return false;
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                String filterSpec = Filters.filterToFilterSpec(newValue);
                ModelNode filterSpecValue = filterSpec.isEmpty() ? new ModelNode() : new ModelNode(filterSpec);
                model.getModel().get(CommonAttributes.FILTER_SPEC.getName()).set(filterSpecValue);
            }
            if (CommonAttributes.FILTER_SPEC.getName().equals(attributeName)) {
                LoggerOperations.addRegisterFilterStep(context, newValue, !newValue.isDefined());
            }
        }
    }

    static final class LoggerAddOperationStepHandler
    extends LoggingOperations.LoggingAddOperationStepHandler {
        private final AttributeDefinition[] attributes;

        LoggerAddOperationStepHandler(AttributeDefinition[] attributes) {
            super(attributes);
            this.attributes = attributes;
        }

        @Override
        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            ModelNode model = Resource.Tools.readModel((Resource)resource);
            if (model.hasDefined(CommonAttributes.FILTER_SPEC.getName())) {
                LoggerOperations.addRegisterFilterStep(context, CommonAttributes.FILTER_SPEC.resolveModelAttribute(context, model), false);
            }
        }

        public void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                if (CommonAttributes.FILTER.equals(attribute)) {
                    ModelNode filter = CommonAttributes.FILTER.validateOperation(operation);
                    if (!filter.isDefined()) continue;
                    String value = Filters.filterToFilterSpec(filter);
                    model.get(CommonAttributes.FILTER_SPEC.getName()).set(value.isEmpty() ? new ModelNode() : new ModelNode(value));
                    continue;
                }
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            String loggerName = LoggerOperations.getLogManagerLoggerName(name);
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
            if (configuration == null) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding logger '%s' at '%s'", name, context.getCurrentAddress());
                configuration = logContextConfiguration.addLoggerConfiguration(loggerName);
            }
            for (AttributeDefinition attribute : this.attributes) {
                LoggerOperations.handleProperty(attribute, context, model, configuration);
            }
        }
    }

    static abstract class LoggerUpdateOperationStepHandler
    extends LoggingOperations.LoggingUpdateOperationStepHandler {
        LoggerUpdateOperationStepHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        @Override
        public final void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(context.getCurrentAddressValue());
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.loggerConfigurationNotFound(loggerName));
            }
            this.performRuntime(context, operation, configuration, loggerName, model);
        }

        public abstract void performRuntime(OperationContext var1, ModelNode var2, LoggerConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;
    }
}

