/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.capabilities;

import java.util.ArrayList;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;

class LoggingProfileCapabilityRecorder
implements CapabilityReferenceRecorder {
    private final String dependentName;
    private final String requirementName;

    LoggingProfileCapabilityRecorder(String dependentName, String requirementName) {
        this.dependentName = dependentName;
        this.requirementName = requirementName;
    }

    public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        String dependentName = this.getDependentName(context);
        for (String value : attributeValues) {
            if (value == null) continue;
            context.registerAdditionalCapabilityRequirement(this.getRequirementName(context, value), dependentName, attributeName);
        }
    }

    public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        String dependentName = this.getDependentName(context);
        for (String value : attributeValues) {
            if (value == null) continue;
            context.deregisterCapabilityRequirement(this.getRequirementName(context, value), dependentName, attributeName);
        }
    }

    public String getBaseDependentName() {
        return this.dependentName;
    }

    public String getBaseRequirementName() {
        return this.requirementName;
    }

    public boolean isDynamicDependent() {
        return true;
    }

    public String[] getRequirementPatternSegments(String name, PathAddress address) {
        ArrayList<String> result = new ArrayList<String>(2);
        for (PathElement pathElement : address) {
            if (!"logging-profile".equals(pathElement.getKey())) continue;
            result.add(pathElement.getValue());
            break;
        }
        result.add(name);
        return result.toArray(new String[0]);
    }

    private String getDependentName(OperationContext context) {
        StringBuilder result = new StringBuilder(this.getBaseDependentName());
        for (String name : this.getRequirementPatternSegments(context.getCurrentAddressValue(), context.getCurrentAddress())) {
            result.append('.').append(name);
        }
        return result.toString();
    }

    private String getRequirementName(OperationContext context, String value) {
        StringBuilder result = new StringBuilder(this.getBaseRequirementName());
        for (String name : this.getRequirementPatternSegments(value, context.getCurrentAddress())) {
            result.append('.').append(name);
        }
        return result.toString();
    }
}

