/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.CustomFormatterResourceDefinition;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.LoggingRootResource;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.SyslogHandlerResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class LoggingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    static final LoggingSubsystemParser INSTANCE = new LoggingSubsystemParser();

    private LoggingSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"logging")});
        ModelNode subsystemAddOp = Util.createAddOperation((PathAddress)address);
        operations.add(subsystemAddOp);
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> formatterOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        HashSet<String> formatterNames = new HashSet<String>();
        boolean rootDefined = false;
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
            switch (namespace) {
                case LOGGING_1_0: 
                case LOGGING_1_1: 
                case LOGGING_1_2: 
                case LOGGING_1_3: 
                case LOGGING_1_4: 
                case LOGGING_2_0: 
                case LOGGING_3_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ADD_LOGGING_API_DEPENDENCIES: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                            LoggingRootResource.ADD_LOGGING_API_DEPENDENCIES.parseAndSetParameter(value, subsystemAddOp, (XMLStreamReader)reader);
                            continue block19;
                        }
                        case USE_DEPLOYMENT_LOGGING_CONFIG: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3 || namespace == Namespace.LOGGING_1_4) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                            LoggingRootResource.USE_DEPLOYMENT_LOGGING_CONFIG.parseAndSetParameter(value, subsystemAddOp, (XMLStreamReader)reader);
                            continue block19;
                        }
                        case LOGGER: {
                            LoggingSubsystemParser.parseLoggerElement(reader, address, loggerOperations, loggerNames);
                            continue block19;
                        }
                        case ROOT_LOGGER: {
                            if (rootDefined) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            rootDefined = true;
                            LoggingSubsystemParser.parseRootLoggerElement(reader, address, loggerOperations);
                            continue block19;
                        }
                        case CONSOLE_HANDLER: {
                            LoggingSubsystemParser.parseConsoleHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block19;
                        }
                        case FILE_HANDLER: {
                            LoggingSubsystemParser.parseFileHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block19;
                        }
                        case CUSTOM_HANDLER: {
                            if (namespace == Namespace.LOGGING_1_0) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            LoggingSubsystemParser.parseCustomHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block19;
                        }
                        case PERIODIC_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parsePeriodicRotatingFileHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block19;
                        }
                        case PERIODIC_SIZE_ROTATING_FILE_HANDLER: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3 || namespace == Namespace.LOGGING_1_4 || namespace == Namespace.LOGGING_2_0) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            LoggingSubsystemParser.parsePeriodicSizeRotatingHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block19;
                        }
                        case SIZE_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parseSizeRotatingHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block19;
                        }
                        case ASYNC_HANDLER: {
                            LoggingSubsystemParser.parseAsyncHandlerElement(reader, address, asyncHandlerOperations, handlerNames);
                            continue block19;
                        }
                        case SYSLOG_HANDLER: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            LoggingSubsystemParser.parseSyslogHandler(reader, address, handlerOperations, handlerNames);
                            continue block19;
                        }
                        case LOGGING_PROFILES: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            LoggingSubsystemParser.parseLoggingProfilesElement(reader, address, operations);
                            continue block19;
                        }
                        case FORMATTER: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            LoggingSubsystemParser.parseFormatter(reader, address, formatterOperations, formatterNames);
                            continue block19;
                        }
                    }
                    reader.handleAny(operations);
                    continue block19;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.addAll(formatterOperations);
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }

    private static void parseLoggerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CATEGORY);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CATEGORY: {
                    name = value;
                    continue block9;
                }
                case USE_PARENT_HANDLERS: {
                    LoggerResourceDefinition.USE_PARENT_HANDLERS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "logger", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case HANDLERS: {
                    LoggingSubsystemParser.parseHandlersElement(operation.get(CommonAttributes.HANDLERS.getName()), reader);
                    continue block10;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(operation, reader, element);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseAsyncHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "async-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case SUBHANDLERS: {
                    LoggingSubsystemParser.parseHandlersElement(operation.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()), reader);
                    continue block13;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(operation, reader, element);
                    continue block13;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, operation);
                    continue block13;
                }
                case QUEUE_LENGTH: {
                    AsyncHandlerResourceDefinition.QUEUE_LENGTH.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case OVERFLOW_ACTION: {
                    AsyncHandlerResourceDefinition.OVERFLOW_ACTION.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader).toUpperCase(Locale.US), operation, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseRootLoggerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address.append("root-logger", "ROOT"));
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (encountered.contains((Object)element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
            }
            encountered.add(element);
            switch (element) {
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(operation, reader, element);
                    continue block5;
                }
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case HANDLERS: {
                    LoggingSubsystemParser.parseHandlersElement(operation.get(CommonAttributes.HANDLERS.getName()), reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseConsoleHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "console-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(operation, reader, element);
                    continue block13;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, operation);
                    continue block13;
                }
                case TARGET: {
                    String target = LoggingSubsystemParser.readNameAttribute(reader);
                    ConsoleHandlerResourceDefinition.TARGET.parseAndSetParameter(target, operation, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseFileHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(operation, reader, element);
                    continue block14;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, operation);
                    continue block14;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block14;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        operations.add(operation);
    }

    private static void parseCustomHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CLASS, Attribute.MODULE);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case CLASS: {
                    CommonAttributes.CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case MODULE: {
                    CommonAttributes.MODULE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "custom-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(operation, reader, element);
                    continue block14;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, operation);
                    continue block14;
                }
                case PROPERTIES: {
                    LoggingSubsystemParser.parsePropertyElement(operation, reader);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parsePeriodicRotatingFileHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block14;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "periodic-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE, Element.SUFFIX);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block15: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(operation, reader, element);
                    continue block15;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, operation);
                    continue block15;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block15;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case SUFFIX: {
                    PeriodicHandlerResourceDefinition.SUFFIX.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        operations.add(operation);
    }

    private static void parsePeriodicSizeRotatingHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block17;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ROTATE_ON_BOOT: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "periodic-size-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block18: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case FILTER_SPEC: {
                    LoggingSubsystemParser.parseFilter(operation, reader, element);
                    continue block18;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, operation);
                    continue block18;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block18;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case ROTATE_SIZE: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case MAX_BACKUP_INDEX: {
                    SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case SUFFIX: {
                    PeriodicHandlerResourceDefinition.SUFFIX.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseSizeRotatingHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block17;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ROTATE_ON_BOOT: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "size-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block18: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(operation, reader, element);
                    continue block18;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, operation);
                    continue block18;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block18;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case ROTATE_SIZE: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case MAX_BACKUP_INDEX: {
                    SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case SUFFIX: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3 || namespace == Namespace.LOGGING_1_4 || namespace == Namespace.LOGGING_2_0) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    SizeRotatingHandlerResourceDefinition.SUFFIX.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseSyslogHandler(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block16;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "syslog-handler", name);
        EnumSet<Element> requiredElem = EnumSet.noneOf(Element.class);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block17: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case APP_NAME: {
                    SyslogHandlerResourceDefinition.APP_NAME.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case FACILITY: {
                    SyslogHandlerResourceDefinition.FACILITY.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case HOSTNAME: {
                    SyslogHandlerResourceDefinition.HOSTNAME.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case FORMATTER: {
                    if (reader.nextTag() != 1) {
                        throw new XMLStreamException(LoggingLogger.ROOT_LOGGER.missingRequiredNestedFilterElement(), reader.getLocation());
                    }
                    switch (Element.forName(reader.getLocalName())) {
                        case SYSLOG_FORMATTER: {
                            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.SYSLOG_TYPE.getLocalName());
                            operation.get(SyslogHandlerResourceDefinition.SYSLOG_FORMATTER.getName()).set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.SYSLOG_TYPE.getLocalName()));
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block17;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case PORT: {
                    SyslogHandlerResourceDefinition.PORT.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case SERVER_ADDRESS: {
                    SyslogHandlerResourceDefinition.SERVER_ADDRESS.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseFileElement(ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    PathResourceDefinition.PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PathResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseFormatter(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block8: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PATTERN_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser.addOperationAddress(operation, address, PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName(), name);
                    LoggingSubsystemParser.parsePatternFormatterElement(reader, operation);
                    operations.add(operation);
                    continue block8;
                }
                case CUSTOM_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser.addOperationAddress(operation, address, CustomFormatterResourceDefinition.CUSTOM_FORMATTER.getName(), name);
                    LoggingSubsystemParser.parseCustomFormatterElement(reader, operation);
                    operations.add(operation);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseHandlerFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        boolean formatterDefined = false;
        block4: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PATTERN_FORMATTER: {
                    if (formatterDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName());
                    formatterDefined = true;
                    AbstractHandlerDefinition.FORMATTER.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName()), operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case NAMED_FORMATTER: {
                    if (formatterDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    formatterDefined = true;
                    AbstractHandlerDefinition.NAMED_FORMATTER.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parsePatternFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    PatternFormatterResourceDefinition.PATTERN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case COLOR_MAP: {
                    PatternFormatterResourceDefinition.COLOR_MAP.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseCustomFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CLASS, Attribute.MODULE);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLASS: {
                    CommonAttributes.CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                case MODULE: {
                    CommonAttributes.MODULE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block8: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    LoggingSubsystemParser.parsePropertyElement(operation, reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parsePropertyElement(ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            int cnt = reader.getAttributeCount();
            String name = null;
            String value = null;
            block5: for (int i = 0; i < cnt; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block5;
                    }
                    case VALUE: {
                        value = attrValue;
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
            }
            operation.get(CommonAttributes.PROPERTIES.getName()).add(name, new ModelNode(value));
            if (reader.nextTag() == 2) continue;
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseHandlersElement(ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HANDLER: {
                    operation.add(LoggingSubsystemParser.readNameAttribute(reader));
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseLoggingProfilesElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations) throws XMLStreamException {
        HashSet<String> profileNames = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGING_PROFILE: {
                    LoggingSubsystemParser.parseLoggingProfileElement(reader, address, operations, profileNames);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseLoggingProfileElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> profileNames) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!profileNames.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        PathAddress profileAddress = address.append("logging-profile", name);
        operations.add(Util.createAddOperation((PathAddress)profileAddress));
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> formatterOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        HashSet<String> formatterNames = new HashSet<String>();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        boolean gotRoot = false;
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGER: {
                    LoggingSubsystemParser.parseLoggerElement(reader, profileAddress, loggerOperations, loggerNames);
                    continue block16;
                }
                case ROOT_LOGGER: {
                    if (gotRoot) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    gotRoot = true;
                    LoggingSubsystemParser.parseRootLoggerElement(reader, profileAddress, loggerOperations);
                    continue block16;
                }
                case CONSOLE_HANDLER: {
                    LoggingSubsystemParser.parseConsoleHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case FILE_HANDLER: {
                    LoggingSubsystemParser.parseFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case CUSTOM_HANDLER: {
                    LoggingSubsystemParser.parseCustomHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    LoggingSubsystemParser.parsePeriodicRotatingFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    LoggingSubsystemParser.parseSizeRotatingHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case ASYNC_HANDLER: {
                    LoggingSubsystemParser.parseAsyncHandlerElement(reader, profileAddress, asyncHandlerOperations, handlerNames);
                    continue block16;
                }
                case SYSLOG_HANDLER: {
                    LoggingSubsystemParser.parseSyslogHandler(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case FORMATTER: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    LoggingSubsystemParser.parseFormatter(reader, profileAddress, formatterOperations, formatterNames);
                    continue block16;
                }
            }
            reader.handleAny(operations);
        }
        operations.addAll(formatterOperations);
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }

    private static void parseFilter(ModelNode operation, XMLExtendedStreamReader reader, Element element) throws XMLStreamException {
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
            if (element == Element.FILTER_SPEC) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (reader.getAttributeCount() > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            StringBuilder filter = new StringBuilder();
            LoggingSubsystemParser.parseFilterChildren(filter, false, reader);
            operation.get(CommonAttributes.FILTER_SPEC.getName()).set(filter.toString());
        } else {
            CommonAttributes.FILTER_SPEC.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName()), operation, (XMLStreamReader)reader);
        }
    }

    private static void parseFilterChildren(StringBuilder filter, boolean useDelimiter, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        int delimiter = 44;
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPT: {
                    filter.append("accept");
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                case ALL: {
                    filter.append("all").append('(');
                    LoggingSubsystemParser.parseFilterChildren(filter, true, reader);
                    int index = filter.length() - 1;
                    if (filter.charAt(index) == ',') {
                        filter.setCharAt(index, ')');
                        break;
                    }
                    filter.append(')');
                    break;
                }
                case ANY: {
                    filter.append("any").append('(');
                    LoggingSubsystemParser.parseFilterChildren(filter, true, reader);
                    int index = filter.length() - 1;
                    if (filter.charAt(index) == ',') {
                        filter.setCharAt(index, ')');
                        break;
                    }
                    filter.append(')');
                    break;
                }
                case CHANGE_LEVEL: {
                    filter.append("levelChange").append('(').append(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.NEW_LEVEL.getName())).append(')');
                    break;
                }
                case DENY: {
                    filter.append("deny");
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                case LEVEL: {
                    filter.append("levels").append('(').append(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.NAME.getName())).append(')');
                    break;
                }
                case LEVEL_RANGE: {
                    filter.append("levelRange");
                    boolean minInclusive = Boolean.parseBoolean(reader.getAttributeValue(null, CommonAttributes.MIN_INCLUSIVE.getName()));
                    boolean maxInclusive = Boolean.parseBoolean(reader.getAttributeValue(null, CommonAttributes.MAX_INCLUSIVE.getName()));
                    if (minInclusive) {
                        filter.append('[');
                    } else {
                        filter.append('(');
                    }
                    filter.append(reader.getAttributeValue(null, CommonAttributes.MIN_LEVEL.getName())).append(',');
                    filter.append(reader.getAttributeValue(null, CommonAttributes.MAX_LEVEL.getName()));
                    if (maxInclusive) {
                        filter.append(']');
                    } else {
                        filter.append(')');
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                case MATCH: {
                    filter.append("match").append("(\"").append(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.FILTER_PATTERN.getName())).append("\")");
                    break;
                }
                case NOT: {
                    filter.append("not").append('(');
                    LoggingSubsystemParser.parseFilterChildren(filter, true, reader);
                    int index = filter.length() - 1;
                    if (filter.charAt(index) == ',') {
                        filter.setCharAt(index, ')');
                        break;
                    }
                    filter.append(')');
                    break;
                }
                case REPLACE: {
                    boolean replaceAll = Boolean.valueOf(reader.getAttributeValue(null, CommonAttributes.REPLACE_ALL.getName()));
                    if (replaceAll) {
                        filter.append("substituteAll");
                    } else {
                        filter.append("substitute");
                    }
                    filter.append("(\"").append(reader.getAttributeValue(null, CommonAttributes.FILTER_PATTERN.getName())).append('\"').append(',').append('\"').append(reader.getAttributeValue(null, CommonAttributes.REPLACEMENT.getName())).append("\")");
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            if (!useDelimiter) continue;
            filter.append(',');
        }
    }

    private static void addOperationAddress(ModelNode operation, PathAddress base, String key, String value) {
        operation.get("address").set(base.append(key, value).toModelNode());
    }

    private static String readNameAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        return ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
    }

    private static String readValueAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        return ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
    }
}

