/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.CustomFormatterResourceDefinition;
import org.jboss.as.logging.CustomHandlerResourceDefinition;
import org.jboss.as.logging.FileHandlerResourceDefinition;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.LoggingProfileOperations;
import org.jboss.as.logging.LoggingRootResource;
import org.jboss.as.logging.LoggingSubsystemParser;
import org.jboss.as.logging.LoggingSubsystemWriter;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.PeriodicSizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.RootLoggerResourceDefinition;
import org.jboss.as.logging.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.SyslogHandlerResourceDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.logmanager.WildFlyLogContextSelector;
import org.jboss.as.logging.stdio.LogContextStdioContextSelector;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.LogManager;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public class LoggingExtension
implements Extension {
    private static final String RESOURCE_NAME = LoggingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String SUBSYSTEM_NAME = "logging";
    static final PathElement LOGGING_PROFILE_PATH = PathElement.pathElement((String)"logging-profile");
    static final WildFlyLogContextSelector CONTEXT_SELECTOR = WildFlyLogContextSelector.Factory.create();
    static final GenericSubsystemDescribeHandler DESCRIBE_HANDLER = GenericSubsystemDescribeHandler.create((Comparator)LoggingChildResourceComparator.INSTANCE);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 3;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ModuleIdentifier[] LOGGING_API_MODULES = new ModuleIdentifier[]{ModuleIdentifier.create((String)"org.apache.commons.logging"), ModuleIdentifier.create((String)"org.apache.log4j"), ModuleIdentifier.create((String)"org.jboss.logging"), ModuleIdentifier.create((String)"org.jboss.logging.jul-to-slf4j-stub"), ModuleIdentifier.create((String)"org.jboss.logmanager"), ModuleIdentifier.create((String)"org.slf4j"), ModuleIdentifier.create((String)"org.slf4j.ext"), ModuleIdentifier.create((String)"org.slf4j.impl")};

    static LoggingResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new LoggingResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, LoggingExtension.class.getClassLoader());
    }

    static StandardResourceDescriptionResolver getStandardResourceDescriptionResolver() {
        return new StandardResourceDescriptionResolver(SUBSYSTEM_NAME, RESOURCE_NAME, LoggingExtension.class.getClassLoader());
    }

    public void initialize(ExtensionContext context) {
        ResolvePathHandler resolvePathHandler;
        LoggingRootResource rootResource;
        if (!java.util.logging.LogManager.getLogManager().getClass().getName().equals(LogManager.class.getName())) {
            throw LoggingLogger.ROOT_LOGGER.extensionNotInitialized();
        }
        LogContext.setLogContextSelector((LogContextSelector)CONTEXT_SELECTOR);
        StdioContext.setStdioContextSelector((StdioContextSelector)new LogContextStdioContextSelector(StdioContext.getStdioContext()));
        try {
            ModuleLoader moduleLoader = Module.forClass(LoggingExtension.class).getModuleLoader();
            for (ModuleIdentifier moduleIdentifier : LOGGING_API_MODULES) {
                try {
                    CONTEXT_SELECTOR.addLogApiClassLoader((ClassLoader)moduleLoader.loadModule(moduleIdentifier).getClassLoader());
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 3, 0, 0);
        if (context.getProcessType().isServer()) {
            rootResource = new LoggingRootResource(context.getPathManager());
            resolvePathHandler = ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setParentAttribute((AttributeDefinition)CommonAttributes.FILE).build();
        } else {
            rootResource = new LoggingRootResource(null);
            resolvePathHandler = null;
        }
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)rootResource);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)DESCRIBE_HANDLER);
        this.registerSubModels(registration, resolvePathHandler, true, subsystem, rootResource, context.isRegisterTransformers());
        ApplicationTypeConfig atc = new ApplicationTypeConfig(SUBSYSTEM_NAME, "logging-profile");
        final List accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
        SimpleResourceDefinition profile = new SimpleResourceDefinition(LOGGING_PROFILE_PATH, (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver(new String[0]), LoggingProfileOperations.ADD_PROFILE, LoggingProfileOperations.REMOVE_PROFILE){

            public List<AccessConstraintDefinition> getAccessConstraints() {
                return accessConstraints;
            }
        };
        this.registerLoggingProfileSubModels(registration.registerSubModel((ResourceDefinition)profile), resolvePathHandler);
        subsystem.registerXMLElementWriter((XMLElementWriter)LoggingSubsystemWriter.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.readable()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUriString(), (XMLElementReader)LoggingSubsystemParser.INSTANCE);
        }
    }

    private void registerLoggingProfileSubModels(ManagementResourceRegistration registration, ResolvePathHandler resolvePathHandler) {
        this.registerSubModels(registration, resolvePathHandler, false, null, null, false);
    }

    private void registerSubModels(ManagementResourceRegistration registration, ResolvePathHandler resolvePathHandler, boolean includeLegacyAttributes, SubsystemRegistration subsystem, LoggingRootResource subsystemResourceDefinition, boolean registerTransformers) {
        RootLoggerResourceDefinition rootLoggerResourceDefinition = new RootLoggerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)rootLoggerResourceDefinition);
        LoggerResourceDefinition loggerResourceDefinition = new LoggerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)loggerResourceDefinition);
        AsyncHandlerResourceDefinition asyncHandlerResourceDefinition = new AsyncHandlerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)asyncHandlerResourceDefinition);
        ConsoleHandlerResourceDefinition consoleHandlerResourceDefinition = new ConsoleHandlerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)consoleHandlerResourceDefinition);
        FileHandlerResourceDefinition fileHandlerResourceDefinition = new FileHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)fileHandlerResourceDefinition);
        PeriodicHandlerResourceDefinition periodicHandlerResourceDefinition = new PeriodicHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)periodicHandlerResourceDefinition);
        PeriodicSizeRotatingHandlerResourceDefinition periodicSizeRotatingHandlerResourceDefinition = new PeriodicSizeRotatingHandlerResourceDefinition(resolvePathHandler);
        registration.registerSubModel((ResourceDefinition)periodicSizeRotatingHandlerResourceDefinition);
        SizeRotatingHandlerResourceDefinition sizeRotatingHandlerResourceDefinition = new SizeRotatingHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)sizeRotatingHandlerResourceDefinition);
        CustomHandlerResourceDefinition customHandlerResourceDefinition = new CustomHandlerResourceDefinition(includeLegacyAttributes);
        registration.registerSubModel((ResourceDefinition)customHandlerResourceDefinition);
        registration.registerSubModel((ResourceDefinition)SyslogHandlerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)PatternFormatterResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)CustomFormatterResourceDefinition.INSTANCE);
        if (registerTransformers) {
            this.registerTransformers(subsystem, subsystemResourceDefinition, rootLoggerResourceDefinition, loggerResourceDefinition, asyncHandlerResourceDefinition, consoleHandlerResourceDefinition, fileHandlerResourceDefinition, periodicHandlerResourceDefinition, periodicSizeRotatingHandlerResourceDefinition, sizeRotatingHandlerResourceDefinition, customHandlerResourceDefinition, SyslogHandlerResourceDefinition.INSTANCE, PatternFormatterResourceDefinition.INSTANCE, CustomFormatterResourceDefinition.INSTANCE);
        }
    }

    private void registerTransformers(SubsystemRegistration registration, TransformerResourceDefinition ... defs) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getSubsystemVersion());
        this.registerTransformers(chainedBuilder, registration.getSubsystemVersion(), KnownModelVersion.VERSION_1_3_0, defs);
        this.registerTransformers(chainedBuilder, KnownModelVersion.VERSION_1_3_0, KnownModelVersion.VERSION_1_2_0, defs);
        this.registerTransformers(chainedBuilder, KnownModelVersion.VERSION_1_2_0, KnownModelVersion.VERSION_1_1_0, defs);
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{KnownModelVersion.VERSION_1_1_0.getModelVersion(), KnownModelVersion.VERSION_1_2_0.getModelVersion(), KnownModelVersion.VERSION_1_3_0.getModelVersion()}});
    }

    private void registerTransformers(ChainedTransformationDescriptionBuilder chainedBuilder, KnownModelVersion fromVersion, KnownModelVersion toVersion, TransformerResourceDefinition ... defs) {
        this.registerTransformers(chainedBuilder, fromVersion.getModelVersion(), toVersion, defs);
    }

    private void registerTransformers(ChainedTransformationDescriptionBuilder chainedBuilder, ModelVersion fromVersion, KnownModelVersion toVersion, TransformerResourceDefinition ... defs) {
        ResourceTransformationDescriptionBuilder loggingProfileBuilder;
        ResourceTransformationDescriptionBuilder subsystemBuilder = chainedBuilder.createBuilder(fromVersion, toVersion.getModelVersion());
        if (toVersion == KnownModelVersion.VERSION_1_1_0) {
            subsystemBuilder.rejectChildResource(LOGGING_PROFILE_PATH);
            loggingProfileBuilder = null;
        } else {
            loggingProfileBuilder = subsystemBuilder.addChildResource(LOGGING_PROFILE_PATH);
        }
        for (TransformerResourceDefinition def : defs) {
            def.registerTransformers(toVersion, subsystemBuilder, loggingProfileBuilder);
        }
    }

    public static class LoggingChildResourceComparator
    implements Comparator<PathElement> {
        static final LoggingChildResourceComparator INSTANCE = new LoggingChildResourceComparator();
        static final int GREATER = 1;
        static final int EQUAL = 0;
        static final int LESS = -1;

        @Override
        public int compare(PathElement o1, PathElement o2) {
            String key2;
            String key1 = o1.getKey();
            int result = key1.compareTo(key2 = o2.getKey());
            if (result != 0) {
                if ("subsystem".equals(key1)) {
                    result = -1;
                } else if ("subsystem".equals(key2)) {
                    result = 1;
                } else if ("logging-profile".equals(key1)) {
                    result = -1;
                } else if ("logging-profile".equals(key2)) {
                    result = 1;
                } else if (PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName().equals(key1)) {
                    result = -1;
                } else if (PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName().equals(key2)) {
                    result = 1;
                } else if (CustomFormatterResourceDefinition.CUSTOM_FORMATTER.getName().equals(key1)) {
                    result = -1;
                } else if (CustomFormatterResourceDefinition.CUSTOM_FORMATTER.getName().equals(key2)) {
                    result = 1;
                } else if ("root-logger".equals(key1)) {
                    result = 1;
                } else if ("root-logger".equals(key2)) {
                    result = -1;
                } else if ("logger".equals(key1)) {
                    result = 1;
                } else if ("logger".equals(key2)) {
                    result = -1;
                } else if ("async-handler".equals(key1)) {
                    result = 1;
                } else if ("async-handler".equals(key2)) {
                    result = -1;
                }
            }
            return result;
        }
    }

    private static class LoggingResourceDescriptionResolver
    extends StandardResourceDescriptionResolver {
        private static final Map<String, String> COMMON_ATTRIBUTE_NAMES = new HashMap<String, String>();

        public LoggingResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader) {
            super(keyPrefix, bundleBaseName, bundleLoader, true, false);
        }

        public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName.split("\\.")[0])) {
                return bundle.getString(this.getBundleKey(attributeName));
            }
            return super.getResourceAttributeDescription(attributeName, locale, bundle);
        }

        public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName)) {
                return bundle.getString(this.getVariableBundleKey(attributeName, suffixes));
            }
            return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle, suffixes);
        }

        public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                return bundle.getString(this.getBundleKey(paramName));
            }
            return super.getOperationParameterDescription(operationName, paramName, locale, bundle);
        }

        public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                return bundle.getString(this.getVariableBundleKey(paramName, suffixes));
            }
            return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle, suffixes);
        }

        public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                if (this.isReuseAttributesForAdd()) {
                    return bundle.getString(this.getVariableBundleKey(paramName, "deprecated"));
                }
                return bundle.getString(this.getVariableBundleKey(operationName, paramName, "deprecated"));
            }
            return super.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle);
        }

        public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName)) {
                return bundle.getString(this.getVariableBundleKey(attributeName, "deprecated"));
            }
            return super.getResourceAttributeDeprecatedDescription(attributeName, locale, bundle);
        }

        private String getBundleKey(String name) {
            return this.getVariableBundleKey(name, new String[0]);
        }

        private String getVariableBundleKey(String name, String ... variable) {
            String prefix = COMMON_ATTRIBUTE_NAMES.get(name.split("\\.")[0]);
            StringBuilder sb = prefix == null ? new StringBuilder(name) : new StringBuilder(prefix).append('.').append(name);
            if (variable != null) {
                for (String arg : variable) {
                    if (sb.length() > 0) {
                        sb.append('.');
                    }
                    sb.append(arg);
                }
            }
            return sb.toString();
        }

        static {
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.APPEND.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.AUTOFLUSH.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.CLASS.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.ENABLED.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.ENCODING.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILE.getName(), "logging.handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILTER.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILTER_SPEC.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(AbstractHandlerDefinition.FORMATTER.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.HANDLERS.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.LEVEL.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.MODULE.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.NAME.getName(), "logging.handler");
            COMMON_ATTRIBUTE_NAMES.put(AbstractHandlerDefinition.NAMED_FORMATTER.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(AsyncHandlerResourceDefinition.OVERFLOW_ACTION.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(PathResourceDefinition.PATH.getName(), null);
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.PROPERTIES.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(AsyncHandlerResourceDefinition.QUEUE_LENGTH.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(PathResourceDefinition.RELATIVE_TO.getName(), null);
            COMMON_ATTRIBUTE_NAMES.put(SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(AsyncHandlerResourceDefinition.SUBHANDLERS.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(PeriodicHandlerResourceDefinition.SUFFIX.getName(), "logging.periodic-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(ConsoleHandlerResourceDefinition.TARGET.getName(), "logging.console-handler");
        }
    }
}

