/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logmanager;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.logging.logmanager.WildFlyLogContextSelector;
import org.jboss.logmanager.ClassLoaderLogContextSelector;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.ThreadLocalLogContextSelector;

class WildFlyLogContextSelectorImpl
implements WildFlyLogContextSelector {
    private final ClassLoaderLogContextSelector contextSelector;
    private final ThreadLocalLogContextSelector threadLocalContextSelector;
    private final AtomicInteger counter = new AtomicInteger(0);

    public WildFlyLogContextSelectorImpl() {
        this.contextSelector = new ClassLoaderLogContextSelector(true);
        this.threadLocalContextSelector = new ThreadLocalLogContextSelector((LogContextSelector)this.contextSelector);
    }

    public LogContext getLogContext() {
        return this.threadLocalContextSelector.getLogContext();
    }

    @Override
    public LogContext getAndSet(Object securityKey, LogContext newValue) {
        return this.threadLocalContextSelector.getAndSet(securityKey, newValue);
    }

    @Override
    public void registerLogContext(ClassLoader classLoader, LogContext logContext) {
        this.contextSelector.registerLogContext(classLoader, logContext);
        this.counter.incrementAndGet();
    }

    @Override
    public boolean unregisterLogContext(ClassLoader classLoader, LogContext logContext) {
        if (this.contextSelector.unregisterLogContext(classLoader, logContext)) {
            this.counter.decrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public boolean addLogApiClassLoader(ClassLoader apiClassLoader) {
        return this.contextSelector.addLogApiClassLoader(apiClassLoader);
    }

    @Override
    public boolean removeLogApiClassLoader(ClassLoader apiClassLoader) {
        return this.contextSelector.removeLogApiClassLoader(apiClassLoader);
    }

    @Override
    public int registeredCount() {
        return this.counter.get();
    }
}

