/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.jmx.SecurityActions;
import org.jboss.remoting3.Channel;
import org.jboss.remotingjmx.ServerMessageInterceptor;
import org.jboss.remotingjmx.ServerMessageInterceptorFactory;
import org.wildfly.security.auth.server.SecurityIdentity;

class ServerInterceptorFactory
implements ServerMessageInterceptorFactory {
    ServerInterceptorFactory() {
    }

    public ServerMessageInterceptor create(Channel channel) {
        return new Interceptor(channel);
    }

    private static class Interceptor
    implements ServerMessageInterceptor {
        private final Channel channel;

        private Interceptor(Channel channel) {
            this.channel = channel;
        }

        public void handleEvent(final ServerMessageInterceptor.Event event) throws IOException {
            SecurityIdentity localIdentity = this.channel.getConnection().getLocalIdentity();
            InetSocketAddress peerSocketAddress = (InetSocketAddress)this.channel.getConnection().getPeerAddress(InetSocketAddress.class);
            InetAddress remoteAddress = peerSocketAddress != null ? peerSocketAddress.getAddress() : null;
            try {
                AccessAuditContext.doAs((SecurityIdentity)localIdentity, (InetAddress)remoteAddress, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        SecurityActions.currentAccessAuditContext().setAccessMechanism(AccessMechanism.JMX);
                        event.run();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IOException(cause);
            }
        }
    }
}

