/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.RemotingConnectorAdd;
import org.jboss.as.jmx.RemotingConnectorRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RemotingConnectorResource
extends SimpleResourceDefinition {
    static final PathElement REMOTE_CONNECTOR_CONFIG_PATH = PathElement.pathElement((String)"remoting-connector", (String)"jmx");
    static final SimpleAttributeDefinition USE_MANAGEMENT_ENDPOINT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-management-endpoint", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    static final String REMOTING_CAPABILITY = "org.wildfly.remoting.endpoint";
    static final RuntimeCapability<Void> REMOTE_JMX_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.management.jmx.remote").addRequirements(new String[]{"org.wildfly.management.jmx"}).build();
    static final RemotingConnectorResource INSTANCE = new RemotingConnectorResource();

    private RemotingConnectorResource() {
        super(new SimpleResourceDefinition.Parameters(REMOTE_CONNECTOR_CONFIG_PATH, JMXExtension.getResourceDescriptionResolver("remoting-connector")).setAddHandler((OperationStepHandler)RemotingConnectorAdd.INSTANCE).setRemoveHandler((OperationStepHandler)RemotingConnectorRemove.INSTANCE).setCapabilities(new RuntimeCapability[]{REMOTE_JMX_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(){

            protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
                super.recordCapabilitiesAndRequirements(context, attributeDefinition, newValue, oldValue);
                Boolean needRemoting = this.needRemoting(context, newValue);
                if (needRemoting != null) {
                    if (needRemoting.booleanValue()) {
                        context.registerAdditionalCapabilityRequirement(RemotingConnectorResource.REMOTING_CAPABILITY, REMOTE_JMX_CAPABILITY.getName(), USE_MANAGEMENT_ENDPOINT.getName());
                    } else {
                        context.deregisterCapabilityRequirement(RemotingConnectorResource.REMOTING_CAPABILITY, REMOTE_JMX_CAPABILITY.getName(), USE_MANAGEMENT_ENDPOINT.getName());
                    }
                }
            }

            private Boolean needRemoting(OperationContext context, ModelNode attributeValue) {
                ModelNode model = new ModelNode();
                model.get(USE_MANAGEMENT_ENDPOINT.getName()).set(attributeValue);
                try {
                    return !USE_MANAGEMENT_ENDPOINT.resolveModelAttribute(context, model).asBoolean();
                }
                catch (OperationFailedException ofe) {
                    if (model.get(USE_MANAGEMENT_ENDPOINT.getName()).getType() == ModelType.EXPRESSION) {
                        return null;
                    }
                    throw new IllegalStateException(ofe);
                }
            }
        };
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)USE_MANAGEMENT_ENDPOINT, null, (OperationStepHandler)writeHandler);
    }

    public void registerAdditionalRuntimePackages(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"org.jboss.remoting-jmx")});
    }
}

