/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.wildfly.core.jar.runtime._private.BootableJarLogger;

final class Arguments {
    private Boolean isHelp;
    private Boolean isVersion;
    private final List<String> serverArguments = new ArrayList<String>();
    private Path deployment;

    private Arguments() {
    }

    public static Arguments parseArguments(List<String> args) throws Exception {
        Objects.requireNonNull(args);
        Arguments arguments = new Arguments();
        arguments.handleArguments(args);
        return arguments;
    }

    private void handleArguments(List<String> args) throws Exception {
        for (String a : args) {
            if (a.startsWith("--deployment")) {
                this.deployment = this.checkPath(Arguments.getValue(a));
                continue;
            }
            if (a.startsWith("-b")) {
                this.serverArguments.add(a);
                continue;
            }
            if ("--properties".equals(a)) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("-S")) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("-D")) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("--start-mode")) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("-u")) {
                this.serverArguments.add(a);
                continue;
            }
            if ("--version".equals(a)) {
                this.isVersion = true;
                this.serverArguments.add(a);
                continue;
            }
            if ("--help".equals(a)) {
                this.isHelp = true;
                continue;
            }
            throw BootableJarLogger.ROOT_LOGGER.unknownArgument(a);
        }
    }

    private Path checkPath(String path) {
        Path filePath = Paths.get(path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw BootableJarLogger.ROOT_LOGGER.notExistingFile(path);
        }
        return filePath;
    }

    private static String getValue(String arg) {
        int sep = arg.indexOf("=");
        if (sep == -1 || sep == arg.length() - 1) {
            throw BootableJarLogger.ROOT_LOGGER.invalidArgument(arg);
        }
        return arg.substring(sep + 1);
    }

    public Boolean isHelp() {
        return this.isHelp == null ? false : this.isHelp;
    }

    public Boolean isVersion() {
        return this.isVersion == null ? false : this.isVersion;
    }

    public List<String> getServerArguments() {
        return Collections.unmodifiableList(this.serverArguments);
    }

    public Path getDeployment() {
        return this.deployment;
    }
}

