/*
 * Decompiled with CFR 0.152.
 */
package __redirected;

import __redirected.ConstructorSupplier;
import __redirected.__RedirectedUtils;
import java.util.function.Supplier;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    static final ClassLoader SAFE_CL;

    JDKSpecific() {
    }

    static Supplier<DatatypeFactory> getPlatformDatatypeFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            Supplier<DatatypeFactory> supplier = JDKSpecific.getConstructorSupplier(DatatypeFactory.newInstance());
            return supplier;
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException("Problem configuring DatatypeFactory", e);
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static Supplier<DocumentBuilderFactory> getPlatformDocumentBuilderFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            Supplier<DocumentBuilderFactory> supplier = JDKSpecific.getConstructorSupplier(DocumentBuilderFactory.newInstance());
            return supplier;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static Supplier<SAXParserFactory> getPlatformSaxParserFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            Supplier<SAXParserFactory> supplier = JDKSpecific.getConstructorSupplier(SAXParserFactory.newInstance());
            return supplier;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static Supplier<SchemaFactory> getPlatformSchemaFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            Supplier<SchemaFactory> supplier = JDKSpecific.getConstructorSupplier(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema"));
            return supplier;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static Supplier<TransformerFactory> getPlatformSaxTransformerFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            Supplier<TransformerFactory> supplier = JDKSpecific.getConstructorSupplier(TransformerFactory.newInstance());
            return supplier;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static Supplier<XMLEventFactory> getPlatformXmlEventFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            Supplier<XMLEventFactory> supplier = JDKSpecific.getConstructorSupplier(XMLEventFactory.newInstance());
            return supplier;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static Supplier<XMLInputFactory> getPlatformXmlInputFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            Supplier<XMLInputFactory> supplier = JDKSpecific.getConstructorSupplier(XMLInputFactory.newInstance());
            return supplier;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static Supplier<XMLOutputFactory> getPlatformXmlOutputFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            Supplier<XMLOutputFactory> supplier = JDKSpecific.getConstructorSupplier(XMLOutputFactory.newInstance());
            return supplier;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static Supplier<XMLReader> getPlatformXmlReaderSupplier() {
        final SAXParserFactory parserFactory = JDKSpecific.getPlatformSaxParserFactorySupplier().get();
        return new Supplier<XMLReader>(){

            @Override
            public XMLReader get() {
                try {
                    return parserFactory.newSAXParser().getXMLReader();
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw __RedirectedUtils.wrapped(new RuntimeException(e.getMessage()), e);
                }
            }
        };
    }

    static Supplier<XPathFactory> getPlatformXPathFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            Supplier<XPathFactory> supplier = JDKSpecific.getConstructorSupplier(XPathFactory.newInstance());
            return supplier;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    private static <T> Supplier<T> getConstructorSupplier(T factory) {
        try {
            return new ConstructorSupplier(factory.getClass().getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw __RedirectedUtils.wrapped(new NoSuchMethodError(e.getMessage()), e);
        }
    }

    static {
        ClassLoader safeClassLoader = JDKSpecific.class.getClassLoader();
        if (safeClassLoader == null) {
            safeClassLoader = ClassLoader.getSystemClassLoader();
        }
        if (safeClassLoader == null) {
            safeClassLoader = new ClassLoader(){};
        }
        SAFE_CL = safeClassLoader;
    }
}

