/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.boot;

import __redirected.__JAXPRedirected;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Policy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.jar.boot.BootablePolicy;
import org.wildfly.core.jar.boot.RuntimeExtension;

public final class Main {
    private static final String SYSPROP_KEY_CLASS_PATH = "java.class.path";
    private static final String SYSPROP_KEY_MODULE_PATH = "module.path";
    private static final String SYSPROP_KEY_SYSTEM_MODULES = "jboss.modules.system.pkgs";
    private static final String JBOSS_MODULES_DIR_NAME = "modules";
    private static final String MODULE_ID_JAR_RUNTIME = "org.wildfly.bootable-jar";
    private static final String BOOTABLE_JAR = "org.wildfly.core.jar.runtime.BootableJar";
    private static final String BOOTABLE_JAR_RUN_METHOD = "run";
    private static final String INSTALL_DIR = "--install-dir";
    private static final String SECMGR = "-secmgr";
    private static final String DISPLAY_GALLEON_CONFIG = "--display-galleon-config";
    private static final String WILDFLY_RESOURCE = "/wildfly.zip";
    private static final String PROVISIONING_RESOURCE = "/provisioning.xml";
    private static final String WILDFLY_BOOTABLE_TMP_DIR_PREFIX = "wildfly-bootable-server";
    private static final Set<PosixFilePermission> EXECUTE_PERMISSIONS = new HashSet<PosixFilePermission>();

    public static void main(String[] args) throws Exception {
        ArrayList<String> filteredArgs = new ArrayList<String>();
        Path installDir = null;
        boolean securityManager = false;
        boolean displayGalleonConfig = false;
        for (String string : args) {
            if (string.startsWith(INSTALL_DIR)) {
                installDir = Paths.get(Main.getValue(string), new String[0]);
                continue;
            }
            if (SECMGR.equals(string)) {
                securityManager = true;
                continue;
            }
            if (DISPLAY_GALLEON_CONFIG.equals(string)) {
                displayGalleonConfig = true;
                continue;
            }
            filteredArgs.add(string);
        }
        if (displayGalleonConfig) {
            try (InputStream provisioningFile = Main.class.getResourceAsStream(PROVISIONING_RESOURCE);){
                if (provisioningFile == null) {
                    throw new Exception("Resource /provisioning.xml doesn't exist, can't retrieve galleon configuration.");
                }
                Throwable throwable = null;
                try (InputStreamReader reader = new InputStreamReader(provisioningFile, StandardCharsets.UTF_8);
                     BufferedReader br = new BufferedReader(reader);){
                    while (br.ready()) {
                        System.out.println(br.readLine());
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            return;
        }
        SecurityManager existingSecMgr = System.getSecurityManager();
        if (existingSecMgr != null) {
            throw new Exception("An existing security manager was detected.  You must use the -secmgr switch to start with a security manager.");
        }
        installDir = installDir == null ? Files.createTempDirectory(WILDFLY_BOOTABLE_TMP_DIR_PREFIX, new FileAttribute[0]) : installDir;
        long t = System.currentTimeMillis();
        InputStream inputStream = Main.class.getResourceAsStream(WILDFLY_RESOURCE);
        Object object = null;
        try {
            if (inputStream == null) {
                throw new Exception("Resource /wildfly.zip doesn't exist, can't run.");
            }
            Main.unzip(inputStream, installDir);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (object != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        ServiceLoader<RuntimeExtension> serviceLoader = ServiceLoader.load(RuntimeExtension.class);
        for (RuntimeExtension extension : serviceLoader) {
            extension.boot(filteredArgs, installDir);
        }
        Main.runBootableJar(installDir, filteredArgs, System.currentTimeMillis() - t, securityManager);
    }

    private static String getValue(String arg) {
        int sep = arg.indexOf("=");
        if (sep == -1 || sep == arg.length() - 1) {
            throw new RuntimeException("Invalid argument " + arg + ", no value provided");
        }
        return arg.substring(sep + 1);
    }

    private static void runBootableJar(Path jbossHome, List<String> arguments, Long unzipTime, boolean securityManager) throws Exception {
        Method runMethod;
        Class<?> bjFactoryClass;
        Module bootableJarModule;
        String modulePath = jbossHome.resolve(JBOSS_MODULES_DIR_NAME).toAbsolutePath().toString();
        ModuleLoader moduleLoader = Main.setupModuleLoader(modulePath);
        __JAXPRedirected.changeAll(MODULE_ID_JAR_RUNTIME, moduleLoader);
        try {
            bootableJarModule = moduleLoader.loadModule(MODULE_ID_JAR_RUNTIME);
        }
        catch (ModuleLoadException mle) {
            throw new Exception(mle);
        }
        ModuleClassLoader moduleCL = bootableJarModule.getClassLoader();
        try {
            bjFactoryClass = moduleCL.loadClass(BOOTABLE_JAR);
        }
        catch (ClassNotFoundException cnfe) {
            throw new Exception(cnfe);
        }
        try {
            runMethod = bjFactoryClass.getMethod(BOOTABLE_JAR_RUN_METHOD, Path.class, List.class, ModuleLoader.class, ModuleClassLoader.class, Long.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new Exception(nsme);
        }
        if (securityManager) {
            BootablePolicy policy = new BootablePolicy(Policy.getPolicy());
            Policy.setPolicy(policy);
            Iterator<SecurityManager> iterator = bootableJarModule.loadService(SecurityManager.class).iterator();
            if (iterator.hasNext()) {
                System.setSecurityManager(iterator.next());
            } else {
                throw new IllegalStateException("No SecurityManager found to install.");
            }
        }
        runMethod.invoke(null, jbossHome, arguments, moduleLoader, moduleCL, unzipTime);
    }

    private static void unzip(InputStream wf, Path dir) throws Exception {
        boolean isWindows = Main.isWindows();
        try (ZipInputStream zis = new ZipInputStream(wf);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                Path newFile = dir.resolve(fileName);
                if (ze.isDirectory()) {
                    Files.createDirectories(newFile, new FileAttribute[0]);
                } else {
                    Path parent = newFile.getParent();
                    if (parent != null && Files.notExists(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    Files.copy(zis, newFile, StandardCopyOption.REPLACE_EXISTING);
                    if (!isWindows && newFile.getFileName().toString().endsWith(".sh")) {
                        Files.setPosixFilePermissions(newFile, EXECUTE_PERMISSIONS);
                    }
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }

    private static String trimPathToModulesDir(String modulePath) {
        int index = modulePath.indexOf(File.pathSeparator);
        return index == -1 ? modulePath : modulePath.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleLoader setupModuleLoader(String modulePath) {
        assert (modulePath != null) : "modulePath not null";
        Path moduleDir = Paths.get(Main.trimPathToModulesDir(modulePath), new String[0]);
        if (Files.notExists(moduleDir, new LinkOption[0]) || !Files.isDirectory(moduleDir, new LinkOption[0])) {
            throw new RuntimeException("The first directory of the specified module path " + modulePath + " is invalid or does not exist.");
        }
        String classPath = System.getProperty(SYSPROP_KEY_CLASS_PATH);
        try {
            System.clearProperty(SYSPROP_KEY_CLASS_PATH);
            System.setProperty(SYSPROP_KEY_MODULE_PATH, modulePath);
            StringBuilder packages = new StringBuilder("org.jboss.modules");
            String custompackages = System.getProperty(SYSPROP_KEY_SYSTEM_MODULES);
            if (custompackages != null) {
                packages.append(",").append(custompackages);
            }
            System.setProperty(SYSPROP_KEY_SYSTEM_MODULES, packages.toString());
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            return moduleLoader;
        }
        finally {
            if (classPath != null) {
                System.setProperty(SYSPROP_KEY_CLASS_PATH, classPath);
            }
        }
    }

    static {
        EXECUTE_PERMISSIONS.add(PosixFilePermission.OWNER_EXECUTE);
        EXECUTE_PERMISSIONS.add(PosixFilePermission.OWNER_WRITE);
        EXECUTE_PERMISSIONS.add(PosixFilePermission.OWNER_READ);
        EXECUTE_PERMISSIONS.add(PosixFilePermission.GROUP_EXECUTE);
        EXECUTE_PERMISSIONS.add(PosixFilePermission.GROUP_WRITE);
        EXECUTE_PERMISSIONS.add(PosixFilePermission.GROUP_READ);
        EXECUTE_PERMISSIONS.add(PosixFilePermission.OTHERS_EXECUTE);
        EXECUTE_PERMISSIONS.add(PosixFilePermission.OTHERS_READ);
    }
}

