/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.boot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public final class Main {
    private static final String SYSPROP_KEY_CLASS_PATH = "java.class.path";
    private static final String SYSPROP_KEY_MODULE_PATH = "module.path";
    private static final String SYSPROP_KEY_SYSTEM_MODULES = "jboss.modules.system.pkgs";
    private static final String JBOSS_MODULES_DIR_NAME = "modules";
    private static final String MODULE_ID_JAR_RUNTIME = "org.wildfly.bootable-jar";
    private static final String BOOTABLE_JAR = "org.wildfly.core.jar.runtime.BootableJar";
    private static final String BOOTABLE_JAR_RUN_METHOD = "run";
    private static final String INSTALL_DIR = "--install-dir";
    private static final String WILDFLY_RESOURCE = "/wildfly.zip";
    private static final String WILDFLY_BOOTABLE_TMP_DIR_PREFIX = "wildfly-bootable-server";

    public static void main(String[] args) throws Exception {
        ArrayList<String> filteredArgs = new ArrayList<String>();
        Path installDir = null;
        for (String arg : args) {
            if (arg.startsWith(INSTALL_DIR)) {
                installDir = Paths.get(Main.getValue(arg), new String[0]);
                continue;
            }
            filteredArgs.add(arg);
        }
        installDir = installDir == null ? Files.createTempDirectory(WILDFLY_BOOTABLE_TMP_DIR_PREFIX, new FileAttribute[0]) : installDir;
        long t = System.currentTimeMillis();
        try (InputStream wf = Main.class.getResourceAsStream(WILDFLY_RESOURCE);){
            if (wf == null) {
                throw new Exception("Resource /wildfly.zip doesn't exist, can't run.");
            }
            Main.unzip(wf, installDir.toFile());
        }
        Main.runBootableJar(installDir, filteredArgs, System.currentTimeMillis() - t);
    }

    private static String getValue(String arg) {
        int sep = arg.indexOf("=");
        if (sep == -1 || sep == arg.length() - 1) {
            throw new RuntimeException("Invalid argument " + arg + ", no value provided");
        }
        return arg.substring(sep + 1);
    }

    private static void runBootableJar(Path jbossHome, List<String> arguments, Long unzipTime) throws Exception {
        Method runMethod;
        Class<?> bjFactoryClass;
        Module bootableJarModule;
        String modulePath = jbossHome.resolve(JBOSS_MODULES_DIR_NAME).toAbsolutePath().toString();
        ModuleLoader moduleLoader = Main.setupModuleLoader(modulePath);
        try {
            bootableJarModule = moduleLoader.loadModule(MODULE_ID_JAR_RUNTIME);
        }
        catch (ModuleLoadException mle) {
            throw new Exception(mle);
        }
        ModuleClassLoader moduleCL = bootableJarModule.getClassLoader();
        try {
            bjFactoryClass = moduleCL.loadClass(BOOTABLE_JAR);
        }
        catch (ClassNotFoundException cnfe) {
            throw new Exception(cnfe);
        }
        try {
            runMethod = bjFactoryClass.getMethod(BOOTABLE_JAR_RUN_METHOD, Path.class, List.class, ModuleLoader.class, ModuleClassLoader.class, Long.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new Exception(nsme);
        }
        runMethod.invoke(null, jbossHome, arguments, moduleLoader, moduleCL, unzipTime);
    }

    private static void unzip(InputStream wf, File dir) throws Exception {
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(wf);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(dir, fileName);
                if (fileName.endsWith("/")) {
                    newFile.mkdirs();
                    zis.closeEntry();
                    ze = zis.getNextEntry();
                    continue;
                }
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
        }
    }

    private static String trimPathToModulesDir(String modulePath) {
        int index = modulePath.indexOf(File.pathSeparator);
        return index == -1 ? modulePath : modulePath.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleLoader setupModuleLoader(String modulePath) {
        assert (modulePath != null) : "modulePath not null";
        Path moduleDir = Paths.get(Main.trimPathToModulesDir(modulePath), new String[0]);
        if (Files.notExists(moduleDir, new LinkOption[0]) || !Files.isDirectory(moduleDir, new LinkOption[0])) {
            throw new RuntimeException("The first directory of the specified module path " + modulePath + " is invalid or does not exist.");
        }
        String classPath = System.getProperty(SYSPROP_KEY_CLASS_PATH);
        try {
            System.clearProperty(SYSPROP_KEY_CLASS_PATH);
            System.setProperty(SYSPROP_KEY_MODULE_PATH, modulePath);
            StringBuilder packages = new StringBuilder("org.jboss.modules");
            String custompackages = System.getProperty(SYSPROP_KEY_SYSTEM_MODULES);
            if (custompackages != null) {
                packages.append(",").append(custompackages);
            }
            System.setProperty(SYSPROP_KEY_SYSTEM_MODULES, packages.toString());
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            return moduleLoader;
        }
        finally {
            if (classPath != null) {
                System.setProperty(SYSPROP_KEY_CLASS_PATH, classPath);
            }
        }
    }
}

