/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.Optional;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.io.IOSubsystemRegistrar;
import org.wildfly.extension.io.WorkerResourceDefinition;
import org.wildfly.extension.io.logging.IOLogger;
import org.xnio.XnioWorker;
import org.xnio.management.XnioServerMXBean;
import org.xnio.management.XnioWorkerMXBean;

public class WorkerServerDefinition
extends SimpleResourceDefinition {
    private static final PathElement PATH = PathElement.pathElement((String)"server");
    private static final SimpleAttributeDefinition CONNECTION_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-count", ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition CONNECTION_LIMIT_HIGH_MARK = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-limit-high-water-mark", ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition CONNECTION_LIMIT_LOW_MARK = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-limit-low-water-mark", ModelType.INT).setStorageRuntime()).build();
    static final ModelNode NO_METRICS = new ModelNode(IOLogger.ROOT_LOGGER.noMetrics());

    WorkerServerDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, (ResourceDescriptionResolver)IOSubsystemRegistrar.RESOLVER.createChildResolver(PathElement.pathElement((String)WorkerResourceDefinition.PATH.getKey(), (String)PATH.getKey()))).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerMetric((AttributeDefinition)CONNECTION_COUNT, (OperationStepHandler)new ServerMetricsHandler(){

            @Override
            ModelNode getMetricValue(XnioServerMXBean metrics) {
                return new ModelNode(metrics.getConnectionCount());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CONNECTION_LIMIT_HIGH_MARK, (OperationStepHandler)new ServerMetricsHandler(){

            @Override
            ModelNode getMetricValue(XnioServerMXBean metrics) {
                return new ModelNode(metrics.getConnectionLimitHighWater());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CONNECTION_LIMIT_LOW_MARK, (OperationStepHandler)new ServerMetricsHandler(){

            @Override
            ModelNode getMetricValue(XnioServerMXBean metrics) {
                return new ModelNode(metrics.getConnectionLimitLowWater());
            }
        });
    }

    private static abstract class ServerMetricsHandler
    implements OperationStepHandler {
        private ServerMetricsHandler() {
        }

        abstract ModelNode getMetricValue(XnioServerMXBean var1);

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            XnioWorker worker = WorkerResourceDefinition.getXnioWorker(context);
            if (worker == null || worker.getMXBean() == null) {
                context.getResult().set(NO_METRICS);
                return;
            }
            XnioWorkerMXBean metrics = worker.getMXBean();
            Optional<Object> serverMetrics = Optional.empty();
            for (XnioServerMXBean xnioServerMXBean : metrics.getServerMXBeans()) {
                if (!xnioServerMXBean.getBindAddress().equals(context.getCurrentAddressValue())) continue;
                serverMetrics = Optional.of(xnioServerMXBean);
                break;
            }
            if (serverMetrics.isPresent()) {
                context.getResult().set(this.getMetricValue((XnioServerMXBean)serverMetrics.get()));
            } else {
                context.getResult().set(NO_METRICS);
            }
        }
    }
}

